/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.RulesAlert;
import io.fabric8.openshift.api.model.monitoring.v1.RulesAlertFluent;
import io.fabric8.openshift.api.model.monitoring.v1.RulesAlertFluentImpl;
import java.util.Objects;

public class RulesAlertBuilder
extends RulesAlertFluentImpl<RulesAlertBuilder>
implements VisitableBuilder<RulesAlert, RulesAlertBuilder> {
    RulesAlertFluent<?> fluent;
    Boolean validationEnabled;

    public RulesAlertBuilder() {
        this(false);
    }

    public RulesAlertBuilder(Boolean validationEnabled) {
        this(new RulesAlert(), validationEnabled);
    }

    public RulesAlertBuilder(RulesAlertFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public RulesAlertBuilder(RulesAlertFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new RulesAlert(), validationEnabled);
    }

    public RulesAlertBuilder(RulesAlertFluent<?> fluent, RulesAlert instance) {
        this(fluent, instance, false);
    }

    public RulesAlertBuilder(RulesAlertFluent<?> fluent, RulesAlert instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withForGracePeriod(instance.getForGracePeriod());
        fluent.withForOutageTolerance(instance.getForOutageTolerance());
        fluent.withResendDelay(instance.getResendDelay());
        this.validationEnabled = validationEnabled;
    }

    public RulesAlertBuilder(RulesAlert instance) {
        this(instance, (Boolean)false);
    }

    public RulesAlertBuilder(RulesAlert instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withForGracePeriod(instance.getForGracePeriod());
        this.withForOutageTolerance(instance.getForOutageTolerance());
        this.withResendDelay(instance.getResendDelay());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public RulesAlert build() {
        RulesAlert buildable = new RulesAlert(this.fluent.getForGracePeriod(), this.fluent.getForOutageTolerance(), this.fluent.getResendDelay());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RulesAlertBuilder that = (RulesAlertBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

