/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.QueueConfig;
import io.fabric8.openshift.api.model.monitoring.v1.QueueConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1.QueueConfigFluentImpl;
import java.util.Objects;

public class QueueConfigBuilder
extends QueueConfigFluentImpl<QueueConfigBuilder>
implements VisitableBuilder<QueueConfig, QueueConfigBuilder> {
    QueueConfigFluent<?> fluent;
    Boolean validationEnabled;

    public QueueConfigBuilder() {
        this(false);
    }

    public QueueConfigBuilder(Boolean validationEnabled) {
        this(new QueueConfig(), validationEnabled);
    }

    public QueueConfigBuilder(QueueConfigFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public QueueConfigBuilder(QueueConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new QueueConfig(), validationEnabled);
    }

    public QueueConfigBuilder(QueueConfigFluent<?> fluent, QueueConfig instance) {
        this(fluent, instance, false);
    }

    public QueueConfigBuilder(QueueConfigFluent<?> fluent, QueueConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withBatchSendDeadline(instance.getBatchSendDeadline());
        fluent.withCapacity(instance.getCapacity());
        fluent.withMaxBackoff(instance.getMaxBackoff());
        fluent.withMaxRetries(instance.getMaxRetries());
        fluent.withMaxSamplesPerSend(instance.getMaxSamplesPerSend());
        fluent.withMaxShards(instance.getMaxShards());
        fluent.withMinBackoff(instance.getMinBackoff());
        fluent.withMinShards(instance.getMinShards());
        this.validationEnabled = validationEnabled;
    }

    public QueueConfigBuilder(QueueConfig instance) {
        this(instance, (Boolean)false);
    }

    public QueueConfigBuilder(QueueConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withBatchSendDeadline(instance.getBatchSendDeadline());
        this.withCapacity(instance.getCapacity());
        this.withMaxBackoff(instance.getMaxBackoff());
        this.withMaxRetries(instance.getMaxRetries());
        this.withMaxSamplesPerSend(instance.getMaxSamplesPerSend());
        this.withMaxShards(instance.getMaxShards());
        this.withMinBackoff(instance.getMinBackoff());
        this.withMinShards(instance.getMinShards());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public QueueConfig build() {
        QueueConfig buildable = new QueueConfig(this.fluent.getBatchSendDeadline(), this.fluent.getCapacity(), this.fluent.getMaxBackoff(), this.fluent.getMaxRetries(), this.fluent.getMaxSamplesPerSend(), this.fluent.getMaxShards(), this.fluent.getMinBackoff(), this.fluent.getMinShards());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        QueueConfigBuilder that = (QueueConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

