/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.ClusterVersion;
import io.fabric8.openshift.api.model.ClusterVersionFluent;
import io.fabric8.openshift.api.model.ClusterVersionSpec;
import io.fabric8.openshift.api.model.ClusterVersionSpecBuilder;
import io.fabric8.openshift.api.model.ClusterVersionSpecFluentImpl;
import io.fabric8.openshift.api.model.ClusterVersionStatus;
import io.fabric8.openshift.api.model.ClusterVersionStatusBuilder;
import io.fabric8.openshift.api.model.ClusterVersionStatusFluentImpl;
import java.util.Objects;

public class ClusterVersionFluentImpl<A extends ClusterVersionFluent<A>>
extends BaseFluent<A>
implements ClusterVersionFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private ClusterVersionSpecBuilder spec;
    private ClusterVersionStatusBuilder status;

    public ClusterVersionFluentImpl() {
    }

    public ClusterVersionFluentImpl(ClusterVersion instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ClusterVersionFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ClusterVersionFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ClusterVersionFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ClusterVersionFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ClusterVersionFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public ClusterVersionSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public ClusterVersionSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(ClusterVersionSpec spec) {
        this._visitables.get("spec").remove(this.spec);
        if (spec != null) {
            this.spec = new ClusterVersionSpecBuilder(spec);
            this._visitables.get("spec").add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public ClusterVersionFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public ClusterVersionFluent.SpecNested<A> withNewSpecLike(ClusterVersionSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public ClusterVersionFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public ClusterVersionFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new ClusterVersionSpecBuilder().build());
    }

    @Override
    public ClusterVersionFluent.SpecNested<A> editOrNewSpecLike(ClusterVersionSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public ClusterVersionStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public ClusterVersionStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(ClusterVersionStatus status) {
        this._visitables.get("status").remove(this.status);
        if (status != null) {
            this.status = new ClusterVersionStatusBuilder(status);
            this._visitables.get("status").add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public ClusterVersionFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public ClusterVersionFluent.StatusNested<A> withNewStatusLike(ClusterVersionStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public ClusterVersionFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public ClusterVersionFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new ClusterVersionStatusBuilder().build());
    }

    @Override
    public ClusterVersionFluent.StatusNested<A> editOrNewStatusLike(ClusterVersionStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterVersionFluentImpl that = (ClusterVersionFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, super.hashCode());
    }

    public class StatusNestedImpl<N>
    extends ClusterVersionStatusFluentImpl<ClusterVersionFluent.StatusNested<N>>
    implements ClusterVersionFluent.StatusNested<N>,
    Nested<N> {
        ClusterVersionStatusBuilder builder;

        StatusNestedImpl(ClusterVersionStatus item) {
            this.builder = new ClusterVersionStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new ClusterVersionStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterVersionFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends ClusterVersionSpecFluentImpl<ClusterVersionFluent.SpecNested<N>>
    implements ClusterVersionFluent.SpecNested<N>,
    Nested<N> {
        ClusterVersionSpecBuilder builder;

        SpecNestedImpl(ClusterVersionSpec item) {
            this.builder = new ClusterVersionSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new ClusterVersionSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterVersionFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ClusterVersionFluent.MetadataNested<N>>
    implements ClusterVersionFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterVersionFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

