/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.base;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.DeleteOptions;
import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Preconditions;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.StatusBuilder;
import io.fabric8.kubernetes.api.model.autoscaling.v1.Scale;
import io.fabric8.kubernetes.api.model.extensions.DeploymentRollback;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.dsl.base.PatchContext;
import io.fabric8.kubernetes.client.dsl.base.PatchType;
import io.fabric8.kubernetes.client.internal.PatchUtils;
import io.fabric8.kubernetes.client.utils.ExponentialBackoffIntervalCalculator;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.zjsonpatch.JsonDiff;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationSupport {
    public static final MediaType JSON = MediaType.parse((String)"application/json");
    public static final MediaType JSON_PATCH = MediaType.parse((String)"application/json-patch+json");
    public static final MediaType STRATEGIC_MERGE_JSON_PATCH = MediaType.parse((String)"application/strategic-merge-patch+json");
    public static final MediaType JSON_MERGE_PATCH = MediaType.parse((String)"application/merge-patch+json");
    protected static final ObjectMapper JSON_MAPPER = Serialization.jsonMapper();
    protected static final ObjectMapper YAML_MAPPER = Serialization.yamlMapper();
    private static final Logger LOG = LoggerFactory.getLogger(OperationSupport.class);
    private static final String CLIENT_STATUS_FLAG = "CLIENT_STATUS_FLAG";
    private static final int maxRetryIntervalExponent = 5;
    protected OperationContext context;
    protected final OkHttpClient client;
    protected final Config config;
    protected final String resourceT;
    protected String namespace;
    protected String name;
    protected String apiGroupName;
    protected String apiGroupVersion;
    protected boolean dryRun;
    private final ExponentialBackoffIntervalCalculator retryIntervalCalculator;
    private final int requestRetryBackoffLimit;

    public OperationSupport() {
        this(new OperationContext());
    }

    public OperationSupport(OkHttpClient client, Config config) {
        this(new OperationContext().withOkhttpClient(client).withConfig(config));
    }

    public OperationSupport(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodInSeconds) {
        this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withPropagationPolicy(propagationPolicy).withGracePeriodSeconds(gracePeriodInSeconds));
    }

    public OperationSupport(OperationContext ctx) {
        int requestRetryBackoffInterval;
        this.context = ctx;
        this.client = ctx.getClient();
        this.config = ctx.getConfig();
        this.resourceT = ctx.getPlural();
        this.namespace = ctx.getNamespace();
        this.name = ctx.getName();
        this.apiGroupName = ctx.getApiGroupName();
        this.dryRun = ctx.getDryRun();
        this.apiGroupVersion = ctx.getApiGroupVersion() != null ? ctx.getApiGroupVersion() : (ctx.getConfig() != null ? ctx.getConfig().getApiVersion() : "v1");
        if (ctx.getConfig() != null) {
            requestRetryBackoffInterval = ctx.getConfig().getRequestRetryBackoffInterval();
            this.requestRetryBackoffLimit = ctx.getConfig().getRequestRetryBackoffLimit();
        } else {
            requestRetryBackoffInterval = Config.DEFAULT_REQUEST_RETRY_BACKOFFINTERVAL;
            this.requestRetryBackoffLimit = Config.DEFAULT_REQUEST_RETRY_BACKOFFLIMIT;
        }
        this.retryIntervalCalculator = new ExponentialBackoffIntervalCalculator(requestRetryBackoffInterval, 5);
    }

    public String getAPIGroupName() {
        return this.apiGroupName;
    }

    public String getAPIGroupVersion() {
        return this.apiGroupVersion;
    }

    public String getResourceT() {
        return this.resourceT;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public boolean isResourceNamespaced() {
        return true;
    }

    public URL getRootUrl() {
        try {
            if (!Utils.isNullOrEmpty(this.apiGroupName)) {
                return new URL(URLUtils.join(this.config.getMasterUrl().toString(), "apis", this.apiGroupName, this.apiGroupVersion));
            }
            return new URL(URLUtils.join(this.config.getMasterUrl().toString(), "api", this.apiGroupVersion));
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public URL getNamespacedUrl(String namespace) throws MalformedURLException {
        URL requestUrl = this.getRootUrl();
        if (this.isResourceNamespaced() && Utils.isNotNullOrEmpty(namespace)) {
            requestUrl = new URL(URLUtils.join(requestUrl.toString(), "namespaces", namespace));
        }
        requestUrl = new URL(URLUtils.join(requestUrl.toString(), this.resourceT));
        return requestUrl;
    }

    public URL getNamespacedUrl() throws MalformedURLException {
        return this.getNamespacedUrl(this.getNamespace());
    }

    public <T> URL getNamespacedUrl(T item) throws MalformedURLException {
        return this.getNamespacedUrl(this.checkNamespace(item));
    }

    public URL getResourceUrl(String namespace, String name) throws MalformedURLException {
        return this.getResourceUrl(namespace, name, false);
    }

    public URL getResourceUrl(String namespace, String name, boolean status) throws MalformedURLException {
        if (name == null) {
            if (status) {
                throw new KubernetesClientException("name not specified for an operation requiring one.");
            }
            return this.getNamespacedUrl(namespace);
        }
        if (status) {
            return new URL(URLUtils.join(this.getNamespacedUrl(namespace).toString(), name, "status"));
        }
        return new URL(URLUtils.join(this.getNamespacedUrl(namespace).toString(), name));
    }

    public URL getResourceUrl() throws MalformedURLException {
        if (this.name == null) {
            return this.getNamespacedUrl();
        }
        return new URL(URLUtils.join(this.getNamespacedUrl().toString(), this.name));
    }

    public URL getResourceURLForWriteOperation(URL resourceURL) throws MalformedURLException {
        if (this.dryRun) {
            return new URL(URLUtils.join(resourceURL.toString(), "?dryRun=All"));
        }
        return resourceURL;
    }

    public URL getResourceURLForPatchOperation(URL resourceUrl, PatchContext patchContext) throws MalformedURLException {
        if (patchContext != null) {
            String url = resourceUrl.toString();
            if (patchContext.getForce() != null) {
                url = URLUtils.join(url, "?force=" + patchContext.getForce());
            }
            if (patchContext.getDryRun() != null && !patchContext.getDryRun().isEmpty() || this.dryRun) {
                url = URLUtils.join(url, "?dryRun=All");
            }
            if (patchContext.getFieldManager() != null) {
                url = URLUtils.join(url, "?fieldManager=" + patchContext.getFieldManager());
            }
            return new URL(url);
        }
        return resourceUrl;
    }

    protected <T> String checkNamespace(T item) {
        String itemNs;
        String operationNs = this.getNamespace();
        String string = itemNs = item instanceof HasMetadata ? KubernetesResourceUtil.getNamespace((HasMetadata)item) : null;
        if (Utils.isNullOrEmpty(operationNs) && Utils.isNullOrEmpty(itemNs)) {
            if (!this.isResourceNamespaced()) {
                return null;
            }
            throw new KubernetesClientException("namespace not specified for an operation requiring one.");
        }
        if (Utils.isNullOrEmpty(itemNs)) {
            return operationNs;
        }
        if (Utils.isNullOrEmpty(operationNs)) {
            return itemNs;
        }
        if (itemNs.equals(operationNs)) {
            return itemNs;
        }
        throw new KubernetesClientException("Namespace mismatch. Item namespace:" + itemNs + ". Operation namespace:" + operationNs + ".");
    }

    protected <T> String checkName(T item) {
        String itemName;
        String operationName = this.getName();
        ObjectMeta metadata = item instanceof HasMetadata ? ((HasMetadata)item).getMetadata() : null;
        String string = itemName = metadata != null ? metadata.getName() : null;
        if (Utils.isNullOrEmpty(operationName) && Utils.isNullOrEmpty(itemName)) {
            return null;
        }
        if (Utils.isNullOrEmpty(itemName)) {
            return operationName;
        }
        if (Utils.isNullOrEmpty(operationName)) {
            return itemName;
        }
        if (itemName.equals(operationName)) {
            return itemName;
        }
        throw new KubernetesClientException("Name mismatch. Item name:" + itemName + ". Operation name:" + operationName + ".");
    }

    protected <T> T handleMetric(String resourceUrl, Class<T> type) throws InterruptedException, IOException, ExecutionException {
        Request.Builder requestBuilder = new Request.Builder().get().url(resourceUrl);
        return this.handleResponse(requestBuilder, type);
    }

    protected <T> void handleDelete(T resource, long gracePeriodSeconds, DeletionPropagation propagationPolicy, String resourceVersion, boolean cascading) throws ExecutionException, InterruptedException, IOException {
        this.handleDelete(this.getResourceURLForWriteOperation(this.getResourceUrl(this.checkNamespace(resource), this.checkName(resource))), gracePeriodSeconds, propagationPolicy, resourceVersion, cascading);
    }

    protected void handleDelete(URL requestUrl, long gracePeriodSeconds, DeletionPropagation propagationPolicy, String resourceVersion, boolean cascading) throws ExecutionException, InterruptedException, IOException {
        RequestBody requestBody = null;
        DeleteOptions deleteOptions = new DeleteOptions();
        if (gracePeriodSeconds >= 0L) {
            deleteOptions.setGracePeriodSeconds(gracePeriodSeconds);
        }
        if (resourceVersion != null) {
            deleteOptions.setPreconditions(new Preconditions(resourceVersion, null));
        }
        if (propagationPolicy != null) {
            deleteOptions.setPropagationPolicy(propagationPolicy.toString());
        } else {
            deleteOptions.setOrphanDependents(!cascading);
        }
        if (this.dryRun) {
            deleteOptions.setDryRun(Collections.singletonList("All"));
        }
        requestBody = RequestBody.create((MediaType)JSON, (String)JSON_MAPPER.writeValueAsString((Object)deleteOptions));
        Request.Builder requestBuilder = new Request.Builder().delete(requestBody).url(requestUrl);
        this.handleResponse(requestBuilder, null, Collections.emptyMap());
    }

    protected <T, I> T handleCreate(I resource, Class<T> outputType) throws ExecutionException, InterruptedException, IOException {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)JSON_MAPPER.writeValueAsString(resource));
        Request.Builder requestBuilder = new Request.Builder().post(body).url(this.getResourceURLForWriteOperation(this.getResourceUrl(this.checkNamespace(resource), null)));
        return this.handleResponse(requestBuilder, outputType, Collections.emptyMap());
    }

    protected <T> T handleUpdate(T updated, Class<T> type, boolean status) throws ExecutionException, InterruptedException, IOException {
        return this.handleUpdate(updated, type, Collections.emptyMap(), status);
    }

    protected <T> T handleUpdate(T updated, Class<T> type, Map<String, String> parameters, boolean status) throws ExecutionException, InterruptedException, IOException {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)JSON_MAPPER.writeValueAsString(updated));
        Request.Builder requestBuilder = new Request.Builder().put(body).url(this.getResourceURLForWriteOperation(this.getResourceUrl(this.checkNamespace(updated), this.checkName(updated), status)));
        return this.handleResponse(requestBuilder, type, parameters);
    }

    protected <T> T handlePatch(PatchContext patchContext, T current, T updated, Class<T> type, boolean status) throws ExecutionException, InterruptedException, IOException {
        String patchForUpdate = null;
        if (current != null && (patchContext == null || patchContext.getPatchType() == PatchType.JSON)) {
            patchForUpdate = JSON_MAPPER.writeValueAsString((Object)JsonDiff.asJson((JsonNode)PatchUtils.patchMapper().valueToTree(current), (JsonNode)PatchUtils.patchMapper().valueToTree(updated)));
            if (patchContext == null) {
                patchContext = new PatchContext.Builder().withPatchType(PatchType.JSON).build();
            }
        } else {
            patchForUpdate = Serialization.asJson(updated);
            current = updated;
        }
        return this.handlePatch(patchContext, current, patchForUpdate, type, status);
    }

    protected <T> T handlePatch(T current, Map<String, Object> patchForUpdate, Class<T> type) throws ExecutionException, InterruptedException, IOException {
        return this.handlePatch(new PatchContext.Builder().withPatchType(PatchType.STRATEGIC_MERGE).build(), current, JSON_MAPPER.writeValueAsString(patchForUpdate), type, false);
    }

    protected <T> T handlePatch(PatchContext patchContext, T current, String patchForUpdate, Class<T> type, boolean status) throws ExecutionException, InterruptedException, IOException {
        MediaType bodyMediaType = this.getMediaTypeFromPatchContextOrDefault(patchContext);
        RequestBody body = RequestBody.create((MediaType)bodyMediaType, (String)patchForUpdate);
        Request.Builder requestBuilder = new Request.Builder().patch(body).url(this.getResourceURLForPatchOperation(this.getResourceUrl(this.checkNamespace(current), this.checkName(current), status), patchContext));
        return this.handleResponse(requestBuilder, type, Collections.emptyMap());
    }

    protected Scale handleScale(String resourceUrl, Scale scale) throws ExecutionException, InterruptedException, IOException {
        Request.Builder requestBuilder;
        if (scale != null) {
            RequestBody body = RequestBody.create((MediaType)JSON, (String)JSON_MAPPER.writeValueAsString((Object)scale));
            requestBuilder = new Request.Builder().put(body).url(resourceUrl + "/scale");
        } else {
            requestBuilder = new Request.Builder().get().url(resourceUrl + "/scale");
        }
        return this.handleResponse(requestBuilder, Scale.class);
    }

    protected Status handleDeploymentRollback(String resourceUrl, DeploymentRollback deploymentRollback) throws ExecutionException, InterruptedException, IOException {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)JSON_MAPPER.writeValueAsString((Object)deploymentRollback));
        Request.Builder requestBuilder = new Request.Builder().post(body).url(resourceUrl + "/rollback");
        return this.handleResponse(requestBuilder, Status.class);
    }

    protected <T> T handleGet(URL resourceUrl, Class<T> type) throws ExecutionException, InterruptedException, IOException {
        return this.handleGet(resourceUrl, type, Collections.emptyMap());
    }

    protected <T> T handleGet(URL resourceUrl, Class<T> type, Map<String, String> parameters) throws ExecutionException, InterruptedException, IOException {
        Request.Builder requestBuilder = new Request.Builder().get().url(resourceUrl);
        return this.handleResponse(requestBuilder, type, parameters);
    }

    protected <T> T handleResponse(Request.Builder requestBuilder, Class<T> type) throws ExecutionException, InterruptedException, IOException {
        return this.handleResponse(requestBuilder, type, Collections.emptyMap());
    }

    protected <T> T handleResponse(Request.Builder requestBuilder, Class<T> type, Map<String, String> parameters) throws ExecutionException, InterruptedException, IOException {
        return this.handleResponse(this.client, requestBuilder, type, parameters);
    }

    protected <T> T handleResponse(OkHttpClient client, Request.Builder requestBuilder, Class<T> type) throws ExecutionException, InterruptedException, IOException {
        return this.handleResponse(client, requestBuilder, type, Collections.emptyMap());
    }

    /*
     * Exception decompiling
     */
    protected <T> T handleResponse(OkHttpClient client, Request.Builder requestBuilder, Class<T> type, Map<String, String> parameters) throws ExecutionException, InterruptedException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 36[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Response retryWithExponentialBackoff(OkHttpClient client, Request request) throws InterruptedException, IOException {
        int numRetries = 0;
        while (true) {
            long retryInterval;
            try {
                Response response = client.newCall(request).execute();
                if (numRetries >= this.requestRetryBackoffLimit || response.code() < 500) {
                    return response;
                }
                retryInterval = this.retryIntervalCalculator.getInterval(numRetries);
                LOG.debug("HTTP operation on url: {} should be retried as the response code was {}, retrying after {} millis", new Object[]{request.url(), response.code(), retryInterval});
            }
            catch (IOException ie) {
                if (numRetries < this.requestRetryBackoffLimit) {
                    retryInterval = this.retryIntervalCalculator.getInterval(numRetries);
                    LOG.debug(String.format("HTTP operation on url: %s should be retried after %d millis because of IOException", request.url(), retryInterval), (Throwable)ie);
                }
                throw ie;
            }
            Thread.sleep(retryInterval);
            ++numRetries;
        }
    }

    protected void assertResponseCode(Request request, Response response) {
        int statusCode = response.code();
        String customMessage = this.config.getErrorMessages().get(statusCode);
        if (response.isSuccessful()) {
            return;
        }
        if (customMessage != null) {
            throw OperationSupport.requestFailure(request, OperationSupport.createStatus(statusCode, this.combineMessages(customMessage, OperationSupport.createStatus(response))));
        }
        throw OperationSupport.requestFailure(request, OperationSupport.createStatus(response));
    }

    private String combineMessages(String customMessage, Status defaultStatus) {
        String message;
        if (defaultStatus != null && (message = defaultStatus.getMessage()) != null && message.length() > 0) {
            return customMessage + " " + message;
        }
        return customMessage;
    }

    public static Status createStatus(Response response) {
        String statusMessage = "";
        ResponseBody body = response != null ? response.body() : null;
        int statusCode = response != null ? response.code() : 0;
        try {
            if (response == null) {
                statusMessage = "No response";
            } else if (body != null) {
                statusMessage = body.string();
            } else if (response.message() != null) {
                statusMessage = response.message();
            }
            Status status = (Status)JSON_MAPPER.readValue(statusMessage, Status.class);
            if (status.getCode() == null) {
                status = ((StatusBuilder)new StatusBuilder(status).withCode(statusCode)).build();
            }
            return status;
        }
        catch (JsonParseException e) {
            return OperationSupport.createStatus(statusCode, statusMessage);
        }
        catch (IOException e) {
            return OperationSupport.createStatus(statusCode, statusMessage);
        }
    }

    public static Status createStatus(int statusCode, String message) {
        Status status = ((StatusBuilder)((StatusBuilder)new StatusBuilder().withCode(statusCode)).withMessage(message)).build();
        status.getAdditionalProperties().put(CLIENT_STATUS_FLAG, "true");
        return status;
    }

    public static KubernetesClientException requestFailure(Request request, Status status) {
        StringBuilder sb = new StringBuilder();
        sb.append("Failure executing: ").append(request.method()).append(" at: ").append(request.url().toString()).append(".");
        if (status.getMessage() != null && !status.getMessage().isEmpty()) {
            sb.append(" Message: ").append(status.getMessage()).append(".");
        }
        if (status != null && !status.getAdditionalProperties().containsKey(CLIENT_STATUS_FLAG)) {
            sb.append(" Received status: ").append(status).append(".");
        }
        return new KubernetesClientException(sb.toString(), status.getCode(), status);
    }

    public static KubernetesClientException requestException(Request request, Exception e) {
        StringBuilder sb = new StringBuilder();
        sb.append("Error executing: ").append(request.method()).append(" at: ").append(request.url().toString()).append(". Cause: ").append(e.getMessage());
        return new KubernetesClientException(sb.toString(), e);
    }

    protected static <T> T unmarshal(InputStream is) {
        return Serialization.unmarshal(is);
    }

    protected static <T> T unmarshal(InputStream is, Class<T> type) {
        return Serialization.unmarshal(is, type);
    }

    protected static <T> T unmarshal(InputStream is, TypeReference<T> type) {
        return Serialization.unmarshal(is, type);
    }

    protected static <T> Map getObjectValueAsMap(T object) {
        return (Map)JSON_MAPPER.convertValue(object, Map.class);
    }

    public Config getConfig() {
        return this.config;
    }

    private MediaType getMediaTypeFromPatchContextOrDefault(PatchContext patchContext) {
        if (patchContext != null && patchContext.getPatchType() != null) {
            return patchContext.getPatchType().getMediaType();
        }
        return STRATEGIC_MERGE_JSON_PATCH;
    }
}

