/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_7;

import io.fabric8.kubernetes.api.builder.v5_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_7.Nested;
import io.fabric8.kubernetes.api.model.v5_7.ObjectMeta;
import io.fabric8.kubernetes.api.model.v5_7.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v5_7.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.v5_7.ObjectReference;
import io.fabric8.kubernetes.api.model.v5_7.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v5_7.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.v5_7.UserIdentityMapping;
import io.fabric8.openshift.api.model.v5_7.UserIdentityMappingFluent;
import java.util.Objects;

public class UserIdentityMappingFluentImpl<A extends UserIdentityMappingFluent<A>>
extends BaseFluent<A>
implements UserIdentityMappingFluent<A> {
    private String apiVersion;
    private ObjectReferenceBuilder identity;
    private String kind;
    private ObjectMetaBuilder metadata;
    private ObjectReferenceBuilder user;

    public UserIdentityMappingFluentImpl() {
    }

    public UserIdentityMappingFluentImpl(UserIdentityMapping instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withIdentity(instance.getIdentity());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withUser(instance.getUser());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    @Deprecated
    public ObjectReference getIdentity() {
        return this.identity != null ? this.identity.build() : null;
    }

    @Override
    public ObjectReference buildIdentity() {
        return this.identity != null ? this.identity.build() : null;
    }

    @Override
    public A withIdentity(ObjectReference identity) {
        this._visitables.get("identity").remove(this.identity);
        if (identity != null) {
            this.identity = new ObjectReferenceBuilder(identity);
            this._visitables.get("identity").add(this.identity);
        }
        return (A)this;
    }

    @Override
    public Boolean hasIdentity() {
        return this.identity != null;
    }

    @Override
    public UserIdentityMappingFluent.IdentityNested<A> withNewIdentity() {
        return new IdentityNestedImpl();
    }

    @Override
    public UserIdentityMappingFluent.IdentityNested<A> withNewIdentityLike(ObjectReference item) {
        return new IdentityNestedImpl(item);
    }

    @Override
    public UserIdentityMappingFluent.IdentityNested<A> editIdentity() {
        return this.withNewIdentityLike(this.getIdentity());
    }

    @Override
    public UserIdentityMappingFluent.IdentityNested<A> editOrNewIdentity() {
        return this.withNewIdentityLike(this.getIdentity() != null ? this.getIdentity() : new ObjectReferenceBuilder().build());
    }

    @Override
    public UserIdentityMappingFluent.IdentityNested<A> editOrNewIdentityLike(ObjectReference item) {
        return this.withNewIdentityLike(this.getIdentity() != null ? this.getIdentity() : item);
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public UserIdentityMappingFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public UserIdentityMappingFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public UserIdentityMappingFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public UserIdentityMappingFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public UserIdentityMappingFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public ObjectReference getUser() {
        return this.user != null ? this.user.build() : null;
    }

    @Override
    public ObjectReference buildUser() {
        return this.user != null ? this.user.build() : null;
    }

    @Override
    public A withUser(ObjectReference user) {
        this._visitables.get("user").remove(this.user);
        if (user != null) {
            this.user = new ObjectReferenceBuilder(user);
            this._visitables.get("user").add(this.user);
        }
        return (A)this;
    }

    @Override
    public Boolean hasUser() {
        return this.user != null;
    }

    @Override
    public UserIdentityMappingFluent.UserNested<A> withNewUser() {
        return new UserNestedImpl();
    }

    @Override
    public UserIdentityMappingFluent.UserNested<A> withNewUserLike(ObjectReference item) {
        return new UserNestedImpl(item);
    }

    @Override
    public UserIdentityMappingFluent.UserNested<A> editUser() {
        return this.withNewUserLike(this.getUser());
    }

    @Override
    public UserIdentityMappingFluent.UserNested<A> editOrNewUser() {
        return this.withNewUserLike(this.getUser() != null ? this.getUser() : new ObjectReferenceBuilder().build());
    }

    @Override
    public UserIdentityMappingFluent.UserNested<A> editOrNewUserLike(ObjectReference item) {
        return this.withNewUserLike(this.getUser() != null ? this.getUser() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserIdentityMappingFluentImpl that = (UserIdentityMappingFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.identity != null ? !this.identity.equals(that.identity) : that.identity != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(that.user) : that.user != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.identity, this.kind, this.metadata, this.user, super.hashCode());
    }

    public class UserNestedImpl<N>
    extends ObjectReferenceFluentImpl<UserIdentityMappingFluent.UserNested<N>>
    implements UserIdentityMappingFluent.UserNested<N>,
    Nested<N> {
        ObjectReferenceBuilder builder;

        UserNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        UserNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)UserIdentityMappingFluentImpl.this.withUser(this.builder.build());
        }

        @Override
        public N endUser() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<UserIdentityMappingFluent.MetadataNested<N>>
    implements UserIdentityMappingFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)UserIdentityMappingFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class IdentityNestedImpl<N>
    extends ObjectReferenceFluentImpl<UserIdentityMappingFluent.IdentityNested<N>>
    implements UserIdentityMappingFluent.IdentityNested<N>,
    Nested<N> {
        ObjectReferenceBuilder builder;

        IdentityNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        IdentityNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)UserIdentityMappingFluentImpl.this.withIdentity(this.builder.build());
        }

        @Override
        public N endIdentity() {
            return this.and();
        }
    }
}

