/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_7;

import io.fabric8.kubernetes.api.builder.v5_7.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_7.Release;
import io.fabric8.openshift.api.model.v5_7.ReleaseFluent;
import io.fabric8.openshift.api.model.v5_7.ReleaseFluentImpl;
import java.util.Objects;

public class ReleaseBuilder
extends ReleaseFluentImpl<ReleaseBuilder>
implements VisitableBuilder<Release, ReleaseBuilder> {
    ReleaseFluent<?> fluent;
    Boolean validationEnabled;

    public ReleaseBuilder() {
        this(false);
    }

    public ReleaseBuilder(Boolean validationEnabled) {
        this(new Release(), validationEnabled);
    }

    public ReleaseBuilder(ReleaseFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ReleaseBuilder(ReleaseFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Release(), validationEnabled);
    }

    public ReleaseBuilder(ReleaseFluent<?> fluent, Release instance) {
        this(fluent, instance, false);
    }

    public ReleaseBuilder(ReleaseFluent<?> fluent, Release instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withChannels(instance.getChannels());
        fluent.withImage(instance.getImage());
        fluent.withUrl(instance.getUrl());
        fluent.withVersion(instance.getVersion());
        this.validationEnabled = validationEnabled;
    }

    public ReleaseBuilder(Release instance) {
        this(instance, (Boolean)false);
    }

    public ReleaseBuilder(Release instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withChannels(instance.getChannels());
        this.withImage(instance.getImage());
        this.withUrl(instance.getUrl());
        this.withVersion(instance.getVersion());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Release build() {
        Release buildable = new Release(this.fluent.getChannels(), this.fluent.getImage(), this.fluent.getUrl(), this.fluent.getVersion());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReleaseBuilder that = (ReleaseBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

