/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_7;

import io.fabric8.kubernetes.api.builder.v5_7.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_7.ExternalIPPolicy;
import io.fabric8.openshift.api.model.v5_7.ExternalIPPolicyFluent;
import io.fabric8.openshift.api.model.v5_7.ExternalIPPolicyFluentImpl;
import java.util.Objects;

public class ExternalIPPolicyBuilder
extends ExternalIPPolicyFluentImpl<ExternalIPPolicyBuilder>
implements VisitableBuilder<ExternalIPPolicy, ExternalIPPolicyBuilder> {
    ExternalIPPolicyFluent<?> fluent;
    Boolean validationEnabled;

    public ExternalIPPolicyBuilder() {
        this(false);
    }

    public ExternalIPPolicyBuilder(Boolean validationEnabled) {
        this(new ExternalIPPolicy(), validationEnabled);
    }

    public ExternalIPPolicyBuilder(ExternalIPPolicyFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ExternalIPPolicyBuilder(ExternalIPPolicyFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ExternalIPPolicy(), validationEnabled);
    }

    public ExternalIPPolicyBuilder(ExternalIPPolicyFluent<?> fluent, ExternalIPPolicy instance) {
        this(fluent, instance, false);
    }

    public ExternalIPPolicyBuilder(ExternalIPPolicyFluent<?> fluent, ExternalIPPolicy instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAllowedCIDRs(instance.getAllowedCIDRs());
        fluent.withRejectedCIDRs(instance.getRejectedCIDRs());
        this.validationEnabled = validationEnabled;
    }

    public ExternalIPPolicyBuilder(ExternalIPPolicy instance) {
        this(instance, (Boolean)false);
    }

    public ExternalIPPolicyBuilder(ExternalIPPolicy instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAllowedCIDRs(instance.getAllowedCIDRs());
        this.withRejectedCIDRs(instance.getRejectedCIDRs());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ExternalIPPolicy build() {
        ExternalIPPolicy buildable = new ExternalIPPolicy(this.fluent.getAllowedCIDRs(), this.fluent.getRejectedCIDRs());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExternalIPPolicyBuilder that = (ExternalIPPolicyBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

