/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_7.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.fabric8.kubernetes.api.model.v5_7.KubernetesResource;
import io.fabric8.kubernetes.clnt.v5_7.KubernetesClientException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class Serialization {
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private static final ObjectMapper YAML_MAPPER;
    private static final String DOCUMENT_DELIMITER = "---";

    private Serialization() {
    }

    public static ObjectMapper jsonMapper() {
        return JSON_MAPPER;
    }

    public static ObjectMapper yamlMapper() {
        return YAML_MAPPER;
    }

    public static <T> String asJson(T object) {
        try {
            return JSON_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public static <T> String asYaml(T object) {
        try {
            return YAML_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public static <T> T unmarshal(InputStream is) {
        return Serialization.unmarshal(is, JSON_MAPPER);
    }

    public static <T> T unmarshal(InputStream is, Map<String, String> parameters) {
        String specFile = Serialization.readSpecFileFromInputStream(is);
        if (Serialization.containsMultipleDocuments(specFile)) {
            return (T)Serialization.getKubernetesResourceList(parameters, specFile);
        }
        return Serialization.unmarshal((InputStream)new ByteArrayInputStream(specFile.getBytes()), JSON_MAPPER, parameters);
    }

    public static <T> T unmarshal(InputStream is, ObjectMapper mapper) {
        return Serialization.unmarshal(is, mapper, Collections.emptyMap());
    }

    /*
     * Exception decompiling
     */
    public static <T> T unmarshal(InputStream is, ObjectMapper mapper, Map<String, String> parameters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T unmarshal(String str) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8));){
            T t = Serialization.unmarshal(is);
            return t;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public static <T> T unmarshal(String str, Class<T> type) {
        return Serialization.unmarshal(str, type, Collections.emptyMap());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T unmarshal(String str, final Class<T> type, Map<String, String> parameters) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8));){
            T t = Serialization.unmarshal((InputStream)is, new TypeReference<T>(){

                public Type getType() {
                    return type;
                }
            }, parameters);
            return t;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public static <T> T unmarshal(InputStream is, Class<T> type) {
        return Serialization.unmarshal(is, type, Collections.emptyMap());
    }

    public static <T> T unmarshal(InputStream is, final Class<T> type, Map<String, String> parameters) {
        return Serialization.unmarshal(is, new TypeReference<T>(){

            public Type getType() {
                return type;
            }
        }, parameters);
    }

    public static <T> T unmarshal(InputStream is, TypeReference<T> type) {
        return Serialization.unmarshal(is, type, Collections.emptyMap());
    }

    /*
     * Exception decompiling
     */
    public static <T> T unmarshal(InputStream is, TypeReference<T> type, Map<String, String> parameters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static List<KubernetesResource> getKubernetesResourceList(Map<String, String> parameters, String specFile) {
        return Serialization.splitSpecFile(specFile).stream().filter(Serialization::validate).map(document -> (KubernetesResource)Serialization.unmarshal((InputStream)new ByteArrayInputStream(document.getBytes()), parameters)).collect(Collectors.toList());
    }

    static boolean containsMultipleDocuments(String specFile) {
        long validDocumentCount = Serialization.splitSpecFile(specFile).stream().filter(Serialization::validate).count();
        return validDocumentCount > 1L;
    }

    private static List<String> splitSpecFile(String aSpecFile) {
        ArrayList<String> documents = new ArrayList<String>();
        StringBuilder documentBuilder = new StringBuilder();
        for (String line : aSpecFile.split("\r?\n")) {
            if (line.startsWith(DOCUMENT_DELIMITER)) {
                documents.add(documentBuilder.toString());
                documentBuilder.setLength(0);
                continue;
            }
            documentBuilder.append(line).append(System.lineSeparator());
        }
        if (documentBuilder.length() > 0) {
            documents.add(documentBuilder.toString());
        }
        return documents;
    }

    private static boolean validate(String document) {
        Matcher keyValueMatcher = Pattern.compile("(\\S+):\\s(\\S*)(?:\\b(?!:)|$)").matcher(document);
        return !document.isEmpty() && keyValueMatcher.find();
    }

    private static String readSpecFileFromInputStream(InputStream inputStream) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int length;
            while ((length = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, length);
            }
            return outputStream.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read InputStream." + e);
        }
    }

    private static <T> T unmarshalYaml(InputStream is, TypeReference<T> type) throws JsonProcessingException {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());
        Map obj = (Map)yaml.load(is);
        String objAsJsonStr = JSON_MAPPER.writeValueAsString((Object)obj);
        return Serialization.unmarshalJsonStr(objAsJsonStr, type);
    }

    private static <T> T unmarshalJsonStr(String jsonString, TypeReference<T> type) throws JsonProcessingException {
        if (type != null) {
            return (T)JSON_MAPPER.readValue(jsonString, type);
        }
        return (T)JSON_MAPPER.readerFor(KubernetesResource.class).readValue(jsonString);
    }

    public static <T> T clone(T resource) {
        try {
            return (T)JSON_MAPPER.readValue(JSON_MAPPER.writeValueAsString(resource), resource.getClass());
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        JSON_MAPPER.registerModule((Module)new JavaTimeModule());
        YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory().disable(YAMLGenerator.Feature.USE_NATIVE_TYPE_ID));
    }
}

