/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_7.rbac;

import io.fabric8.kubernetes.api.builder.v5_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_7.Nested;
import io.fabric8.kubernetes.api.model.v5_7.ObjectMeta;
import io.fabric8.kubernetes.api.model.v5_7.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v5_7.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.v5_7.rbac.ClusterRoleBinding;
import io.fabric8.kubernetes.api.model.v5_7.rbac.ClusterRoleBindingFluent;
import io.fabric8.kubernetes.api.model.v5_7.rbac.RoleRef;
import io.fabric8.kubernetes.api.model.v5_7.rbac.RoleRefBuilder;
import io.fabric8.kubernetes.api.model.v5_7.rbac.RoleRefFluentImpl;
import io.fabric8.kubernetes.api.model.v5_7.rbac.Subject;
import io.fabric8.kubernetes.api.model.v5_7.rbac.SubjectBuilder;
import io.fabric8.kubernetes.api.model.v5_7.rbac.SubjectFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ClusterRoleBindingFluentImpl<A extends ClusterRoleBindingFluent<A>>
extends BaseFluent<A>
implements ClusterRoleBindingFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private RoleRefBuilder roleRef;
    private List<SubjectBuilder> subjects = new ArrayList<SubjectBuilder>();

    public ClusterRoleBindingFluentImpl() {
    }

    public ClusterRoleBindingFluentImpl(ClusterRoleBinding instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRoleRef(instance.getRoleRef());
        this.withSubjects(instance.getSubjects());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ClusterRoleBindingFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ClusterRoleBindingFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ClusterRoleBindingFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ClusterRoleBindingFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ClusterRoleBindingFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public RoleRef getRoleRef() {
        return this.roleRef != null ? this.roleRef.build() : null;
    }

    @Override
    public RoleRef buildRoleRef() {
        return this.roleRef != null ? this.roleRef.build() : null;
    }

    @Override
    public A withRoleRef(RoleRef roleRef) {
        this._visitables.get("roleRef").remove(this.roleRef);
        if (roleRef != null) {
            this.roleRef = new RoleRefBuilder(roleRef);
            this._visitables.get("roleRef").add(this.roleRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRoleRef() {
        return this.roleRef != null;
    }

    @Override
    public A withNewRoleRef(String apiGroup, String kind, String name) {
        return this.withRoleRef(new RoleRef(apiGroup, kind, name));
    }

    @Override
    public ClusterRoleBindingFluent.RoleRefNested<A> withNewRoleRef() {
        return new RoleRefNestedImpl();
    }

    @Override
    public ClusterRoleBindingFluent.RoleRefNested<A> withNewRoleRefLike(RoleRef item) {
        return new RoleRefNestedImpl(item);
    }

    @Override
    public ClusterRoleBindingFluent.RoleRefNested<A> editRoleRef() {
        return this.withNewRoleRefLike(this.getRoleRef());
    }

    @Override
    public ClusterRoleBindingFluent.RoleRefNested<A> editOrNewRoleRef() {
        return this.withNewRoleRefLike(this.getRoleRef() != null ? this.getRoleRef() : new RoleRefBuilder().build());
    }

    @Override
    public ClusterRoleBindingFluent.RoleRefNested<A> editOrNewRoleRefLike(RoleRef item) {
        return this.withNewRoleRefLike(this.getRoleRef() != null ? this.getRoleRef() : item);
    }

    @Override
    public A addToSubjects(Integer index, Subject item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<SubjectBuilder>();
        }
        SubjectBuilder builder = new SubjectBuilder(item);
        this._visitables.get("subjects").add(index >= 0 ? index.intValue() : this._visitables.get("subjects").size(), builder);
        this.subjects.add(index >= 0 ? index.intValue() : this.subjects.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSubjects(Integer index, Subject item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<SubjectBuilder>();
        }
        SubjectBuilder builder = new SubjectBuilder(item);
        if (index < 0 || index >= this._visitables.get("subjects").size()) {
            this._visitables.get("subjects").add(builder);
        } else {
            this._visitables.get("subjects").set(index, builder);
        }
        if (index < 0 || index >= this.subjects.size()) {
            this.subjects.add(builder);
        } else {
            this.subjects.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSubjects(Subject ... items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<SubjectBuilder>();
        }
        for (Subject item : items) {
            SubjectBuilder builder = new SubjectBuilder(item);
            this._visitables.get("subjects").add(builder);
            this.subjects.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSubjects(Collection<Subject> items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<SubjectBuilder>();
        }
        for (Subject item : items) {
            SubjectBuilder builder = new SubjectBuilder(item);
            this._visitables.get("subjects").add(builder);
            this.subjects.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSubjects(Subject ... items) {
        for (Subject item : items) {
            SubjectBuilder builder = new SubjectBuilder(item);
            this._visitables.get("subjects").remove(builder);
            if (this.subjects == null) continue;
            this.subjects.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSubjects(Collection<Subject> items) {
        for (Subject item : items) {
            SubjectBuilder builder = new SubjectBuilder(item);
            this._visitables.get("subjects").remove(builder);
            if (this.subjects == null) continue;
            this.subjects.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSubjects(Predicate<SubjectBuilder> predicate) {
        if (this.subjects == null) {
            return (A)this;
        }
        Iterator<SubjectBuilder> each = this.subjects.iterator();
        Object visitables = this._visitables.get("subjects");
        while (each.hasNext()) {
            SubjectBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Subject> getSubjects() {
        return ClusterRoleBindingFluentImpl.build(this.subjects);
    }

    @Override
    public List<Subject> buildSubjects() {
        return ClusterRoleBindingFluentImpl.build(this.subjects);
    }

    @Override
    public Subject buildSubject(Integer index) {
        return this.subjects.get(index).build();
    }

    @Override
    public Subject buildFirstSubject() {
        return this.subjects.get(0).build();
    }

    @Override
    public Subject buildLastSubject() {
        return this.subjects.get(this.subjects.size() - 1).build();
    }

    @Override
    public Subject buildMatchingSubject(Predicate<SubjectBuilder> predicate) {
        for (SubjectBuilder item : this.subjects) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSubject(Predicate<SubjectBuilder> predicate) {
        for (SubjectBuilder item : this.subjects) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSubjects(List<Subject> subjects) {
        if (this.subjects != null) {
            this._visitables.get("subjects").removeAll(this.subjects);
        }
        if (subjects != null) {
            this.subjects = new ArrayList<SubjectBuilder>();
            for (Subject item : subjects) {
                this.addToSubjects(item);
            }
        } else {
            this.subjects = null;
        }
        return (A)this;
    }

    @Override
    public A withSubjects(Subject ... subjects) {
        if (this.subjects != null) {
            this.subjects.clear();
        }
        if (subjects != null) {
            for (Subject item : subjects) {
                this.addToSubjects(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSubjects() {
        return this.subjects != null && !this.subjects.isEmpty();
    }

    @Override
    public A addNewSubject(String apiGroup, String kind, String name, String namespace) {
        return this.addToSubjects(new Subject(apiGroup, kind, name, namespace));
    }

    @Override
    public ClusterRoleBindingFluent.SubjectsNested<A> addNewSubject() {
        return new SubjectsNestedImpl();
    }

    @Override
    public ClusterRoleBindingFluent.SubjectsNested<A> addNewSubjectLike(Subject item) {
        return new SubjectsNestedImpl(-1, item);
    }

    @Override
    public ClusterRoleBindingFluent.SubjectsNested<A> setNewSubjectLike(Integer index, Subject item) {
        return new SubjectsNestedImpl(index, item);
    }

    @Override
    public ClusterRoleBindingFluent.SubjectsNested<A> editSubject(Integer index) {
        if (this.subjects.size() <= index) {
            throw new RuntimeException("Can't edit subjects. Index exceeds size.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    @Override
    public ClusterRoleBindingFluent.SubjectsNested<A> editFirstSubject() {
        if (this.subjects.size() == 0) {
            throw new RuntimeException("Can't edit first subjects. The list is empty.");
        }
        return this.setNewSubjectLike(0, this.buildSubject(0));
    }

    @Override
    public ClusterRoleBindingFluent.SubjectsNested<A> editLastSubject() {
        int index = this.subjects.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last subjects. The list is empty.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    @Override
    public ClusterRoleBindingFluent.SubjectsNested<A> editMatchingSubject(Predicate<SubjectBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subjects.size(); ++i) {
            if (!predicate.test(this.subjects.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching subjects. No match found.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterRoleBindingFluentImpl that = (ClusterRoleBindingFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.roleRef != null ? !this.roleRef.equals(that.roleRef) : that.roleRef != null) {
            return false;
        }
        return !(this.subjects != null ? !this.subjects.equals(that.subjects) : that.subjects != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.roleRef, this.subjects, super.hashCode());
    }

    public class SubjectsNestedImpl<N>
    extends SubjectFluentImpl<ClusterRoleBindingFluent.SubjectsNested<N>>
    implements ClusterRoleBindingFluent.SubjectsNested<N>,
    Nested<N> {
        SubjectBuilder builder;
        Integer index;

        SubjectsNestedImpl(Integer index, Subject item) {
            this.index = index;
            this.builder = new SubjectBuilder(this, item);
        }

        SubjectsNestedImpl() {
            this.index = -1;
            this.builder = new SubjectBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterRoleBindingFluentImpl.this.setToSubjects(this.index, this.builder.build());
        }

        @Override
        public N endSubject() {
            return this.and();
        }
    }

    public class RoleRefNestedImpl<N>
    extends RoleRefFluentImpl<ClusterRoleBindingFluent.RoleRefNested<N>>
    implements ClusterRoleBindingFluent.RoleRefNested<N>,
    Nested<N> {
        RoleRefBuilder builder;

        RoleRefNestedImpl(RoleRef item) {
            this.builder = new RoleRefBuilder(this, item);
        }

        RoleRefNestedImpl() {
            this.builder = new RoleRefBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterRoleBindingFluentImpl.this.withRoleRef(this.builder.build());
        }

        @Override
        public N endRoleRef() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ClusterRoleBindingFluent.MetadataNested<N>>
    implements ClusterRoleBindingFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterRoleBindingFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

