/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_7;

import io.fabric8.kubernetes.api.builder.v5_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_7.Nested;
import io.fabric8.kubernetes.api.model.v5_7.LabelSelector;
import io.fabric8.kubernetes.api.model.v5_7.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.v5_7.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.v5_7.PodAffinityTerm;
import io.fabric8.kubernetes.api.model.v5_7.PodAffinityTermFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class PodAffinityTermFluentImpl<A extends PodAffinityTermFluent<A>>
extends BaseFluent<A>
implements PodAffinityTermFluent<A> {
    private LabelSelectorBuilder labelSelector;
    private LabelSelectorBuilder namespaceSelector;
    private List<String> namespaces = new ArrayList<String>();
    private String topologyKey;

    public PodAffinityTermFluentImpl() {
    }

    public PodAffinityTermFluentImpl(PodAffinityTerm instance) {
        this.withLabelSelector(instance.getLabelSelector());
        this.withNamespaceSelector(instance.getNamespaceSelector());
        this.withNamespaces(instance.getNamespaces());
        this.withTopologyKey(instance.getTopologyKey());
    }

    @Override
    @Deprecated
    public LabelSelector getLabelSelector() {
        return this.labelSelector != null ? this.labelSelector.build() : null;
    }

    @Override
    public LabelSelector buildLabelSelector() {
        return this.labelSelector != null ? this.labelSelector.build() : null;
    }

    @Override
    public A withLabelSelector(LabelSelector labelSelector) {
        this._visitables.get("labelSelector").remove(this.labelSelector);
        if (labelSelector != null) {
            this.labelSelector = new LabelSelectorBuilder(labelSelector);
            this._visitables.get("labelSelector").add(this.labelSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLabelSelector() {
        return this.labelSelector != null;
    }

    @Override
    public PodAffinityTermFluent.LabelSelectorNested<A> withNewLabelSelector() {
        return new LabelSelectorNestedImpl();
    }

    @Override
    public PodAffinityTermFluent.LabelSelectorNested<A> withNewLabelSelectorLike(LabelSelector item) {
        return new LabelSelectorNestedImpl(item);
    }

    @Override
    public PodAffinityTermFluent.LabelSelectorNested<A> editLabelSelector() {
        return this.withNewLabelSelectorLike(this.getLabelSelector());
    }

    @Override
    public PodAffinityTermFluent.LabelSelectorNested<A> editOrNewLabelSelector() {
        return this.withNewLabelSelectorLike(this.getLabelSelector() != null ? this.getLabelSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public PodAffinityTermFluent.LabelSelectorNested<A> editOrNewLabelSelectorLike(LabelSelector item) {
        return this.withNewLabelSelectorLike(this.getLabelSelector() != null ? this.getLabelSelector() : item);
    }

    @Override
    @Deprecated
    public LabelSelector getNamespaceSelector() {
        return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
    }

    @Override
    public LabelSelector buildNamespaceSelector() {
        return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
    }

    @Override
    public A withNamespaceSelector(LabelSelector namespaceSelector) {
        this._visitables.get("namespaceSelector").remove(this.namespaceSelector);
        if (namespaceSelector != null) {
            this.namespaceSelector = new LabelSelectorBuilder(namespaceSelector);
            this._visitables.get("namespaceSelector").add(this.namespaceSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNamespaceSelector() {
        return this.namespaceSelector != null;
    }

    @Override
    public PodAffinityTermFluent.NamespaceSelectorNested<A> withNewNamespaceSelector() {
        return new NamespaceSelectorNestedImpl();
    }

    @Override
    public PodAffinityTermFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item) {
        return new NamespaceSelectorNestedImpl(item);
    }

    @Override
    public PodAffinityTermFluent.NamespaceSelectorNested<A> editNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(this.getNamespaceSelector());
    }

    @Override
    public PodAffinityTermFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(this.getNamespaceSelector() != null ? this.getNamespaceSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public PodAffinityTermFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item) {
        return this.withNewNamespaceSelectorLike(this.getNamespaceSelector() != null ? this.getNamespaceSelector() : item);
    }

    @Override
    public A addToNamespaces(Integer index, String item) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        this.namespaces.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNamespaces(Integer index, String item) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        this.namespaces.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNamespaces(String ... items) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.namespaces.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNamespaces(Collection<String> items) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.namespaces.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNamespaces(String ... items) {
        for (String item : items) {
            if (this.namespaces == null) continue;
            this.namespaces.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNamespaces(Collection<String> items) {
        for (String item : items) {
            if (this.namespaces == null) continue;
            this.namespaces.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public String getNamespace(Integer index) {
        return this.namespaces.get(index);
    }

    @Override
    public String getFirstNamespace() {
        return this.namespaces.get(0);
    }

    @Override
    public String getLastNamespace() {
        return this.namespaces.get(this.namespaces.size() - 1);
    }

    @Override
    public String getMatchingNamespace(Predicate<String> predicate) {
        for (String item : this.namespaces) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNamespace(Predicate<String> predicate) {
        for (String item : this.namespaces) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNamespaces(List<String> namespaces) {
        if (namespaces != null) {
            this.namespaces = new ArrayList<String>();
            for (String item : namespaces) {
                this.addToNamespaces(item);
            }
        } else {
            this.namespaces = null;
        }
        return (A)this;
    }

    @Override
    public A withNamespaces(String ... namespaces) {
        if (this.namespaces != null) {
            this.namespaces.clear();
        }
        if (namespaces != null) {
            for (String item : namespaces) {
                this.addToNamespaces(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNamespaces() {
        return this.namespaces != null && !this.namespaces.isEmpty();
    }

    @Override
    public A addNewNamespace(String arg0) {
        return this.addToNamespaces(new String(arg0));
    }

    @Override
    public String getTopologyKey() {
        return this.topologyKey;
    }

    @Override
    public A withTopologyKey(String topologyKey) {
        this.topologyKey = topologyKey;
        return (A)this;
    }

    @Override
    public Boolean hasTopologyKey() {
        return this.topologyKey != null;
    }

    @Override
    @Deprecated
    public A withNewTopologyKey(String arg0) {
        return this.withTopologyKey(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodAffinityTermFluentImpl that = (PodAffinityTermFluentImpl)o;
        if (this.labelSelector != null ? !this.labelSelector.equals(that.labelSelector) : that.labelSelector != null) {
            return false;
        }
        if (this.namespaceSelector != null ? !this.namespaceSelector.equals(that.namespaceSelector) : that.namespaceSelector != null) {
            return false;
        }
        if (this.namespaces != null ? !this.namespaces.equals(that.namespaces) : that.namespaces != null) {
            return false;
        }
        return !(this.topologyKey != null ? !this.topologyKey.equals(that.topologyKey) : that.topologyKey != null);
    }

    public int hashCode() {
        return Objects.hash(this.labelSelector, this.namespaceSelector, this.namespaces, this.topologyKey, super.hashCode());
    }

    public class NamespaceSelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<PodAffinityTermFluent.NamespaceSelectorNested<N>>
    implements PodAffinityTermFluent.NamespaceSelectorNested<N>,
    Nested<N> {
        LabelSelectorBuilder builder;

        NamespaceSelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        NamespaceSelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodAffinityTermFluentImpl.this.withNamespaceSelector(this.builder.build());
        }

        @Override
        public N endNamespaceSelector() {
            return this.and();
        }
    }

    public class LabelSelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<PodAffinityTermFluent.LabelSelectorNested<N>>
    implements PodAffinityTermFluent.LabelSelectorNested<N>,
    Nested<N> {
        LabelSelectorBuilder builder;

        LabelSelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        LabelSelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodAffinityTermFluentImpl.this.withLabelSelector(this.builder.build());
        }

        @Override
        public N endLabelSelector() {
            return this.and();
        }
    }
}

