/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_7;

import io.fabric8.kubernetes.api.builder.v5_7.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_7.BaseKubernetesList;
import io.fabric8.kubernetes.api.model.v5_7.BaseKubernetesListFluent;
import io.fabric8.kubernetes.api.model.v5_7.BaseKubernetesListFluentImpl;
import java.util.Objects;

public class BaseKubernetesListBuilder
extends BaseKubernetesListFluentImpl<BaseKubernetesListBuilder>
implements VisitableBuilder<BaseKubernetesList, BaseKubernetesListBuilder> {
    BaseKubernetesListFluent<?> fluent;
    Boolean validationEnabled;

    public BaseKubernetesListBuilder() {
        this(false);
    }

    public BaseKubernetesListBuilder(Boolean validationEnabled) {
        this(new BaseKubernetesList(), validationEnabled);
    }

    public BaseKubernetesListBuilder(BaseKubernetesListFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public BaseKubernetesListBuilder(BaseKubernetesListFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new BaseKubernetesList(), validationEnabled);
    }

    public BaseKubernetesListBuilder(BaseKubernetesListFluent<?> fluent, BaseKubernetesList instance) {
        this(fluent, instance, false);
    }

    public BaseKubernetesListBuilder(BaseKubernetesListFluent<?> fluent, BaseKubernetesList instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public BaseKubernetesListBuilder(BaseKubernetesList instance) {
        this(instance, (Boolean)false);
    }

    public BaseKubernetesListBuilder(BaseKubernetesList instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public BaseKubernetesList build() {
        BaseKubernetesList buildable = new BaseKubernetesList(this.fluent.getApiVersion(), this.fluent.getItems(), this.fluent.getKind(), this.fluent.getMetadata());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaseKubernetesListBuilder that = (BaseKubernetesListBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

