/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_7;

import io.fabric8.kubernetes.api.builder.v5_7.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_7.AuthProviderConfig;
import io.fabric8.kubernetes.api.model.v5_7.AuthProviderConfigFluent;
import io.fabric8.kubernetes.api.model.v5_7.AuthProviderConfigFluentImpl;
import java.util.Objects;

public class AuthProviderConfigBuilder
extends AuthProviderConfigFluentImpl<AuthProviderConfigBuilder>
implements VisitableBuilder<AuthProviderConfig, AuthProviderConfigBuilder> {
    AuthProviderConfigFluent<?> fluent;
    Boolean validationEnabled;

    public AuthProviderConfigBuilder() {
        this(false);
    }

    public AuthProviderConfigBuilder(Boolean validationEnabled) {
        this(new AuthProviderConfig(), validationEnabled);
    }

    public AuthProviderConfigBuilder(AuthProviderConfigFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public AuthProviderConfigBuilder(AuthProviderConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new AuthProviderConfig(), validationEnabled);
    }

    public AuthProviderConfigBuilder(AuthProviderConfigFluent<?> fluent, AuthProviderConfig instance) {
        this(fluent, instance, false);
    }

    public AuthProviderConfigBuilder(AuthProviderConfigFluent<?> fluent, AuthProviderConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withConfig(instance.getConfig());
        fluent.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public AuthProviderConfigBuilder(AuthProviderConfig instance) {
        this(instance, (Boolean)false);
    }

    public AuthProviderConfigBuilder(AuthProviderConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withConfig(instance.getConfig());
        this.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public AuthProviderConfig build() {
        AuthProviderConfig buildable = new AuthProviderConfig(this.fluent.getConfig(), this.fluent.getName());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuthProviderConfigBuilder that = (AuthProviderConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

