/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v5_7;

import io.fabric8.kubernetes.clnt.v5_7.Client;
import io.fabric8.kubernetes.clnt.v5_7.ExtensionAdapter;
import io.fabric8.openshift.api.model.v5_7.Build;
import io.fabric8.openshift.api.model.v5_7.BuildConfig;
import io.fabric8.openshift.api.model.v5_7.ClusterRoleBinding;
import io.fabric8.openshift.api.model.v5_7.DNS;
import io.fabric8.openshift.api.model.v5_7.DeploymentConfig;
import io.fabric8.openshift.api.model.v5_7.Group;
import io.fabric8.openshift.api.model.v5_7.OAuthAccessToken;
import io.fabric8.openshift.api.model.v5_7.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.v5_7.OAuthClient;
import io.fabric8.openshift.api.model.v5_7.Project;
import io.fabric8.openshift.api.model.v5_7.Role;
import io.fabric8.openshift.api.model.v5_7.RoleBinding;
import io.fabric8.openshift.api.model.v5_7.SecurityContextConstraints;
import io.fabric8.openshift.api.model.v5_7.Template;
import io.fabric8.openshift.api.model.v5_7.User;
import io.fabric8.openshift.api.model.v5_7.miscellaneous.cncf.cni.v1.NetworkAttachmentDefinition;
import io.fabric8.openshift.clnt.v5_7.DefaultOpenShiftClient;
import io.fabric8.openshift.clnt.v5_7.OpenShiftClient;
import io.fabric8.openshift.clnt.v5_7.OpenShiftConfig;
import io.fabric8.openshift.clnt.v5_7.OpenShiftHandlers;
import io.fabric8.openshift.clnt.v5_7.OpenShiftNotAvailableException;
import io.fabric8.openshift.clnt.v5_7.OpenshiftAdapterSupport;
import io.fabric8.openshift.clnt.v5_7.dsl.internal.apps.DeploymentConfigOperationsImpl;
import io.fabric8.openshift.clnt.v5_7.dsl.internal.authorization.ClusterRoleBindingOperationsImpl;
import io.fabric8.openshift.clnt.v5_7.dsl.internal.authorization.RoleBindingOperationsImpl;
import io.fabric8.openshift.clnt.v5_7.dsl.internal.authorization.RoleOperationsImpl;
import io.fabric8.openshift.clnt.v5_7.dsl.internal.build.BuildConfigOperationsImpl;
import io.fabric8.openshift.clnt.v5_7.dsl.internal.build.BuildOperationsImpl;
import io.fabric8.openshift.clnt.v5_7.dsl.internal.config.DNSOperationsImpl;
import io.fabric8.openshift.clnt.v5_7.dsl.internal.core.NetworkAttachmentDefinitionOperationsImpl;
import io.fabric8.openshift.clnt.v5_7.dsl.internal.core.TemplateOperationsImpl;
import io.fabric8.openshift.clnt.v5_7.dsl.internal.oauth.OAuthAccessTokenOperationsImpl;
import io.fabric8.openshift.clnt.v5_7.dsl.internal.oauth.OAuthAuthorizeTokenOperationsImpl;
import io.fabric8.openshift.clnt.v5_7.dsl.internal.oauth.OAuthClientOperationsImpl;
import io.fabric8.openshift.clnt.v5_7.dsl.internal.project.ProjectOperationsImpl;
import io.fabric8.openshift.clnt.v5_7.dsl.internal.security.SecurityContextConstraintsOperationsImpl;
import io.fabric8.openshift.clnt.v5_7.dsl.internal.user.GroupOperationsImpl;
import io.fabric8.openshift.clnt.v5_7.dsl.internal.user.UserOperationsImpl;
import okhttp3.OkHttpClient;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;

@Component
@Service
public class OpenShiftExtensionAdapter
extends OpenshiftAdapterSupport
implements ExtensionAdapter<OpenShiftClient> {
    @Override
    public Class<OpenShiftClient> getExtensionType() {
        return OpenShiftClient.class;
    }

    @Override
    public OpenShiftClient adapt(Client client) {
        if (!this.isAdaptable(client).booleanValue()) {
            throw new OpenShiftNotAvailableException("OpenShift is not available. Root paths at: " + client.getMasterUrl() + " do not include oapi.");
        }
        return new DefaultOpenShiftClient(client.adapt(OkHttpClient.class), OpenShiftConfig.wrap(client.getConfiguration()));
    }

    static {
        OpenShiftHandlers.register(BuildConfig.class, BuildConfigOperationsImpl::new);
        OpenShiftHandlers.register(Build.class, BuildOperationsImpl::new);
        OpenShiftHandlers.register(ClusterRoleBinding.class, ClusterRoleBindingOperationsImpl::new);
        OpenShiftHandlers.register(DeploymentConfig.class, DeploymentConfigOperationsImpl::new);
        OpenShiftHandlers.register(DNS.class, DNSOperationsImpl::new);
        OpenShiftHandlers.register(Group.class, GroupOperationsImpl::new);
        OpenShiftHandlers.register(NetworkAttachmentDefinition.class, NetworkAttachmentDefinitionOperationsImpl::new);
        OpenShiftHandlers.register(OAuthAccessToken.class, OAuthAccessTokenOperationsImpl::new);
        OpenShiftHandlers.register(OAuthAuthorizeToken.class, OAuthAuthorizeTokenOperationsImpl::new);
        OpenShiftHandlers.register(OAuthClient.class, OAuthClientOperationsImpl::new);
        OpenShiftHandlers.register(RoleBinding.class, RoleBindingOperationsImpl::new);
        OpenShiftHandlers.register(Role.class, RoleOperationsImpl::new);
        OpenShiftHandlers.register(SecurityContextConstraints.class, SecurityContextConstraintsOperationsImpl::new);
        OpenShiftHandlers.register(Template.class, TemplateOperationsImpl::new);
        OpenShiftHandlers.register(User.class, UserOperationsImpl::new);
        OpenShiftHandlers.register(Project.class, ProjectOperationsImpl::new);
    }
}

