/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_7.operatorhub.lifecyclemanager.v1;

import io.fabric8.kubernetes.api.builder.v5_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_7.Nested;
import io.fabric8.openshift.api.model.v5_7.operatorhub.lifecyclemanager.v1.AppLink;
import io.fabric8.openshift.api.model.v5_7.operatorhub.lifecyclemanager.v1.AppLinkBuilder;
import io.fabric8.openshift.api.model.v5_7.operatorhub.lifecyclemanager.v1.AppLinkFluentImpl;
import io.fabric8.openshift.api.model.v5_7.operatorhub.lifecyclemanager.v1.PackageChannel;
import io.fabric8.openshift.api.model.v5_7.operatorhub.lifecyclemanager.v1.PackageChannelBuilder;
import io.fabric8.openshift.api.model.v5_7.operatorhub.lifecyclemanager.v1.PackageChannelFluentImpl;
import io.fabric8.openshift.api.model.v5_7.operatorhub.lifecyclemanager.v1.PackageManifestStatus;
import io.fabric8.openshift.api.model.v5_7.operatorhub.lifecyclemanager.v1.PackageManifestStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class PackageManifestStatusFluentImpl<A extends PackageManifestStatusFluent<A>>
extends BaseFluent<A>
implements PackageManifestStatusFluent<A> {
    private String catalogSource;
    private String catalogSourceDisplayName;
    private String catalogSourceNamespace;
    private String catalogSourcePublisher;
    private List<PackageChannelBuilder> channels = new ArrayList<PackageChannelBuilder>();
    private String defaultChannel;
    private String packageName;
    private AppLinkBuilder provider;

    public PackageManifestStatusFluentImpl() {
    }

    public PackageManifestStatusFluentImpl(PackageManifestStatus instance) {
        this.withCatalogSource(instance.getCatalogSource());
        this.withCatalogSourceDisplayName(instance.getCatalogSourceDisplayName());
        this.withCatalogSourceNamespace(instance.getCatalogSourceNamespace());
        this.withCatalogSourcePublisher(instance.getCatalogSourcePublisher());
        this.withChannels(instance.getChannels());
        this.withDefaultChannel(instance.getDefaultChannel());
        this.withPackageName(instance.getPackageName());
        this.withProvider(instance.getProvider());
    }

    @Override
    public String getCatalogSource() {
        return this.catalogSource;
    }

    @Override
    public A withCatalogSource(String catalogSource) {
        this.catalogSource = catalogSource;
        return (A)this;
    }

    @Override
    public Boolean hasCatalogSource() {
        return this.catalogSource != null;
    }

    @Override
    @Deprecated
    public A withNewCatalogSource(String arg0) {
        return this.withCatalogSource(new String(arg0));
    }

    @Override
    public String getCatalogSourceDisplayName() {
        return this.catalogSourceDisplayName;
    }

    @Override
    public A withCatalogSourceDisplayName(String catalogSourceDisplayName) {
        this.catalogSourceDisplayName = catalogSourceDisplayName;
        return (A)this;
    }

    @Override
    public Boolean hasCatalogSourceDisplayName() {
        return this.catalogSourceDisplayName != null;
    }

    @Override
    @Deprecated
    public A withNewCatalogSourceDisplayName(String arg0) {
        return this.withCatalogSourceDisplayName(new String(arg0));
    }

    @Override
    public String getCatalogSourceNamespace() {
        return this.catalogSourceNamespace;
    }

    @Override
    public A withCatalogSourceNamespace(String catalogSourceNamespace) {
        this.catalogSourceNamespace = catalogSourceNamespace;
        return (A)this;
    }

    @Override
    public Boolean hasCatalogSourceNamespace() {
        return this.catalogSourceNamespace != null;
    }

    @Override
    @Deprecated
    public A withNewCatalogSourceNamespace(String arg0) {
        return this.withCatalogSourceNamespace(new String(arg0));
    }

    @Override
    public String getCatalogSourcePublisher() {
        return this.catalogSourcePublisher;
    }

    @Override
    public A withCatalogSourcePublisher(String catalogSourcePublisher) {
        this.catalogSourcePublisher = catalogSourcePublisher;
        return (A)this;
    }

    @Override
    public Boolean hasCatalogSourcePublisher() {
        return this.catalogSourcePublisher != null;
    }

    @Override
    @Deprecated
    public A withNewCatalogSourcePublisher(String arg0) {
        return this.withCatalogSourcePublisher(new String(arg0));
    }

    @Override
    public A addToChannels(Integer index, PackageChannel item) {
        if (this.channels == null) {
            this.channels = new ArrayList<PackageChannelBuilder>();
        }
        PackageChannelBuilder builder = new PackageChannelBuilder(item);
        this._visitables.get("channels").add(index >= 0 ? index.intValue() : this._visitables.get("channels").size(), builder);
        this.channels.add(index >= 0 ? index.intValue() : this.channels.size(), builder);
        return (A)this;
    }

    @Override
    public A setToChannels(Integer index, PackageChannel item) {
        if (this.channels == null) {
            this.channels = new ArrayList<PackageChannelBuilder>();
        }
        PackageChannelBuilder builder = new PackageChannelBuilder(item);
        if (index < 0 || index >= this._visitables.get("channels").size()) {
            this._visitables.get("channels").add(builder);
        } else {
            this._visitables.get("channels").set(index, builder);
        }
        if (index < 0 || index >= this.channels.size()) {
            this.channels.add(builder);
        } else {
            this.channels.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToChannels(PackageChannel ... items) {
        if (this.channels == null) {
            this.channels = new ArrayList<PackageChannelBuilder>();
        }
        for (PackageChannel item : items) {
            PackageChannelBuilder builder = new PackageChannelBuilder(item);
            this._visitables.get("channels").add(builder);
            this.channels.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToChannels(Collection<PackageChannel> items) {
        if (this.channels == null) {
            this.channels = new ArrayList<PackageChannelBuilder>();
        }
        for (PackageChannel item : items) {
            PackageChannelBuilder builder = new PackageChannelBuilder(item);
            this._visitables.get("channels").add(builder);
            this.channels.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromChannels(PackageChannel ... items) {
        for (PackageChannel item : items) {
            PackageChannelBuilder builder = new PackageChannelBuilder(item);
            this._visitables.get("channels").remove(builder);
            if (this.channels == null) continue;
            this.channels.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromChannels(Collection<PackageChannel> items) {
        for (PackageChannel item : items) {
            PackageChannelBuilder builder = new PackageChannelBuilder(item);
            this._visitables.get("channels").remove(builder);
            if (this.channels == null) continue;
            this.channels.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromChannels(Predicate<PackageChannelBuilder> predicate) {
        if (this.channels == null) {
            return (A)this;
        }
        Iterator<PackageChannelBuilder> each = this.channels.iterator();
        Object visitables = this._visitables.get("channels");
        while (each.hasNext()) {
            PackageChannelBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<PackageChannel> getChannels() {
        return PackageManifestStatusFluentImpl.build(this.channels);
    }

    @Override
    public List<PackageChannel> buildChannels() {
        return PackageManifestStatusFluentImpl.build(this.channels);
    }

    @Override
    public PackageChannel buildChannel(Integer index) {
        return this.channels.get(index).build();
    }

    @Override
    public PackageChannel buildFirstChannel() {
        return this.channels.get(0).build();
    }

    @Override
    public PackageChannel buildLastChannel() {
        return this.channels.get(this.channels.size() - 1).build();
    }

    @Override
    public PackageChannel buildMatchingChannel(Predicate<PackageChannelBuilder> predicate) {
        for (PackageChannelBuilder item : this.channels) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingChannel(Predicate<PackageChannelBuilder> predicate) {
        for (PackageChannelBuilder item : this.channels) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withChannels(List<PackageChannel> channels) {
        if (this.channels != null) {
            this._visitables.get("channels").removeAll(this.channels);
        }
        if (channels != null) {
            this.channels = new ArrayList<PackageChannelBuilder>();
            for (PackageChannel item : channels) {
                this.addToChannels(item);
            }
        } else {
            this.channels = null;
        }
        return (A)this;
    }

    @Override
    public A withChannels(PackageChannel ... channels) {
        if (this.channels != null) {
            this.channels.clear();
        }
        if (channels != null) {
            for (PackageChannel item : channels) {
                this.addToChannels(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasChannels() {
        return this.channels != null && !this.channels.isEmpty();
    }

    @Override
    public PackageManifestStatusFluent.ChannelsNested<A> addNewChannel() {
        return new ChannelsNestedImpl();
    }

    @Override
    public PackageManifestStatusFluent.ChannelsNested<A> addNewChannelLike(PackageChannel item) {
        return new ChannelsNestedImpl(-1, item);
    }

    @Override
    public PackageManifestStatusFluent.ChannelsNested<A> setNewChannelLike(Integer index, PackageChannel item) {
        return new ChannelsNestedImpl(index, item);
    }

    @Override
    public PackageManifestStatusFluent.ChannelsNested<A> editChannel(Integer index) {
        if (this.channels.size() <= index) {
            throw new RuntimeException("Can't edit channels. Index exceeds size.");
        }
        return this.setNewChannelLike(index, this.buildChannel(index));
    }

    @Override
    public PackageManifestStatusFluent.ChannelsNested<A> editFirstChannel() {
        if (this.channels.size() == 0) {
            throw new RuntimeException("Can't edit first channels. The list is empty.");
        }
        return this.setNewChannelLike(0, this.buildChannel(0));
    }

    @Override
    public PackageManifestStatusFluent.ChannelsNested<A> editLastChannel() {
        int index = this.channels.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last channels. The list is empty.");
        }
        return this.setNewChannelLike(index, this.buildChannel(index));
    }

    @Override
    public PackageManifestStatusFluent.ChannelsNested<A> editMatchingChannel(Predicate<PackageChannelBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.channels.size(); ++i) {
            if (!predicate.test(this.channels.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching channels. No match found.");
        }
        return this.setNewChannelLike(index, this.buildChannel(index));
    }

    @Override
    public String getDefaultChannel() {
        return this.defaultChannel;
    }

    @Override
    public A withDefaultChannel(String defaultChannel) {
        this.defaultChannel = defaultChannel;
        return (A)this;
    }

    @Override
    public Boolean hasDefaultChannel() {
        return this.defaultChannel != null;
    }

    @Override
    @Deprecated
    public A withNewDefaultChannel(String arg0) {
        return this.withDefaultChannel(new String(arg0));
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public A withPackageName(String packageName) {
        this.packageName = packageName;
        return (A)this;
    }

    @Override
    public Boolean hasPackageName() {
        return this.packageName != null;
    }

    @Override
    @Deprecated
    public A withNewPackageName(String arg0) {
        return this.withPackageName(new String(arg0));
    }

    @Override
    @Deprecated
    public AppLink getProvider() {
        return this.provider != null ? this.provider.build() : null;
    }

    @Override
    public AppLink buildProvider() {
        return this.provider != null ? this.provider.build() : null;
    }

    @Override
    public A withProvider(AppLink provider) {
        this._visitables.get("provider").remove(this.provider);
        if (provider != null) {
            this.provider = new AppLinkBuilder(provider);
            this._visitables.get("provider").add(this.provider);
        }
        return (A)this;
    }

    @Override
    public Boolean hasProvider() {
        return this.provider != null;
    }

    @Override
    public A withNewProvider(String name, String url) {
        return this.withProvider(new AppLink(name, url));
    }

    @Override
    public PackageManifestStatusFluent.ProviderNested<A> withNewProvider() {
        return new ProviderNestedImpl();
    }

    @Override
    public PackageManifestStatusFluent.ProviderNested<A> withNewProviderLike(AppLink item) {
        return new ProviderNestedImpl(item);
    }

    @Override
    public PackageManifestStatusFluent.ProviderNested<A> editProvider() {
        return this.withNewProviderLike(this.getProvider());
    }

    @Override
    public PackageManifestStatusFluent.ProviderNested<A> editOrNewProvider() {
        return this.withNewProviderLike(this.getProvider() != null ? this.getProvider() : new AppLinkBuilder().build());
    }

    @Override
    public PackageManifestStatusFluent.ProviderNested<A> editOrNewProviderLike(AppLink item) {
        return this.withNewProviderLike(this.getProvider() != null ? this.getProvider() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageManifestStatusFluentImpl that = (PackageManifestStatusFluentImpl)o;
        if (this.catalogSource != null ? !this.catalogSource.equals(that.catalogSource) : that.catalogSource != null) {
            return false;
        }
        if (this.catalogSourceDisplayName != null ? !this.catalogSourceDisplayName.equals(that.catalogSourceDisplayName) : that.catalogSourceDisplayName != null) {
            return false;
        }
        if (this.catalogSourceNamespace != null ? !this.catalogSourceNamespace.equals(that.catalogSourceNamespace) : that.catalogSourceNamespace != null) {
            return false;
        }
        if (this.catalogSourcePublisher != null ? !this.catalogSourcePublisher.equals(that.catalogSourcePublisher) : that.catalogSourcePublisher != null) {
            return false;
        }
        if (this.channels != null ? !this.channels.equals(that.channels) : that.channels != null) {
            return false;
        }
        if (this.defaultChannel != null ? !this.defaultChannel.equals(that.defaultChannel) : that.defaultChannel != null) {
            return false;
        }
        if (this.packageName != null ? !this.packageName.equals(that.packageName) : that.packageName != null) {
            return false;
        }
        return !(this.provider != null ? !this.provider.equals(that.provider) : that.provider != null);
    }

    public int hashCode() {
        return Objects.hash(this.catalogSource, this.catalogSourceDisplayName, this.catalogSourceNamespace, this.catalogSourcePublisher, this.channels, this.defaultChannel, this.packageName, this.provider, super.hashCode());
    }

    public class ProviderNestedImpl<N>
    extends AppLinkFluentImpl<PackageManifestStatusFluent.ProviderNested<N>>
    implements PackageManifestStatusFluent.ProviderNested<N>,
    Nested<N> {
        AppLinkBuilder builder;

        ProviderNestedImpl(AppLink item) {
            this.builder = new AppLinkBuilder(this, item);
        }

        ProviderNestedImpl() {
            this.builder = new AppLinkBuilder(this);
        }

        @Override
        public N and() {
            return (N)PackageManifestStatusFluentImpl.this.withProvider(this.builder.build());
        }

        @Override
        public N endProvider() {
            return this.and();
        }
    }

    public class ChannelsNestedImpl<N>
    extends PackageChannelFluentImpl<PackageManifestStatusFluent.ChannelsNested<N>>
    implements PackageManifestStatusFluent.ChannelsNested<N>,
    Nested<N> {
        PackageChannelBuilder builder;
        Integer index;

        ChannelsNestedImpl(Integer index, PackageChannel item) {
            this.index = index;
            this.builder = new PackageChannelBuilder(this, item);
        }

        ChannelsNestedImpl() {
            this.index = -1;
            this.builder = new PackageChannelBuilder(this);
        }

        @Override
        public N and() {
            return (N)PackageManifestStatusFluentImpl.this.setToChannels(this.index, this.builder.build());
        }

        @Override
        public N endChannel() {
            return this.and();
        }
    }
}

