/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_7.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.v5_7.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_7.machineconfig.v1.KubeletConfigSpec;
import io.fabric8.openshift.api.model.v5_7.machineconfig.v1.KubeletConfigSpecFluent;
import io.fabric8.openshift.api.model.v5_7.machineconfig.v1.KubeletConfigSpecFluentImpl;
import java.util.Objects;

public class KubeletConfigSpecBuilder
extends KubeletConfigSpecFluentImpl<KubeletConfigSpecBuilder>
implements VisitableBuilder<KubeletConfigSpec, KubeletConfigSpecBuilder> {
    KubeletConfigSpecFluent<?> fluent;
    Boolean validationEnabled;

    public KubeletConfigSpecBuilder() {
        this(false);
    }

    public KubeletConfigSpecBuilder(Boolean validationEnabled) {
        this(new KubeletConfigSpec(), validationEnabled);
    }

    public KubeletConfigSpecBuilder(KubeletConfigSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public KubeletConfigSpecBuilder(KubeletConfigSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KubeletConfigSpec(), validationEnabled);
    }

    public KubeletConfigSpecBuilder(KubeletConfigSpecFluent<?> fluent, KubeletConfigSpec instance) {
        this(fluent, instance, false);
    }

    public KubeletConfigSpecBuilder(KubeletConfigSpecFluent<?> fluent, KubeletConfigSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAutoSizingReserved(instance.getAutoSizingReserved());
        fluent.withKubeletConfig(instance.getKubeletConfig());
        fluent.withLogLevel(instance.getLogLevel());
        fluent.withMachineConfigPoolSelector(instance.getMachineConfigPoolSelector());
        fluent.withTlsSecurityProfile(instance.getTlsSecurityProfile());
        this.validationEnabled = validationEnabled;
    }

    public KubeletConfigSpecBuilder(KubeletConfigSpec instance) {
        this(instance, (Boolean)false);
    }

    public KubeletConfigSpecBuilder(KubeletConfigSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAutoSizingReserved(instance.getAutoSizingReserved());
        this.withKubeletConfig(instance.getKubeletConfig());
        this.withLogLevel(instance.getLogLevel());
        this.withMachineConfigPoolSelector(instance.getMachineConfigPoolSelector());
        this.withTlsSecurityProfile(instance.getTlsSecurityProfile());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public KubeletConfigSpec build() {
        KubeletConfigSpec buildable = new KubeletConfigSpec(this.fluent.getAutoSizingReserved(), this.fluent.getKubeletConfig(), this.fluent.getLogLevel(), this.fluent.getMachineConfigPoolSelector(), this.fluent.getTlsSecurityProfile());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KubeletConfigSpecBuilder that = (KubeletConfigSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

