/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_7;

import io.fabric8.kubernetes.api.builder.v5_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_7.Nested;
import io.fabric8.kubernetes.api.model.v5_7.Status;
import io.fabric8.openshift.api.model.v5_7.Image;
import io.fabric8.openshift.api.model.v5_7.ImageBuilder;
import io.fabric8.openshift.api.model.v5_7.ImageFluentImpl;
import io.fabric8.openshift.api.model.v5_7.ImageImportStatus;
import io.fabric8.openshift.api.model.v5_7.ImageImportStatusFluent;
import java.util.Objects;

public class ImageImportStatusFluentImpl<A extends ImageImportStatusFluent<A>>
extends BaseFluent<A>
implements ImageImportStatusFluent<A> {
    private ImageBuilder image;
    private Status status;
    private String tag;

    public ImageImportStatusFluentImpl() {
    }

    public ImageImportStatusFluentImpl(ImageImportStatus instance) {
        this.withImage(instance.getImage());
        this.withStatus(instance.getStatus());
        this.withTag(instance.getTag());
    }

    @Override
    @Deprecated
    public Image getImage() {
        return this.image != null ? this.image.build() : null;
    }

    @Override
    public Image buildImage() {
        return this.image != null ? this.image.build() : null;
    }

    @Override
    public A withImage(Image image) {
        this._visitables.get("image").remove(this.image);
        if (image != null) {
            this.image = new ImageBuilder(image);
            this._visitables.get("image").add(this.image);
        }
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    public ImageImportStatusFluent.ImageNested<A> withNewImage() {
        return new ImageNestedImpl();
    }

    @Override
    public ImageImportStatusFluent.ImageNested<A> withNewImageLike(Image item) {
        return new ImageNestedImpl(item);
    }

    @Override
    public ImageImportStatusFluent.ImageNested<A> editImage() {
        return this.withNewImageLike(this.getImage());
    }

    @Override
    public ImageImportStatusFluent.ImageNested<A> editOrNewImage() {
        return this.withNewImageLike(this.getImage() != null ? this.getImage() : new ImageBuilder().build());
    }

    @Override
    public ImageImportStatusFluent.ImageNested<A> editOrNewImageLike(Image item) {
        return this.withNewImageLike(this.getImage() != null ? this.getImage() : item);
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public A withStatus(Status status) {
        this.status = status;
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public A withTag(String tag) {
        this.tag = tag;
        return (A)this;
    }

    @Override
    public Boolean hasTag() {
        return this.tag != null;
    }

    @Override
    @Deprecated
    public A withNewTag(String arg0) {
        return this.withTag(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageImportStatusFluentImpl that = (ImageImportStatusFluentImpl)o;
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        return !(this.tag != null ? !this.tag.equals(that.tag) : that.tag != null);
    }

    public int hashCode() {
        return Objects.hash(this.image, this.status, this.tag, super.hashCode());
    }

    public class ImageNestedImpl<N>
    extends ImageFluentImpl<ImageImportStatusFluent.ImageNested<N>>
    implements ImageImportStatusFluent.ImageNested<N>,
    Nested<N> {
        ImageBuilder builder;

        ImageNestedImpl(Image item) {
            this.builder = new ImageBuilder(this, item);
        }

        ImageNestedImpl() {
            this.builder = new ImageBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageImportStatusFluentImpl.this.withImage(this.builder.build());
        }

        @Override
        public N endImage() {
            return this.and();
        }
    }
}

