/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_7;

import io.fabric8.kubernetes.api.builder.v5_7.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_7.ExternalIPConfig;
import io.fabric8.openshift.api.model.v5_7.ExternalIPConfigFluent;
import io.fabric8.openshift.api.model.v5_7.ExternalIPConfigFluentImpl;
import java.util.Objects;

public class ExternalIPConfigBuilder
extends ExternalIPConfigFluentImpl<ExternalIPConfigBuilder>
implements VisitableBuilder<ExternalIPConfig, ExternalIPConfigBuilder> {
    ExternalIPConfigFluent<?> fluent;
    Boolean validationEnabled;

    public ExternalIPConfigBuilder() {
        this(false);
    }

    public ExternalIPConfigBuilder(Boolean validationEnabled) {
        this(new ExternalIPConfig(), validationEnabled);
    }

    public ExternalIPConfigBuilder(ExternalIPConfigFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ExternalIPConfigBuilder(ExternalIPConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ExternalIPConfig(), validationEnabled);
    }

    public ExternalIPConfigBuilder(ExternalIPConfigFluent<?> fluent, ExternalIPConfig instance) {
        this(fluent, instance, false);
    }

    public ExternalIPConfigBuilder(ExternalIPConfigFluent<?> fluent, ExternalIPConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAutoAssignCIDRs(instance.getAutoAssignCIDRs());
        fluent.withPolicy(instance.getPolicy());
        this.validationEnabled = validationEnabled;
    }

    public ExternalIPConfigBuilder(ExternalIPConfig instance) {
        this(instance, (Boolean)false);
    }

    public ExternalIPConfigBuilder(ExternalIPConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAutoAssignCIDRs(instance.getAutoAssignCIDRs());
        this.withPolicy(instance.getPolicy());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ExternalIPConfig build() {
        ExternalIPConfig buildable = new ExternalIPConfig(this.fluent.getAutoAssignCIDRs(), this.fluent.getPolicy());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExternalIPConfigBuilder that = (ExternalIPConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

