/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_7.dsl.base;

import io.fabric8.kubernetes.api.model.v5_7.DeletionPropagation;
import io.fabric8.kubernetes.clnt.v5_7.Config;
import io.fabric8.kubernetes.clnt.v5_7.utils.ApiVersionUtil;
import io.fabric8.kubernetes.clnt.v5_7.utils.Utils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import okhttp3.OkHttpClient;

public class OperationContext {
    protected OkHttpClient client;
    protected Config config;
    protected Object item;
    protected String resourceVersion;
    protected String plural;
    protected String apiGroupName;
    protected String apiGroupVersion;
    protected String namespace;
    protected String name;
    protected boolean cascading;
    protected boolean reloadingFromServer;
    protected boolean dryRun;
    protected boolean namespaceFromGlobalConfig;
    protected long gracePeriodSeconds = -1L;
    protected DeletionPropagation propagationPolicy;
    protected Map<String, String> labels;
    protected Map<String, String[]> labelsNot;
    protected Map<String, String[]> labelsIn;
    protected Map<String, String[]> labelsNotIn;
    protected Map<String, String> fields;
    protected Map<String, String[]> fieldsNot;

    public OperationContext() {
    }

    public OperationContext(OkHttpClient client, Config config, String plural, String namespace, String name, String apiGroupName, String apiGroupVersion, boolean cascading, Object item, Map<String, String> labels, Map<String, String[]> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields, Map<String, String[]> fieldsNot, String resourceVersion, boolean reloadingFromServer, long gracePeriodSeconds, DeletionPropagation propagationPolicy, boolean namespaceFromGlobalConfig, boolean dryRun) {
        this.client = client;
        this.config = config;
        this.plural = plural;
        this.namespace = Utils.isNotNullOrEmpty(namespace) ? namespace : (config != null ? config.getNamespace() : null);
        this.name = name;
        this.apiGroupName = ApiVersionUtil.apiGroup(item, apiGroupName);
        this.apiGroupVersion = ApiVersionUtil.apiVersion(item, apiGroupVersion);
        this.cascading = cascading;
        this.item = item;
        this.labels = Utils.getNonNullOrElse(labels, new HashMap());
        this.labelsNot = Utils.getNonNullOrElse(labelsNot, new HashMap());
        this.labelsIn = Utils.getNonNullOrElse(labelsIn, new HashMap());
        this.labelsNotIn = Utils.getNonNullOrElse(labelsNotIn, new HashMap());
        this.fields = Utils.getNonNullOrElse(fields, new HashMap());
        this.fieldsNot = Utils.getNonNullOrElse(fieldsNot, new HashMap());
        this.resourceVersion = resourceVersion;
        this.reloadingFromServer = reloadingFromServer;
        this.gracePeriodSeconds = gracePeriodSeconds;
        this.propagationPolicy = propagationPolicy;
        this.namespaceFromGlobalConfig = namespaceFromGlobalConfig;
        this.dryRun = dryRun;
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    public Config getConfig() {
        return this.config;
    }

    public String getPlural() {
        return this.plural;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public String getApiGroupName() {
        return this.apiGroupName;
    }

    public String getApiGroupVersion() {
        return this.apiGroupVersion;
    }

    public boolean getCascading() {
        return this.cascading;
    }

    public Object getItem() {
        return this.item;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Map<String, String[]> getLabelsNot() {
        return this.labelsNot;
    }

    public Map<String, String[]> getLabelsIn() {
        return this.labelsIn;
    }

    public Map<String, String[]> getLabelsNotIn() {
        return this.labelsNotIn;
    }

    public Map<String, String> getFields() {
        return this.fields;
    }

    public Map<String, String[]> getFieldsNot() {
        return this.fieldsNot;
    }

    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public boolean isReloadingFromServer() {
        return this.reloadingFromServer;
    }

    public long getGracePeriodSeconds() {
        return this.gracePeriodSeconds;
    }

    public DeletionPropagation getPropagationPolicy() {
        return this.propagationPolicy;
    }

    public boolean isNamespaceFromGlobalConfig() {
        return this.namespaceFromGlobalConfig;
    }

    public boolean getDryRun() {
        return this.dryRun;
    }

    public OperationContext copy() {
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.namespaceFromGlobalConfig, this.dryRun);
    }

    public OperationContext withOkhttpClient(OkHttpClient client) {
        if (this.client == client) {
            return this;
        }
        return new OperationContext(client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.namespaceFromGlobalConfig, this.dryRun);
    }

    public OperationContext withConfig(Config config) {
        if (this.config == config) {
            return this;
        }
        return new OperationContext(this.client, config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.namespaceFromGlobalConfig, this.dryRun);
    }

    public OperationContext withPlural(String plural) {
        if (Objects.equals(this.plural, plural)) {
            return this;
        }
        return new OperationContext(this.client, this.config, plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.namespaceFromGlobalConfig, this.dryRun);
    }

    public OperationContext withNamespace(String namespace) {
        if (Objects.equals(this.namespace, namespace)) {
            return this;
        }
        return new OperationContext(this.client, this.config, this.plural, namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.namespaceFromGlobalConfig, this.dryRun);
    }

    public OperationContext withName(String name) {
        if (Objects.equals(this.name, name)) {
            return this;
        }
        return new OperationContext(this.client, this.config, this.plural, this.namespace, name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.namespaceFromGlobalConfig, this.dryRun);
    }

    public OperationContext withApiGroupName(String apiGroupName) {
        if (Objects.equals(this.apiGroupName, apiGroupName)) {
            return this;
        }
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.namespaceFromGlobalConfig, this.dryRun);
    }

    public OperationContext withApiGroupVersion(String apiGroupVersion) {
        if (Objects.equals(this.apiGroupVersion, apiGroupVersion)) {
            return this;
        }
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.namespaceFromGlobalConfig, this.dryRun);
    }

    public OperationContext withItem(Object item) {
        if (this.item == item) {
            return this;
        }
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.namespaceFromGlobalConfig, this.dryRun);
    }

    public OperationContext withCascading(boolean cascading) {
        if (this.cascading == cascading) {
            return this;
        }
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.namespaceFromGlobalConfig, this.dryRun);
    }

    public OperationContext withLabels(Map<String, String> labels) {
        if (this.labels == labels) {
            return this;
        }
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.namespaceFromGlobalConfig, this.dryRun);
    }

    public OperationContext withLabelsIn(Map<String, String[]> labelsIn) {
        if (this.labelsIn == labelsIn) {
            return this;
        }
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.namespaceFromGlobalConfig, this.dryRun);
    }

    public OperationContext withLabelsNot(Map<String, String[]> labelsNot) {
        if (this.labelsNot == labelsNot) {
            return this;
        }
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.namespaceFromGlobalConfig, this.dryRun);
    }

    public OperationContext withLabelsNotIn(Map<String, String[]> labelsNotIn) {
        if (this.labelsNotIn == labelsNotIn) {
            return this;
        }
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.namespaceFromGlobalConfig, this.dryRun);
    }

    public OperationContext withFields(Map<String, String> fields) {
        if (this.fields == fields) {
            return this;
        }
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.namespaceFromGlobalConfig, this.dryRun);
    }

    public OperationContext withFieldsNot(Map<String, String[]> fieldsNot) {
        if (this.fieldsNot == fieldsNot) {
            return this;
        }
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.namespaceFromGlobalConfig, this.dryRun);
    }

    public OperationContext withResourceVersion(String resourceVersion) {
        if (Objects.equals(this.resourceVersion, resourceVersion)) {
            return this;
        }
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.namespaceFromGlobalConfig, this.dryRun);
    }

    public OperationContext withReloadingFromServer(boolean reloadingFromServer) {
        if (this.reloadingFromServer == reloadingFromServer) {
            return this;
        }
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.namespaceFromGlobalConfig, this.dryRun);
    }

    public OperationContext withGracePeriodSeconds(long gracePeriodSeconds) {
        if (this.gracePeriodSeconds == gracePeriodSeconds) {
            return this;
        }
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, gracePeriodSeconds, this.propagationPolicy, this.namespaceFromGlobalConfig, this.dryRun);
    }

    public OperationContext withPropagationPolicy(DeletionPropagation propagationPolicy) {
        if (this.propagationPolicy == propagationPolicy) {
            return this;
        }
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, propagationPolicy, this.namespaceFromGlobalConfig, this.dryRun);
    }

    public OperationContext withIsNamespaceConfiguredFromGlobalConfig(boolean namespaceFromGlobalConfig) {
        if (this.namespaceFromGlobalConfig == namespaceFromGlobalConfig) {
            return this;
        }
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, namespaceFromGlobalConfig, this.dryRun);
    }

    public OperationContext withDryRun(boolean dryRun) {
        return new OperationContext(this.client, this.config, this.plural, this.namespace, this.name, this.apiGroupName, this.apiGroupVersion, this.cascading, this.item, this.labels, this.labelsNot, this.labelsIn, this.labelsNotIn, this.fields, this.fieldsNot, this.resourceVersion, this.reloadingFromServer, this.gracePeriodSeconds, this.propagationPolicy, this.namespaceFromGlobalConfig, dryRun);
    }

    public OperationContext withOperationContext(OperationContext context) {
        return new OperationContext(Utils.getNonNullOrElse(context.getClient(), this.getClient()), Utils.getNonNullOrElse(context.getConfig(), this.getConfig()), Utils.getNonNullOrElse(context.getPlural(), this.getPlural()), Utils.getNonNullOrElse(context.getNamespace(), this.getNamespace()), Utils.getNonNullOrElse(context.getName(), this.getName()), Utils.getNonNullOrElse(context.getApiGroupName(), this.getApiGroupName()), Utils.getNonNullOrElse(context.getApiGroupVersion(), this.getApiGroupVersion()), context.getCascading() ? context.getCascading() : this.getCascading(), Utils.getNonNullOrElse(context.getItem(), this.getItem()), Utils.getNonNullOrElse(context.getLabels(), this.getLabels()), Utils.getNonNullOrElse(context.getLabelsNot(), this.getLabelsNot()), Utils.getNonNullOrElse(context.getLabelsIn(), this.getLabelsIn()), Utils.getNonNullOrElse(context.getLabelsNotIn(), this.getLabelsNotIn()), Utils.getNonNullOrElse(context.getFields(), this.getFields()), Utils.getNonNullOrElse(context.getFieldsNot(), this.getFieldsNot()), Utils.getNonNullOrElse(context.getResourceVersion(), this.getResourceVersion()), context.isReloadingFromServer() ? context.isReloadingFromServer() : this.isReloadingFromServer(), context.getGracePeriodSeconds() > 0L ? context.getGracePeriodSeconds() : this.getGracePeriodSeconds(), Utils.getNonNullOrElse(context.getPropagationPolicy(), this.getPropagationPolicy()), context.isNamespaceFromGlobalConfig() ? context.isNamespaceFromGlobalConfig() : this.isNamespaceFromGlobalConfig(), context.getDryRun() ? context.getDryRun() : this.getDryRun());
    }
}

