/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.builder.v5_7;

import io.fabric8.kubernetes.api.builder.v5_7.Builder;
import io.fabric8.kubernetes.api.builder.v5_7.Editable;
import io.fabric8.kubernetes.api.builder.v5_7.Fluent;
import io.fabric8.kubernetes.api.builder.v5_7.PathAwareTypedVisitor;
import io.fabric8.kubernetes.api.builder.v5_7.TypedVisitor;
import io.fabric8.kubernetes.api.builder.v5_7.Visitable;
import io.fabric8.kubernetes.api.builder.v5_7.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.v5_7.VisitableMap;
import io.fabric8.kubernetes.api.builder.v5_7.Visitor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class BaseFluent<F extends Fluent<F>>
implements Fluent<F>,
Visitable<F> {
    public static final String VISIT = "visit";
    public final VisitableMap _visitables = new VisitableMap();

    public static <T> VisitableBuilder<T, ?> builderOf(T item) {
        Object editor;
        if (item instanceof Editable && (editor = ((Editable)item).edit()) instanceof VisitableBuilder) {
            return (VisitableBuilder)editor;
        }
        try {
            return (VisitableBuilder)Class.forName(item.getClass().getName() + "Builder").getConstructor(item.getClass()).newInstance(item);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create builder for: " + item.getClass(), e);
        }
    }

    public static <T> ArrayList<T> build(List<? extends Builder<? extends T>> list) {
        return list == null ? null : new ArrayList(list.stream().map(Builder::build).collect(Collectors.toList()));
    }

    public static <T> ArrayList<T> build(Set<? extends Builder<? extends T>> set) {
        return set == null ? null : new ArrayList(set.stream().map(Builder::build).collect(Collectors.toList()));
    }

    public static <T> ArrayList<T> aggregate(List<? extends T> ... lists) {
        return new ArrayList(Arrays.stream(lists).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    public static <T> LinkedHashSet<T> aggregate(Set<? extends T>[] sets) {
        return new LinkedHashSet(Arrays.stream(sets).filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    public static <V extends Visitor<?>, F> Boolean canVisit(V visitor, F fluent) {
        Class<?> actaulParentType;
        PathAwareTypedVisitor pathAwareTypedVisitor;
        Class parentType;
        if (visitor instanceof TypedVisitor && !((TypedVisitor)visitor).getType().isAssignableFrom(fluent.getClass())) {
            return false;
        }
        if (visitor instanceof PathAwareTypedVisitor && !(parentType = (pathAwareTypedVisitor = (PathAwareTypedVisitor)visitor).getParentType()).isAssignableFrom(actaulParentType = pathAwareTypedVisitor.getActualParentType())) {
            return false;
        }
        return BaseFluent.hasCompatibleVisitMethod(visitor, fluent);
    }

    public static <V, F> Boolean hasCompatibleVisitMethod(V visitor, F fluent) {
        for (Method method : visitor.getClass().getMethods()) {
            if (!method.getName().equals(VISIT) || method.getParameterTypes().length != 1) continue;
            Class<?> visitorType = method.getParameterTypes()[0];
            if (visitorType.isAssignableFrom(fluent.getClass())) {
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public F accept(Visitor ... visitors) {
        return BaseFluent.isPathAwareVisitorArray(visitors) ? this.acceptPathAware(BaseFluent.asPathAwareVisitorArray(visitors)) : this.acceptInternal(visitors);
    }

    @Override
    public <V> F accept(final Class<V> type, final Visitor<V> visitor) {
        return (F)this.accept(new Visitor[]{new TypedVisitor<V>(){

            @Override
            public Class<V> getType() {
                return type;
            }

            @Override
            public void visit(V element) {
                visitor.visit(element);
            }
        }});
    }

    public F acceptInternal(Visitor<?> ... visitors) {
        for (Visitor<?> visitor : visitors) {
            for (Visitable<?> visitable : this._visitables) {
                visitable.accept(visitor);
            }
            if (!BaseFluent.canVisit(visitor, this).booleanValue()) continue;
            visitor.visit(this);
        }
        return (F)this;
    }

    private F acceptPathAware(PathAwareTypedVisitor<?, ?> ... pathAwareTypedVisitors) {
        return this.acceptInternal((Visitor[])Arrays.stream(pathAwareTypedVisitors).map(p -> p.next(this)).toArray(PathAwareTypedVisitor[]::new));
    }

    private static boolean isPathAwareVisitorArray(Visitor<?>[] visitors) {
        return !Arrays.stream(visitors).filter(v -> !(v instanceof PathAwareTypedVisitor)).findAny().isPresent();
    }

    private static PathAwareTypedVisitor<?, ?>[] asPathAwareVisitorArray(Visitor<?>[] visitors) {
        return (PathAwareTypedVisitor[])Arrays.stream(visitors).filter(v -> v instanceof PathAwareTypedVisitor).map(v -> (PathAwareTypedVisitor)v).toArray(PathAwareTypedVisitor[]::new);
    }
}

