/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.AWSPlatformStatus;
import io.fabric8.openshift.api.model.AWSPlatformStatusFluent;
import io.fabric8.openshift.api.model.AWSPlatformStatusFluentImpl;
import java.util.Objects;

public class AWSPlatformStatusBuilder
extends AWSPlatformStatusFluentImpl<AWSPlatformStatusBuilder>
implements VisitableBuilder<AWSPlatformStatus, AWSPlatformStatusBuilder> {
    AWSPlatformStatusFluent<?> fluent;
    Boolean validationEnabled;

    public AWSPlatformStatusBuilder() {
        this(false);
    }

    public AWSPlatformStatusBuilder(Boolean validationEnabled) {
        this(new AWSPlatformStatus(), validationEnabled);
    }

    public AWSPlatformStatusBuilder(AWSPlatformStatusFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public AWSPlatformStatusBuilder(AWSPlatformStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new AWSPlatformStatus(), validationEnabled);
    }

    public AWSPlatformStatusBuilder(AWSPlatformStatusFluent<?> fluent, AWSPlatformStatus instance) {
        this(fluent, instance, false);
    }

    public AWSPlatformStatusBuilder(AWSPlatformStatusFluent<?> fluent, AWSPlatformStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withRegion(instance.getRegion());
        fluent.withResourceTags(instance.getResourceTags());
        fluent.withServiceEndpoints(instance.getServiceEndpoints());
        this.validationEnabled = validationEnabled;
    }

    public AWSPlatformStatusBuilder(AWSPlatformStatus instance) {
        this(instance, (Boolean)false);
    }

    public AWSPlatformStatusBuilder(AWSPlatformStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withRegion(instance.getRegion());
        this.withResourceTags(instance.getResourceTags());
        this.withServiceEndpoints(instance.getServiceEndpoints());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public AWSPlatformStatus build() {
        AWSPlatformStatus buildable = new AWSPlatformStatus(this.fluent.getRegion(), this.fluent.getResourceTags(), this.fluent.getServiceEndpoints());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AWSPlatformStatusBuilder that = (AWSPlatformStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

