/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_7;

import io.fabric8.kubernetes.api.builder.v5_7.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_7.ConnectionConfig;
import io.fabric8.openshift.api.model.v5_7.ConnectionConfigFluent;
import io.fabric8.openshift.api.model.v5_7.ConnectionConfigFluentImpl;
import java.util.Objects;

public class ConnectionConfigBuilder
extends ConnectionConfigFluentImpl<ConnectionConfigBuilder>
implements VisitableBuilder<ConnectionConfig, ConnectionConfigBuilder> {
    ConnectionConfigFluent<?> fluent;
    Boolean validationEnabled;

    public ConnectionConfigBuilder() {
        this(false);
    }

    public ConnectionConfigBuilder(Boolean validationEnabled) {
        this(new ConnectionConfig(), validationEnabled);
    }

    public ConnectionConfigBuilder(ConnectionConfigFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ConnectionConfigBuilder(ConnectionConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ConnectionConfig(), validationEnabled);
    }

    public ConnectionConfigBuilder(ConnectionConfigFluent<?> fluent, ConnectionConfig instance) {
        this(fluent, instance, false);
    }

    public ConnectionConfigBuilder(ConnectionConfigFluent<?> fluent, ConnectionConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCa(instance.getCa());
        fluent.withTlsClientConfig(instance.getTlsClientConfig());
        fluent.withUrl(instance.getUrl());
        this.validationEnabled = validationEnabled;
    }

    public ConnectionConfigBuilder(ConnectionConfig instance) {
        this(instance, (Boolean)false);
    }

    public ConnectionConfigBuilder(ConnectionConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCa(instance.getCa());
        this.withTlsClientConfig(instance.getTlsClientConfig());
        this.withUrl(instance.getUrl());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ConnectionConfig build() {
        ConnectionConfig buildable = new ConnectionConfig(this.fluent.getCa(), this.fluent.getTlsClientConfig(), this.fluent.getUrl());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConnectionConfigBuilder that = (ConnectionConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

