/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_7;

import io.fabric8.kubernetes.api.builder.v5_7.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_7.BuildStrategy;
import io.fabric8.openshift.api.model.v5_7.BuildStrategyFluent;
import io.fabric8.openshift.api.model.v5_7.BuildStrategyFluentImpl;
import java.util.Objects;

public class BuildStrategyBuilder
extends BuildStrategyFluentImpl<BuildStrategyBuilder>
implements VisitableBuilder<BuildStrategy, BuildStrategyBuilder> {
    BuildStrategyFluent<?> fluent;
    Boolean validationEnabled;

    public BuildStrategyBuilder() {
        this(false);
    }

    public BuildStrategyBuilder(Boolean validationEnabled) {
        this(new BuildStrategy(), validationEnabled);
    }

    public BuildStrategyBuilder(BuildStrategyFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public BuildStrategyBuilder(BuildStrategyFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new BuildStrategy(), validationEnabled);
    }

    public BuildStrategyBuilder(BuildStrategyFluent<?> fluent, BuildStrategy instance) {
        this(fluent, instance, false);
    }

    public BuildStrategyBuilder(BuildStrategyFluent<?> fluent, BuildStrategy instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCustomStrategy(instance.getCustomStrategy());
        fluent.withDockerStrategy(instance.getDockerStrategy());
        fluent.withJenkinsPipelineStrategy(instance.getJenkinsPipelineStrategy());
        fluent.withSourceStrategy(instance.getSourceStrategy());
        fluent.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public BuildStrategyBuilder(BuildStrategy instance) {
        this(instance, (Boolean)false);
    }

    public BuildStrategyBuilder(BuildStrategy instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCustomStrategy(instance.getCustomStrategy());
        this.withDockerStrategy(instance.getDockerStrategy());
        this.withJenkinsPipelineStrategy(instance.getJenkinsPipelineStrategy());
        this.withSourceStrategy(instance.getSourceStrategy());
        this.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public BuildStrategy build() {
        BuildStrategy buildable = new BuildStrategy(this.fluent.getCustomStrategy(), this.fluent.getDockerStrategy(), this.fluent.getJenkinsPipelineStrategy(), this.fluent.getSourceStrategy(), this.fluent.getType());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildStrategyBuilder that = (BuildStrategyBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

