/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_7.dsl.internal;

import io.fabric8.kubernetes.api.model.v5_7.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_7.Status;
import io.fabric8.kubernetes.clnt.v5_7.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_7.WatcherException;
import io.fabric8.kubernetes.clnt.v5_7.dsl.base.OperationSupport;
import io.fabric8.kubernetes.clnt.v5_7.dsl.internal.AbstractWatchManager;
import io.fabric8.kubernetes.clnt.v5_7.dsl.internal.WatchConnectionManager;
import io.fabric8.kubernetes.clnt.v5_7.utils.Utils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WatcherWebSocketListener<T extends HasMetadata>
extends WebSocketListener {
    protected static final Logger logger = LoggerFactory.getLogger(WatcherWebSocketListener.class);
    private final CompletableFuture<Void> startedFuture = new CompletableFuture();
    protected final AbstractWatchManager<T> manager;

    protected WatcherWebSocketListener(AbstractWatchManager<T> manager) {
        this.manager = manager;
    }

    public void onOpen(WebSocket webSocket, Response response) {
        WatchConnectionManager.closeBody(response);
        logger.debug("WebSocket successfully opened");
        this.manager.resetReconnectAttempts();
        this.startedFuture.complete(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(WebSocket webSocket, Throwable t, Response response) {
        try {
            if (this.manager.isForceClosed()) {
                logger.debug("Ignoring onFailure for already closed/closing websocket", t);
                return;
            }
            if (response != null) {
                int code = response.code();
                if (200 == code || 503 == code) {
                    this.pushException(new KubernetesClientException("Received " + code + " on websocket", code, null));
                    return;
                }
                Status status = OperationSupport.createStatus(response);
                logger.warn("Exec Failure: HTTP {}, Status: {} - {}", new Object[]{code, status.getCode(), status.getMessage()});
                this.pushException(new KubernetesClientException(status));
            } else {
                logger.warn("Exec Failure {} {}", (Object)t.getClass().getName(), (Object)t.getMessage());
                this.pushException(new KubernetesClientException("Failed to start websocket", t));
            }
        }
        finally {
            WatchConnectionManager.closeBody(response);
        }
        if (this.manager.cannotReconnect()) {
            this.manager.close(new WatcherException("Connection failure", t));
            return;
        }
        this.manager.scheduleReconnect();
    }

    public void onMessage(WebSocket webSocket, String text) {
        this.manager.onMessage(text);
    }

    private void pushException(KubernetesClientException exception) {
        if (!this.startedFuture.completeExceptionally(exception)) {
            logger.debug("Couldn't report exception", (Throwable)exception);
        }
    }

    public void onMessage(WebSocket webSocket, ByteString bytes) {
        this.onMessage(webSocket, bytes.utf8());
    }

    public void onClosing(WebSocket webSocket, int code, String reason) {
        logger.debug("Socket closing: {}", (Object)reason);
        webSocket.close(code, reason);
    }

    public void onClosed(WebSocket webSocket, int code, String reason) {
        logger.debug("WebSocket close received. code: {}, reason: {}", (Object)code, (Object)reason);
        this.manager.scheduleReconnect();
    }

    protected void waitUntilReady() {
        Utils.waitUntilReadyOrFail(this.startedFuture, 10L, TimeUnit.SECONDS);
    }
}

