/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_7.networking.v1;

import io.fabric8.kubernetes.api.builder.v5_7.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_7.networking.v1.NetworkPolicyPort;
import io.fabric8.kubernetes.api.model.v5_7.networking.v1.NetworkPolicyPortFluent;
import io.fabric8.kubernetes.api.model.v5_7.networking.v1.NetworkPolicyPortFluentImpl;
import java.util.Objects;

public class NetworkPolicyPortBuilder
extends NetworkPolicyPortFluentImpl<NetworkPolicyPortBuilder>
implements VisitableBuilder<NetworkPolicyPort, NetworkPolicyPortBuilder> {
    NetworkPolicyPortFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkPolicyPortBuilder() {
        this(false);
    }

    public NetworkPolicyPortBuilder(Boolean validationEnabled) {
        this(new NetworkPolicyPort(), validationEnabled);
    }

    public NetworkPolicyPortBuilder(NetworkPolicyPortFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public NetworkPolicyPortBuilder(NetworkPolicyPortFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NetworkPolicyPort(), validationEnabled);
    }

    public NetworkPolicyPortBuilder(NetworkPolicyPortFluent<?> fluent, NetworkPolicyPort instance) {
        this(fluent, instance, false);
    }

    public NetworkPolicyPortBuilder(NetworkPolicyPortFluent<?> fluent, NetworkPolicyPort instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withEndPort(instance.getEndPort());
        fluent.withPort(instance.getPort());
        fluent.withProtocol(instance.getProtocol());
        this.validationEnabled = validationEnabled;
    }

    public NetworkPolicyPortBuilder(NetworkPolicyPort instance) {
        this(instance, (Boolean)false);
    }

    public NetworkPolicyPortBuilder(NetworkPolicyPort instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withEndPort(instance.getEndPort());
        this.withPort(instance.getPort());
        this.withProtocol(instance.getProtocol());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public NetworkPolicyPort build() {
        NetworkPolicyPort buildable = new NetworkPolicyPort(this.fluent.getEndPort(), this.fluent.getPort(), this.fluent.getProtocol());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkPolicyPortBuilder that = (NetworkPolicyPortBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

