/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_7;

import io.fabric8.kubernetes.api.builder.v5_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_7.Nested;
import io.fabric8.kubernetes.api.model.v5_7.ISCSIVolumeSource;
import io.fabric8.kubernetes.api.model.v5_7.ISCSIVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.v5_7.LocalObjectReference;
import io.fabric8.kubernetes.api.model.v5_7.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v5_7.LocalObjectReferenceFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ISCSIVolumeSourceFluentImpl<A extends ISCSIVolumeSourceFluent<A>>
extends BaseFluent<A>
implements ISCSIVolumeSourceFluent<A> {
    private Boolean chapAuthDiscovery;
    private Boolean chapAuthSession;
    private String fsType;
    private String initiatorName;
    private String iqn;
    private String iscsiInterface;
    private Integer lun;
    private List<String> portals = new ArrayList<String>();
    private Boolean readOnly;
    private LocalObjectReferenceBuilder secretRef;
    private String targetPortal;

    public ISCSIVolumeSourceFluentImpl() {
    }

    public ISCSIVolumeSourceFluentImpl(ISCSIVolumeSource instance) {
        this.withChapAuthDiscovery(instance.getChapAuthDiscovery());
        this.withChapAuthSession(instance.getChapAuthSession());
        this.withFsType(instance.getFsType());
        this.withInitiatorName(instance.getInitiatorName());
        this.withIqn(instance.getIqn());
        this.withIscsiInterface(instance.getIscsiInterface());
        this.withLun(instance.getLun());
        this.withPortals(instance.getPortals());
        this.withReadOnly(instance.getReadOnly());
        this.withSecretRef(instance.getSecretRef());
        this.withTargetPortal(instance.getTargetPortal());
    }

    @Override
    public Boolean getChapAuthDiscovery() {
        return this.chapAuthDiscovery;
    }

    @Override
    public A withChapAuthDiscovery(Boolean chapAuthDiscovery) {
        this.chapAuthDiscovery = chapAuthDiscovery;
        return (A)this;
    }

    @Override
    public Boolean hasChapAuthDiscovery() {
        return this.chapAuthDiscovery != null;
    }

    @Override
    public Boolean getChapAuthSession() {
        return this.chapAuthSession;
    }

    @Override
    public A withChapAuthSession(Boolean chapAuthSession) {
        this.chapAuthSession = chapAuthSession;
        return (A)this;
    }

    @Override
    public Boolean hasChapAuthSession() {
        return this.chapAuthSession != null;
    }

    @Override
    public String getFsType() {
        return this.fsType;
    }

    @Override
    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)this;
    }

    @Override
    public Boolean hasFsType() {
        return this.fsType != null;
    }

    @Override
    @Deprecated
    public A withNewFsType(String arg0) {
        return this.withFsType(new String(arg0));
    }

    @Override
    public String getInitiatorName() {
        return this.initiatorName;
    }

    @Override
    public A withInitiatorName(String initiatorName) {
        this.initiatorName = initiatorName;
        return (A)this;
    }

    @Override
    public Boolean hasInitiatorName() {
        return this.initiatorName != null;
    }

    @Override
    @Deprecated
    public A withNewInitiatorName(String arg0) {
        return this.withInitiatorName(new String(arg0));
    }

    @Override
    public String getIqn() {
        return this.iqn;
    }

    @Override
    public A withIqn(String iqn) {
        this.iqn = iqn;
        return (A)this;
    }

    @Override
    public Boolean hasIqn() {
        return this.iqn != null;
    }

    @Override
    @Deprecated
    public A withNewIqn(String arg0) {
        return this.withIqn(new String(arg0));
    }

    @Override
    public String getIscsiInterface() {
        return this.iscsiInterface;
    }

    @Override
    public A withIscsiInterface(String iscsiInterface) {
        this.iscsiInterface = iscsiInterface;
        return (A)this;
    }

    @Override
    public Boolean hasIscsiInterface() {
        return this.iscsiInterface != null;
    }

    @Override
    @Deprecated
    public A withNewIscsiInterface(String arg0) {
        return this.withIscsiInterface(new String(arg0));
    }

    @Override
    public Integer getLun() {
        return this.lun;
    }

    @Override
    public A withLun(Integer lun) {
        this.lun = lun;
        return (A)this;
    }

    @Override
    public Boolean hasLun() {
        return this.lun != null;
    }

    @Override
    public A addToPortals(Integer index, String item) {
        if (this.portals == null) {
            this.portals = new ArrayList<String>();
        }
        this.portals.add(index, item);
        return (A)this;
    }

    @Override
    public A setToPortals(Integer index, String item) {
        if (this.portals == null) {
            this.portals = new ArrayList<String>();
        }
        this.portals.set(index, item);
        return (A)this;
    }

    @Override
    public A addToPortals(String ... items) {
        if (this.portals == null) {
            this.portals = new ArrayList<String>();
        }
        for (String item : items) {
            this.portals.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToPortals(Collection<String> items) {
        if (this.portals == null) {
            this.portals = new ArrayList<String>();
        }
        for (String item : items) {
            this.portals.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromPortals(String ... items) {
        for (String item : items) {
            if (this.portals == null) continue;
            this.portals.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPortals(Collection<String> items) {
        for (String item : items) {
            if (this.portals == null) continue;
            this.portals.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getPortals() {
        return this.portals;
    }

    @Override
    public String getPortal(Integer index) {
        return this.portals.get(index);
    }

    @Override
    public String getFirstPortal() {
        return this.portals.get(0);
    }

    @Override
    public String getLastPortal() {
        return this.portals.get(this.portals.size() - 1);
    }

    @Override
    public String getMatchingPortal(Predicate<String> predicate) {
        for (String item : this.portals) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPortal(Predicate<String> predicate) {
        for (String item : this.portals) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPortals(List<String> portals) {
        if (portals != null) {
            this.portals = new ArrayList<String>();
            for (String item : portals) {
                this.addToPortals(item);
            }
        } else {
            this.portals = null;
        }
        return (A)this;
    }

    @Override
    public A withPortals(String ... portals) {
        if (this.portals != null) {
            this.portals.clear();
        }
        if (portals != null) {
            for (String item : portals) {
                this.addToPortals(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPortals() {
        return this.portals != null && !this.portals.isEmpty();
    }

    @Override
    public A addNewPortal(String arg0) {
        return this.addToPortals(new String(arg0));
    }

    @Override
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    @Override
    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    @Override
    @Deprecated
    public LocalObjectReference getSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public LocalObjectReference buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public A withSecretRef(LocalObjectReference secretRef) {
        this._visitables.get("secretRef").remove(this.secretRef);
        if (secretRef != null) {
            this.secretRef = new LocalObjectReferenceBuilder(secretRef);
            this._visitables.get("secretRef").add(this.secretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretRef() {
        return this.secretRef != null;
    }

    @Override
    public A withNewSecretRef(String name) {
        return this.withSecretRef(new LocalObjectReference(name));
    }

    @Override
    public ISCSIVolumeSourceFluent.SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNestedImpl();
    }

    @Override
    public ISCSIVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(LocalObjectReference item) {
        return new SecretRefNestedImpl(item);
    }

    @Override
    public ISCSIVolumeSourceFluent.SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef());
    }

    @Override
    public ISCSIVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public ISCSIVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(LocalObjectReference item) {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : item);
    }

    @Override
    public String getTargetPortal() {
        return this.targetPortal;
    }

    @Override
    public A withTargetPortal(String targetPortal) {
        this.targetPortal = targetPortal;
        return (A)this;
    }

    @Override
    public Boolean hasTargetPortal() {
        return this.targetPortal != null;
    }

    @Override
    @Deprecated
    public A withNewTargetPortal(String arg0) {
        return this.withTargetPortal(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ISCSIVolumeSourceFluentImpl that = (ISCSIVolumeSourceFluentImpl)o;
        if (this.chapAuthDiscovery != null ? !this.chapAuthDiscovery.equals(that.chapAuthDiscovery) : that.chapAuthDiscovery != null) {
            return false;
        }
        if (this.chapAuthSession != null ? !this.chapAuthSession.equals(that.chapAuthSession) : that.chapAuthSession != null) {
            return false;
        }
        if (this.fsType != null ? !this.fsType.equals(that.fsType) : that.fsType != null) {
            return false;
        }
        if (this.initiatorName != null ? !this.initiatorName.equals(that.initiatorName) : that.initiatorName != null) {
            return false;
        }
        if (this.iqn != null ? !this.iqn.equals(that.iqn) : that.iqn != null) {
            return false;
        }
        if (this.iscsiInterface != null ? !this.iscsiInterface.equals(that.iscsiInterface) : that.iscsiInterface != null) {
            return false;
        }
        if (this.lun != null ? !this.lun.equals(that.lun) : that.lun != null) {
            return false;
        }
        if (this.portals != null ? !this.portals.equals(that.portals) : that.portals != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        if (this.secretRef != null ? !this.secretRef.equals(that.secretRef) : that.secretRef != null) {
            return false;
        }
        return !(this.targetPortal != null ? !this.targetPortal.equals(that.targetPortal) : that.targetPortal != null);
    }

    public int hashCode() {
        return Objects.hash(this.chapAuthDiscovery, this.chapAuthSession, this.fsType, this.initiatorName, this.iqn, this.iscsiInterface, this.lun, this.portals, this.readOnly, this.secretRef, this.targetPortal, super.hashCode());
    }

    public class SecretRefNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<ISCSIVolumeSourceFluent.SecretRefNested<N>>
    implements ISCSIVolumeSourceFluent.SecretRefNested<N>,
    Nested<N> {
        LocalObjectReferenceBuilder builder;

        SecretRefNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        SecretRefNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ISCSIVolumeSourceFluentImpl.this.withSecretRef(this.builder.build());
        }

        @Override
        public N endSecretRef() {
            return this.and();
        }
    }
}

