/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_7;

import io.fabric8.kubernetes.api.builder.v5_7.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_7.EndpointAddress;
import io.fabric8.kubernetes.api.model.v5_7.EndpointAddressFluent;
import io.fabric8.kubernetes.api.model.v5_7.EndpointAddressFluentImpl;
import java.util.Objects;

public class EndpointAddressBuilder
extends EndpointAddressFluentImpl<EndpointAddressBuilder>
implements VisitableBuilder<EndpointAddress, EndpointAddressBuilder> {
    EndpointAddressFluent<?> fluent;
    Boolean validationEnabled;

    public EndpointAddressBuilder() {
        this(false);
    }

    public EndpointAddressBuilder(Boolean validationEnabled) {
        this(new EndpointAddress(), validationEnabled);
    }

    public EndpointAddressBuilder(EndpointAddressFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public EndpointAddressBuilder(EndpointAddressFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new EndpointAddress(), validationEnabled);
    }

    public EndpointAddressBuilder(EndpointAddressFluent<?> fluent, EndpointAddress instance) {
        this(fluent, instance, false);
    }

    public EndpointAddressBuilder(EndpointAddressFluent<?> fluent, EndpointAddress instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withHostname(instance.getHostname());
        fluent.withIp(instance.getIp());
        fluent.withNodeName(instance.getNodeName());
        fluent.withTargetRef(instance.getTargetRef());
        this.validationEnabled = validationEnabled;
    }

    public EndpointAddressBuilder(EndpointAddress instance) {
        this(instance, (Boolean)false);
    }

    public EndpointAddressBuilder(EndpointAddress instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withHostname(instance.getHostname());
        this.withIp(instance.getIp());
        this.withNodeName(instance.getNodeName());
        this.withTargetRef(instance.getTargetRef());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public EndpointAddress build() {
        EndpointAddress buildable = new EndpointAddress(this.fluent.getHostname(), this.fluent.getIp(), this.fluent.getNodeName(), this.fluent.getTargetRef());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EndpointAddressBuilder that = (EndpointAddressBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

