/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_7;

import io.fabric8.kubernetes.api.builder.v5_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_7.Nested;
import io.fabric8.kubernetes.api.model.v5_7.AuthInfo;
import io.fabric8.kubernetes.api.model.v5_7.AuthInfoFluent;
import io.fabric8.kubernetes.api.model.v5_7.AuthProviderConfig;
import io.fabric8.kubernetes.api.model.v5_7.AuthProviderConfigBuilder;
import io.fabric8.kubernetes.api.model.v5_7.AuthProviderConfigFluentImpl;
import io.fabric8.kubernetes.api.model.v5_7.ExecConfig;
import io.fabric8.kubernetes.api.model.v5_7.ExecConfigBuilder;
import io.fabric8.kubernetes.api.model.v5_7.ExecConfigFluentImpl;
import io.fabric8.kubernetes.api.model.v5_7.NamedExtension;
import io.fabric8.kubernetes.api.model.v5_7.NamedExtensionBuilder;
import io.fabric8.kubernetes.api.model.v5_7.NamedExtensionFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class AuthInfoFluentImpl<A extends AuthInfoFluent<A>>
extends BaseFluent<A>
implements AuthInfoFluent<A> {
    private String as;
    private List<String> asGroups = new ArrayList<String>();
    private Map<String, ArrayList<String>> asUserExtra;
    private AuthProviderConfigBuilder authProvider;
    private String clientCertificate;
    private String clientCertificateData;
    private String clientKey;
    private String clientKeyData;
    private ExecConfigBuilder exec;
    private List<NamedExtensionBuilder> extensions = new ArrayList<NamedExtensionBuilder>();
    private String password;
    private String token;
    private String tokenFile;
    private String username;

    public AuthInfoFluentImpl() {
    }

    public AuthInfoFluentImpl(AuthInfo instance) {
        this.withAs(instance.getAs());
        this.withAsGroups(instance.getAsGroups());
        this.withAsUserExtra(instance.getAsUserExtra());
        this.withAuthProvider(instance.getAuthProvider());
        this.withClientCertificate(instance.getClientCertificate());
        this.withClientCertificateData(instance.getClientCertificateData());
        this.withClientKey(instance.getClientKey());
        this.withClientKeyData(instance.getClientKeyData());
        this.withExec(instance.getExec());
        this.withExtensions(instance.getExtensions());
        this.withPassword(instance.getPassword());
        this.withToken(instance.getToken());
        this.withTokenFile(instance.getTokenFile());
        this.withUsername(instance.getUsername());
    }

    @Override
    public String getAs() {
        return this.as;
    }

    @Override
    public A withAs(String as) {
        this.as = as;
        return (A)this;
    }

    @Override
    public Boolean hasAs() {
        return this.as != null;
    }

    @Override
    @Deprecated
    public A withNewAs(String arg0) {
        return this.withAs(new String(arg0));
    }

    @Override
    public A addToAsGroups(Integer index, String item) {
        if (this.asGroups == null) {
            this.asGroups = new ArrayList<String>();
        }
        this.asGroups.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAsGroups(Integer index, String item) {
        if (this.asGroups == null) {
            this.asGroups = new ArrayList<String>();
        }
        this.asGroups.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAsGroups(String ... items) {
        if (this.asGroups == null) {
            this.asGroups = new ArrayList<String>();
        }
        for (String item : items) {
            this.asGroups.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAsGroups(Collection<String> items) {
        if (this.asGroups == null) {
            this.asGroups = new ArrayList<String>();
        }
        for (String item : items) {
            this.asGroups.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAsGroups(String ... items) {
        for (String item : items) {
            if (this.asGroups == null) continue;
            this.asGroups.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAsGroups(Collection<String> items) {
        for (String item : items) {
            if (this.asGroups == null) continue;
            this.asGroups.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAsGroups() {
        return this.asGroups;
    }

    @Override
    public String getAsGroup(Integer index) {
        return this.asGroups.get(index);
    }

    @Override
    public String getFirstAsGroup() {
        return this.asGroups.get(0);
    }

    @Override
    public String getLastAsGroup() {
        return this.asGroups.get(this.asGroups.size() - 1);
    }

    @Override
    public String getMatchingAsGroup(Predicate<String> predicate) {
        for (String item : this.asGroups) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAsGroup(Predicate<String> predicate) {
        for (String item : this.asGroups) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAsGroups(List<String> asGroups) {
        if (asGroups != null) {
            this.asGroups = new ArrayList<String>();
            for (String item : asGroups) {
                this.addToAsGroups(item);
            }
        } else {
            this.asGroups = null;
        }
        return (A)this;
    }

    @Override
    public A withAsGroups(String ... asGroups) {
        if (this.asGroups != null) {
            this.asGroups.clear();
        }
        if (asGroups != null) {
            for (String item : asGroups) {
                this.addToAsGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAsGroups() {
        return this.asGroups != null && !this.asGroups.isEmpty();
    }

    @Override
    public A addNewAsGroup(String arg0) {
        return this.addToAsGroups(new String(arg0));
    }

    @Override
    public A addToAsUserExtra(String key, ArrayList<String> value) {
        if (this.asUserExtra == null && key != null && value != null) {
            this.asUserExtra = new LinkedHashMap<String, ArrayList<String>>();
        }
        if (key != null && value != null) {
            this.asUserExtra.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAsUserExtra(Map<String, ArrayList<String>> map) {
        if (this.asUserExtra == null && map != null) {
            this.asUserExtra = new LinkedHashMap<String, ArrayList<String>>();
        }
        if (map != null) {
            this.asUserExtra.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAsUserExtra(String key) {
        if (this.asUserExtra == null) {
            return (A)this;
        }
        if (key != null && this.asUserExtra != null) {
            this.asUserExtra.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAsUserExtra(Map<String, ArrayList<String>> map) {
        if (this.asUserExtra == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.asUserExtra == null) continue;
                this.asUserExtra.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, ArrayList<String>> getAsUserExtra() {
        return this.asUserExtra;
    }

    @Override
    public <K, V> A withAsUserExtra(Map<String, ArrayList<String>> asUserExtra) {
        this.asUserExtra = asUserExtra == null ? null : new LinkedHashMap<String, ArrayList<String>>(asUserExtra);
        return (A)this;
    }

    @Override
    public Boolean hasAsUserExtra() {
        return this.asUserExtra != null;
    }

    @Override
    @Deprecated
    public AuthProviderConfig getAuthProvider() {
        return this.authProvider != null ? this.authProvider.build() : null;
    }

    @Override
    public AuthProviderConfig buildAuthProvider() {
        return this.authProvider != null ? this.authProvider.build() : null;
    }

    @Override
    public A withAuthProvider(AuthProviderConfig authProvider) {
        this._visitables.get("authProvider").remove(this.authProvider);
        if (authProvider != null) {
            this.authProvider = new AuthProviderConfigBuilder(authProvider);
            this._visitables.get("authProvider").add(this.authProvider);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAuthProvider() {
        return this.authProvider != null;
    }

    @Override
    public AuthInfoFluent.AuthProviderNested<A> withNewAuthProvider() {
        return new AuthProviderNestedImpl();
    }

    @Override
    public AuthInfoFluent.AuthProviderNested<A> withNewAuthProviderLike(AuthProviderConfig item) {
        return new AuthProviderNestedImpl(item);
    }

    @Override
    public AuthInfoFluent.AuthProviderNested<A> editAuthProvider() {
        return this.withNewAuthProviderLike(this.getAuthProvider());
    }

    @Override
    public AuthInfoFluent.AuthProviderNested<A> editOrNewAuthProvider() {
        return this.withNewAuthProviderLike(this.getAuthProvider() != null ? this.getAuthProvider() : new AuthProviderConfigBuilder().build());
    }

    @Override
    public AuthInfoFluent.AuthProviderNested<A> editOrNewAuthProviderLike(AuthProviderConfig item) {
        return this.withNewAuthProviderLike(this.getAuthProvider() != null ? this.getAuthProvider() : item);
    }

    @Override
    public String getClientCertificate() {
        return this.clientCertificate;
    }

    @Override
    public A withClientCertificate(String clientCertificate) {
        this.clientCertificate = clientCertificate;
        return (A)this;
    }

    @Override
    public Boolean hasClientCertificate() {
        return this.clientCertificate != null;
    }

    @Override
    @Deprecated
    public A withNewClientCertificate(String arg0) {
        return this.withClientCertificate(new String(arg0));
    }

    @Override
    public String getClientCertificateData() {
        return this.clientCertificateData;
    }

    @Override
    public A withClientCertificateData(String clientCertificateData) {
        this.clientCertificateData = clientCertificateData;
        return (A)this;
    }

    @Override
    public Boolean hasClientCertificateData() {
        return this.clientCertificateData != null;
    }

    @Override
    @Deprecated
    public A withNewClientCertificateData(String arg0) {
        return this.withClientCertificateData(new String(arg0));
    }

    @Override
    public String getClientKey() {
        return this.clientKey;
    }

    @Override
    public A withClientKey(String clientKey) {
        this.clientKey = clientKey;
        return (A)this;
    }

    @Override
    public Boolean hasClientKey() {
        return this.clientKey != null;
    }

    @Override
    @Deprecated
    public A withNewClientKey(String arg0) {
        return this.withClientKey(new String(arg0));
    }

    @Override
    public String getClientKeyData() {
        return this.clientKeyData;
    }

    @Override
    public A withClientKeyData(String clientKeyData) {
        this.clientKeyData = clientKeyData;
        return (A)this;
    }

    @Override
    public Boolean hasClientKeyData() {
        return this.clientKeyData != null;
    }

    @Override
    @Deprecated
    public A withNewClientKeyData(String arg0) {
        return this.withClientKeyData(new String(arg0));
    }

    @Override
    @Deprecated
    public ExecConfig getExec() {
        return this.exec != null ? this.exec.build() : null;
    }

    @Override
    public ExecConfig buildExec() {
        return this.exec != null ? this.exec.build() : null;
    }

    @Override
    public A withExec(ExecConfig exec) {
        this._visitables.get("exec").remove(this.exec);
        if (exec != null) {
            this.exec = new ExecConfigBuilder(exec);
            this._visitables.get("exec").add(this.exec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasExec() {
        return this.exec != null;
    }

    @Override
    public AuthInfoFluent.ExecNested<A> withNewExec() {
        return new ExecNestedImpl();
    }

    @Override
    public AuthInfoFluent.ExecNested<A> withNewExecLike(ExecConfig item) {
        return new ExecNestedImpl(item);
    }

    @Override
    public AuthInfoFluent.ExecNested<A> editExec() {
        return this.withNewExecLike(this.getExec());
    }

    @Override
    public AuthInfoFluent.ExecNested<A> editOrNewExec() {
        return this.withNewExecLike(this.getExec() != null ? this.getExec() : new ExecConfigBuilder().build());
    }

    @Override
    public AuthInfoFluent.ExecNested<A> editOrNewExecLike(ExecConfig item) {
        return this.withNewExecLike(this.getExec() != null ? this.getExec() : item);
    }

    @Override
    public A addToExtensions(Integer index, NamedExtension item) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<NamedExtensionBuilder>();
        }
        NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
        this._visitables.get("extensions").add(index >= 0 ? index.intValue() : this._visitables.get("extensions").size(), builder);
        this.extensions.add(index >= 0 ? index.intValue() : this.extensions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToExtensions(Integer index, NamedExtension item) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<NamedExtensionBuilder>();
        }
        NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
        if (index < 0 || index >= this._visitables.get("extensions").size()) {
            this._visitables.get("extensions").add(builder);
        } else {
            this._visitables.get("extensions").set(index, builder);
        }
        if (index < 0 || index >= this.extensions.size()) {
            this.extensions.add(builder);
        } else {
            this.extensions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToExtensions(NamedExtension ... items) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<NamedExtensionBuilder>();
        }
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.get("extensions").add(builder);
            this.extensions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToExtensions(Collection<NamedExtension> items) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<NamedExtensionBuilder>();
        }
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.get("extensions").add(builder);
            this.extensions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromExtensions(NamedExtension ... items) {
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.get("extensions").remove(builder);
            if (this.extensions == null) continue;
            this.extensions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromExtensions(Collection<NamedExtension> items) {
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.get("extensions").remove(builder);
            if (this.extensions == null) continue;
            this.extensions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromExtensions(Predicate<NamedExtensionBuilder> predicate) {
        if (this.extensions == null) {
            return (A)this;
        }
        Iterator<NamedExtensionBuilder> each = this.extensions.iterator();
        Object visitables = this._visitables.get("extensions");
        while (each.hasNext()) {
            NamedExtensionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<NamedExtension> getExtensions() {
        return AuthInfoFluentImpl.build(this.extensions);
    }

    @Override
    public List<NamedExtension> buildExtensions() {
        return AuthInfoFluentImpl.build(this.extensions);
    }

    @Override
    public NamedExtension buildExtension(Integer index) {
        return this.extensions.get(index).build();
    }

    @Override
    public NamedExtension buildFirstExtension() {
        return this.extensions.get(0).build();
    }

    @Override
    public NamedExtension buildLastExtension() {
        return this.extensions.get(this.extensions.size() - 1).build();
    }

    @Override
    public NamedExtension buildMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
        for (NamedExtensionBuilder item : this.extensions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
        for (NamedExtensionBuilder item : this.extensions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withExtensions(List<NamedExtension> extensions) {
        if (this.extensions != null) {
            this._visitables.get("extensions").removeAll(this.extensions);
        }
        if (extensions != null) {
            this.extensions = new ArrayList<NamedExtensionBuilder>();
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        } else {
            this.extensions = null;
        }
        return (A)this;
    }

    @Override
    public A withExtensions(NamedExtension ... extensions) {
        if (this.extensions != null) {
            this.extensions.clear();
        }
        if (extensions != null) {
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public AuthInfoFluent.ExtensionsNested<A> addNewExtension() {
        return new ExtensionsNestedImpl();
    }

    @Override
    public AuthInfoFluent.ExtensionsNested<A> addNewExtensionLike(NamedExtension item) {
        return new ExtensionsNestedImpl(-1, item);
    }

    @Override
    public AuthInfoFluent.ExtensionsNested<A> setNewExtensionLike(Integer index, NamedExtension item) {
        return new ExtensionsNestedImpl(index, item);
    }

    @Override
    public AuthInfoFluent.ExtensionsNested<A> editExtension(Integer index) {
        if (this.extensions.size() <= index) {
            throw new RuntimeException("Can't edit extensions. Index exceeds size.");
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    @Override
    public AuthInfoFluent.ExtensionsNested<A> editFirstExtension() {
        if (this.extensions.size() == 0) {
            throw new RuntimeException("Can't edit first extensions. The list is empty.");
        }
        return this.setNewExtensionLike(0, this.buildExtension(0));
    }

    @Override
    public AuthInfoFluent.ExtensionsNested<A> editLastExtension() {
        int index = this.extensions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last extensions. The list is empty.");
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    @Override
    public AuthInfoFluent.ExtensionsNested<A> editMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.extensions.size(); ++i) {
            if (!predicate.test(this.extensions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching extensions. No match found.");
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public A withPassword(String password) {
        this.password = password;
        return (A)this;
    }

    @Override
    public Boolean hasPassword() {
        return this.password != null;
    }

    @Override
    @Deprecated
    public A withNewPassword(String arg0) {
        return this.withPassword(new String(arg0));
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public A withToken(String token) {
        this.token = token;
        return (A)this;
    }

    @Override
    public Boolean hasToken() {
        return this.token != null;
    }

    @Override
    @Deprecated
    public A withNewToken(String arg0) {
        return this.withToken(new String(arg0));
    }

    @Override
    public String getTokenFile() {
        return this.tokenFile;
    }

    @Override
    public A withTokenFile(String tokenFile) {
        this.tokenFile = tokenFile;
        return (A)this;
    }

    @Override
    public Boolean hasTokenFile() {
        return this.tokenFile != null;
    }

    @Override
    @Deprecated
    public A withNewTokenFile(String arg0) {
        return this.withTokenFile(new String(arg0));
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public A withUsername(String username) {
        this.username = username;
        return (A)this;
    }

    @Override
    public Boolean hasUsername() {
        return this.username != null;
    }

    @Override
    @Deprecated
    public A withNewUsername(String arg0) {
        return this.withUsername(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthInfoFluentImpl that = (AuthInfoFluentImpl)o;
        if (this.as != null ? !this.as.equals(that.as) : that.as != null) {
            return false;
        }
        if (this.asGroups != null ? !this.asGroups.equals(that.asGroups) : that.asGroups != null) {
            return false;
        }
        if (this.asUserExtra != null ? !this.asUserExtra.equals(that.asUserExtra) : that.asUserExtra != null) {
            return false;
        }
        if (this.authProvider != null ? !this.authProvider.equals(that.authProvider) : that.authProvider != null) {
            return false;
        }
        if (this.clientCertificate != null ? !this.clientCertificate.equals(that.clientCertificate) : that.clientCertificate != null) {
            return false;
        }
        if (this.clientCertificateData != null ? !this.clientCertificateData.equals(that.clientCertificateData) : that.clientCertificateData != null) {
            return false;
        }
        if (this.clientKey != null ? !this.clientKey.equals(that.clientKey) : that.clientKey != null) {
            return false;
        }
        if (this.clientKeyData != null ? !this.clientKeyData.equals(that.clientKeyData) : that.clientKeyData != null) {
            return false;
        }
        if (this.exec != null ? !this.exec.equals(that.exec) : that.exec != null) {
            return false;
        }
        if (this.extensions != null ? !this.extensions.equals(that.extensions) : that.extensions != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        if (this.token != null ? !this.token.equals(that.token) : that.token != null) {
            return false;
        }
        if (this.tokenFile != null ? !this.tokenFile.equals(that.tokenFile) : that.tokenFile != null) {
            return false;
        }
        return !(this.username != null ? !this.username.equals(that.username) : that.username != null);
    }

    public int hashCode() {
        return Objects.hash(this.as, this.asGroups, this.asUserExtra, this.authProvider, this.clientCertificate, this.clientCertificateData, this.clientKey, this.clientKeyData, this.exec, this.extensions, this.password, this.token, this.tokenFile, this.username, super.hashCode());
    }

    public class ExtensionsNestedImpl<N>
    extends NamedExtensionFluentImpl<AuthInfoFluent.ExtensionsNested<N>>
    implements AuthInfoFluent.ExtensionsNested<N>,
    Nested<N> {
        NamedExtensionBuilder builder;
        Integer index;

        ExtensionsNestedImpl(Integer index, NamedExtension item) {
            this.index = index;
            this.builder = new NamedExtensionBuilder(this, item);
        }

        ExtensionsNestedImpl() {
            this.index = -1;
            this.builder = new NamedExtensionBuilder(this);
        }

        @Override
        public N and() {
            return (N)AuthInfoFluentImpl.this.setToExtensions(this.index, this.builder.build());
        }

        @Override
        public N endExtension() {
            return this.and();
        }
    }

    public class ExecNestedImpl<N>
    extends ExecConfigFluentImpl<AuthInfoFluent.ExecNested<N>>
    implements AuthInfoFluent.ExecNested<N>,
    Nested<N> {
        ExecConfigBuilder builder;

        ExecNestedImpl(ExecConfig item) {
            this.builder = new ExecConfigBuilder(this, item);
        }

        ExecNestedImpl() {
            this.builder = new ExecConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)AuthInfoFluentImpl.this.withExec(this.builder.build());
        }

        @Override
        public N endExec() {
            return this.and();
        }
    }

    public class AuthProviderNestedImpl<N>
    extends AuthProviderConfigFluentImpl<AuthInfoFluent.AuthProviderNested<N>>
    implements AuthInfoFluent.AuthProviderNested<N>,
    Nested<N> {
        AuthProviderConfigBuilder builder;

        AuthProviderNestedImpl(AuthProviderConfig item) {
            this.builder = new AuthProviderConfigBuilder(this, item);
        }

        AuthProviderNestedImpl() {
            this.builder = new AuthProviderConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)AuthInfoFluentImpl.this.withAuthProvider(this.builder.build());
        }

        @Override
        public N endAuthProvider() {
            return this.and();
        }
    }
}

