/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.machine.v1beta1.Condition;
import io.fabric8.openshift.api.model.machine.v1beta1.ConditionBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.ConditionFluentImpl;
import io.fabric8.openshift.api.model.machine.v1beta1.MachineHealthCheckStatus;
import io.fabric8.openshift.api.model.machine.v1beta1.MachineHealthCheckStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class MachineHealthCheckStatusFluentImpl<A extends MachineHealthCheckStatusFluent<A>>
extends BaseFluent<A>
implements MachineHealthCheckStatusFluent<A> {
    private List<ConditionBuilder> conditions = new ArrayList<ConditionBuilder>();
    private Integer currentHealthy;
    private Integer expectedMachines;
    private Integer remediationsAllowed;

    public MachineHealthCheckStatusFluentImpl() {
    }

    public MachineHealthCheckStatusFluentImpl(MachineHealthCheckStatus instance) {
        this.withConditions(instance.getConditions());
        this.withCurrentHealthy(instance.getCurrentHealthy());
        this.withExpectedMachines(instance.getExpectedMachines());
        this.withRemediationsAllowed(instance.getRemediationsAllowed());
    }

    @Override
    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ConditionBuilder>();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        this._visitables.get("conditions").add(index >= 0 ? index : this._visitables.get("conditions").size(), builder);
        this.conditions.add(index >= 0 ? index : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ConditionBuilder>();
        }
        ConditionBuilder builder = new ConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get("conditions").size()) {
            this._visitables.get("conditions").add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ConditionBuilder>();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ConditionBuilder>();
        }
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(Condition ... items) {
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<Condition> items) {
        for (Condition item : items) {
            ConditionBuilder builder = new ConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<ConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            ConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Condition> getConditions() {
        return MachineHealthCheckStatusFluentImpl.build(this.conditions);
    }

    @Override
    public List<Condition> buildConditions() {
        return MachineHealthCheckStatusFluentImpl.build(this.conditions);
    }

    @Override
    public Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public Condition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
        for (ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<Condition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList<ConditionBuilder>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public MachineHealthCheckStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public MachineHealthCheckStatusFluent.ConditionsNested<A> addNewConditionLike(Condition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public MachineHealthCheckStatusFluent.ConditionsNested<A> setNewConditionLike(int index, Condition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public MachineHealthCheckStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public MachineHealthCheckStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public MachineHealthCheckStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public MachineHealthCheckStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public Integer getCurrentHealthy() {
        return this.currentHealthy;
    }

    @Override
    public A withCurrentHealthy(Integer currentHealthy) {
        this.currentHealthy = currentHealthy;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentHealthy() {
        return this.currentHealthy != null;
    }

    @Override
    public Integer getExpectedMachines() {
        return this.expectedMachines;
    }

    @Override
    public A withExpectedMachines(Integer expectedMachines) {
        this.expectedMachines = expectedMachines;
        return (A)this;
    }

    @Override
    public Boolean hasExpectedMachines() {
        return this.expectedMachines != null;
    }

    @Override
    public Integer getRemediationsAllowed() {
        return this.remediationsAllowed;
    }

    @Override
    public A withRemediationsAllowed(Integer remediationsAllowed) {
        this.remediationsAllowed = remediationsAllowed;
        return (A)this;
    }

    @Override
    public Boolean hasRemediationsAllowed() {
        return this.remediationsAllowed != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MachineHealthCheckStatusFluentImpl that = (MachineHealthCheckStatusFluentImpl)o;
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.currentHealthy != null ? !this.currentHealthy.equals(that.currentHealthy) : that.currentHealthy != null) {
            return false;
        }
        if (this.expectedMachines != null ? !this.expectedMachines.equals(that.expectedMachines) : that.expectedMachines != null) {
            return false;
        }
        return !(this.remediationsAllowed != null ? !this.remediationsAllowed.equals(that.remediationsAllowed) : that.remediationsAllowed != null);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.currentHealthy, this.expectedMachines, this.remediationsAllowed, super.hashCode());
    }

    public class ConditionsNestedImpl<N>
    extends ConditionFluentImpl<MachineHealthCheckStatusFluent.ConditionsNested<N>>
    implements MachineHealthCheckStatusFluent.ConditionsNested<N>,
    Nested<N> {
        private final ConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index, Condition item) {
            this.index = index;
            this.builder = new ConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new ConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)MachineHealthCheckStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

