/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.authorization.v1.ResourceAttributes;
import io.fabric8.openshift.api.model.console.v1.ConsoleQuickStartSpec;
import io.fabric8.openshift.api.model.console.v1.ConsoleQuickStartSpecFluent;
import io.fabric8.openshift.api.model.console.v1.ConsoleQuickStartTask;
import io.fabric8.openshift.api.model.console.v1.ConsoleQuickStartTaskBuilder;
import io.fabric8.openshift.api.model.console.v1.ConsoleQuickStartTaskFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ConsoleQuickStartSpecFluentImpl<A extends ConsoleQuickStartSpecFluent<A>>
extends BaseFluent<A>
implements ConsoleQuickStartSpecFluent<A> {
    private List<ResourceAttributes> accessReviewResources = new ArrayList<ResourceAttributes>();
    private String conclusion;
    private String description;
    private String displayName;
    private Integer durationMinutes;
    private String icon;
    private String introduction;
    private List<String> nextQuickStart = new ArrayList<String>();
    private List<String> prerequisites = new ArrayList<String>();
    private List<String> tags = new ArrayList<String>();
    private List<ConsoleQuickStartTaskBuilder> tasks = new ArrayList<ConsoleQuickStartTaskBuilder>();

    public ConsoleQuickStartSpecFluentImpl() {
    }

    public ConsoleQuickStartSpecFluentImpl(ConsoleQuickStartSpec instance) {
        this.withAccessReviewResources(instance.getAccessReviewResources());
        this.withConclusion(instance.getConclusion());
        this.withDescription(instance.getDescription());
        this.withDisplayName(instance.getDisplayName());
        this.withDurationMinutes(instance.getDurationMinutes());
        this.withIcon(instance.getIcon());
        this.withIntroduction(instance.getIntroduction());
        this.withNextQuickStart(instance.getNextQuickStart());
        this.withPrerequisites(instance.getPrerequisites());
        this.withTags(instance.getTags());
        this.withTasks(instance.getTasks());
    }

    @Override
    public A addToAccessReviewResources(int index, ResourceAttributes item) {
        if (this.accessReviewResources == null) {
            this.accessReviewResources = new ArrayList<ResourceAttributes>();
        }
        this.accessReviewResources.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAccessReviewResources(int index, ResourceAttributes item) {
        if (this.accessReviewResources == null) {
            this.accessReviewResources = new ArrayList<ResourceAttributes>();
        }
        this.accessReviewResources.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAccessReviewResources(ResourceAttributes ... items) {
        if (this.accessReviewResources == null) {
            this.accessReviewResources = new ArrayList<ResourceAttributes>();
        }
        for (ResourceAttributes item : items) {
            this.accessReviewResources.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAccessReviewResources(Collection<ResourceAttributes> items) {
        if (this.accessReviewResources == null) {
            this.accessReviewResources = new ArrayList<ResourceAttributes>();
        }
        for (ResourceAttributes item : items) {
            this.accessReviewResources.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAccessReviewResources(ResourceAttributes ... items) {
        for (ResourceAttributes item : items) {
            if (this.accessReviewResources == null) continue;
            this.accessReviewResources.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAccessReviewResources(Collection<ResourceAttributes> items) {
        for (ResourceAttributes item : items) {
            if (this.accessReviewResources == null) continue;
            this.accessReviewResources.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<ResourceAttributes> getAccessReviewResources() {
        return this.accessReviewResources;
    }

    @Override
    public ResourceAttributes getAccessReviewResource(int index) {
        return this.accessReviewResources.get(index);
    }

    @Override
    public ResourceAttributes getFirstAccessReviewResource() {
        return this.accessReviewResources.get(0);
    }

    @Override
    public ResourceAttributes getLastAccessReviewResource() {
        return this.accessReviewResources.get(this.accessReviewResources.size() - 1);
    }

    @Override
    public ResourceAttributes getMatchingAccessReviewResource(Predicate<ResourceAttributes> predicate) {
        for (ResourceAttributes item : this.accessReviewResources) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAccessReviewResource(Predicate<ResourceAttributes> predicate) {
        for (ResourceAttributes item : this.accessReviewResources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAccessReviewResources(List<ResourceAttributes> accessReviewResources) {
        if (this.accessReviewResources != null) {
            this._visitables.get("accessReviewResources").removeAll(this.accessReviewResources);
        }
        if (accessReviewResources != null) {
            this.accessReviewResources = new ArrayList<ResourceAttributes>();
            for (ResourceAttributes item : accessReviewResources) {
                this.addToAccessReviewResources(item);
            }
        } else {
            this.accessReviewResources = null;
        }
        return (A)this;
    }

    @Override
    public A withAccessReviewResources(ResourceAttributes ... accessReviewResources) {
        if (this.accessReviewResources != null) {
            this.accessReviewResources.clear();
        }
        if (accessReviewResources != null) {
            for (ResourceAttributes item : accessReviewResources) {
                this.addToAccessReviewResources(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAccessReviewResources() {
        return this.accessReviewResources != null && !this.accessReviewResources.isEmpty();
    }

    @Override
    public String getConclusion() {
        return this.conclusion;
    }

    @Override
    public A withConclusion(String conclusion) {
        this.conclusion = conclusion;
        return (A)this;
    }

    @Override
    public Boolean hasConclusion() {
        return this.conclusion != null;
    }

    @Override
    @Deprecated
    public A withNewConclusion(String arg0) {
        return this.withConclusion(new String(arg0));
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public A withDescription(String description) {
        this.description = description;
        return (A)this;
    }

    @Override
    public Boolean hasDescription() {
        return this.description != null;
    }

    @Override
    @Deprecated
    public A withNewDescription(String arg0) {
        return this.withDescription(new String(arg0));
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public A withDisplayName(String displayName) {
        this.displayName = displayName;
        return (A)this;
    }

    @Override
    public Boolean hasDisplayName() {
        return this.displayName != null;
    }

    @Override
    @Deprecated
    public A withNewDisplayName(String arg0) {
        return this.withDisplayName(new String(arg0));
    }

    @Override
    public Integer getDurationMinutes() {
        return this.durationMinutes;
    }

    @Override
    public A withDurationMinutes(Integer durationMinutes) {
        this.durationMinutes = durationMinutes;
        return (A)this;
    }

    @Override
    public Boolean hasDurationMinutes() {
        return this.durationMinutes != null;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public A withIcon(String icon) {
        this.icon = icon;
        return (A)this;
    }

    @Override
    public Boolean hasIcon() {
        return this.icon != null;
    }

    @Override
    @Deprecated
    public A withNewIcon(String arg0) {
        return this.withIcon(new String(arg0));
    }

    @Override
    public String getIntroduction() {
        return this.introduction;
    }

    @Override
    public A withIntroduction(String introduction) {
        this.introduction = introduction;
        return (A)this;
    }

    @Override
    public Boolean hasIntroduction() {
        return this.introduction != null;
    }

    @Override
    @Deprecated
    public A withNewIntroduction(String arg0) {
        return this.withIntroduction(new String(arg0));
    }

    @Override
    public A addToNextQuickStart(int index, String item) {
        if (this.nextQuickStart == null) {
            this.nextQuickStart = new ArrayList<String>();
        }
        this.nextQuickStart.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNextQuickStart(int index, String item) {
        if (this.nextQuickStart == null) {
            this.nextQuickStart = new ArrayList<String>();
        }
        this.nextQuickStart.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNextQuickStart(String ... items) {
        if (this.nextQuickStart == null) {
            this.nextQuickStart = new ArrayList<String>();
        }
        for (String item : items) {
            this.nextQuickStart.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNextQuickStart(Collection<String> items) {
        if (this.nextQuickStart == null) {
            this.nextQuickStart = new ArrayList<String>();
        }
        for (String item : items) {
            this.nextQuickStart.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNextQuickStart(String ... items) {
        for (String item : items) {
            if (this.nextQuickStart == null) continue;
            this.nextQuickStart.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNextQuickStart(Collection<String> items) {
        for (String item : items) {
            if (this.nextQuickStart == null) continue;
            this.nextQuickStart.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNextQuickStart() {
        return this.nextQuickStart;
    }

    @Override
    public String getNextQuickStart(int index) {
        return this.nextQuickStart.get(index);
    }

    @Override
    public String getFirstNextQuickStart() {
        return this.nextQuickStart.get(0);
    }

    @Override
    public String getLastNextQuickStart() {
        return this.nextQuickStart.get(this.nextQuickStart.size() - 1);
    }

    @Override
    public String getMatchingNextQuickStart(Predicate<String> predicate) {
        for (String item : this.nextQuickStart) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNextQuickStart(Predicate<String> predicate) {
        for (String item : this.nextQuickStart) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNextQuickStart(List<String> nextQuickStart) {
        if (this.nextQuickStart != null) {
            this._visitables.get("nextQuickStart").removeAll(this.nextQuickStart);
        }
        if (nextQuickStart != null) {
            this.nextQuickStart = new ArrayList<String>();
            for (String item : nextQuickStart) {
                this.addToNextQuickStart(item);
            }
        } else {
            this.nextQuickStart = null;
        }
        return (A)this;
    }

    @Override
    public A withNextQuickStart(String ... nextQuickStart) {
        if (this.nextQuickStart != null) {
            this.nextQuickStart.clear();
        }
        if (nextQuickStart != null) {
            for (String item : nextQuickStart) {
                this.addToNextQuickStart(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNextQuickStart() {
        return this.nextQuickStart != null && !this.nextQuickStart.isEmpty();
    }

    @Override
    public A addNewNextQuickStart(String arg0) {
        return this.addToNextQuickStart(new String(arg0));
    }

    @Override
    public A addToPrerequisites(int index, String item) {
        if (this.prerequisites == null) {
            this.prerequisites = new ArrayList<String>();
        }
        this.prerequisites.add(index, item);
        return (A)this;
    }

    @Override
    public A setToPrerequisites(int index, String item) {
        if (this.prerequisites == null) {
            this.prerequisites = new ArrayList<String>();
        }
        this.prerequisites.set(index, item);
        return (A)this;
    }

    @Override
    public A addToPrerequisites(String ... items) {
        if (this.prerequisites == null) {
            this.prerequisites = new ArrayList<String>();
        }
        for (String item : items) {
            this.prerequisites.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToPrerequisites(Collection<String> items) {
        if (this.prerequisites == null) {
            this.prerequisites = new ArrayList<String>();
        }
        for (String item : items) {
            this.prerequisites.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromPrerequisites(String ... items) {
        for (String item : items) {
            if (this.prerequisites == null) continue;
            this.prerequisites.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPrerequisites(Collection<String> items) {
        for (String item : items) {
            if (this.prerequisites == null) continue;
            this.prerequisites.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getPrerequisites() {
        return this.prerequisites;
    }

    @Override
    public String getPrerequisite(int index) {
        return this.prerequisites.get(index);
    }

    @Override
    public String getFirstPrerequisite() {
        return this.prerequisites.get(0);
    }

    @Override
    public String getLastPrerequisite() {
        return this.prerequisites.get(this.prerequisites.size() - 1);
    }

    @Override
    public String getMatchingPrerequisite(Predicate<String> predicate) {
        for (String item : this.prerequisites) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPrerequisite(Predicate<String> predicate) {
        for (String item : this.prerequisites) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPrerequisites(List<String> prerequisites) {
        if (this.prerequisites != null) {
            this._visitables.get("prerequisites").removeAll(this.prerequisites);
        }
        if (prerequisites != null) {
            this.prerequisites = new ArrayList<String>();
            for (String item : prerequisites) {
                this.addToPrerequisites(item);
            }
        } else {
            this.prerequisites = null;
        }
        return (A)this;
    }

    @Override
    public A withPrerequisites(String ... prerequisites) {
        if (this.prerequisites != null) {
            this.prerequisites.clear();
        }
        if (prerequisites != null) {
            for (String item : prerequisites) {
                this.addToPrerequisites(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPrerequisites() {
        return this.prerequisites != null && !this.prerequisites.isEmpty();
    }

    @Override
    public A addNewPrerequisite(String arg0) {
        return this.addToPrerequisites(new String(arg0));
    }

    @Override
    public A addToTags(int index, String item) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTags(int index, String item) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTags(String ... items) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        for (String item : items) {
            this.tags.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTags(Collection<String> items) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        for (String item : items) {
            this.tags.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTags(String ... items) {
        for (String item : items) {
            if (this.tags == null) continue;
            this.tags.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTags(Collection<String> items) {
        for (String item : items) {
            if (this.tags == null) continue;
            this.tags.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    public String getTag(int index) {
        return this.tags.get(index);
    }

    @Override
    public String getFirstTag() {
        return this.tags.get(0);
    }

    @Override
    public String getLastTag() {
        return this.tags.get(this.tags.size() - 1);
    }

    @Override
    public String getMatchingTag(Predicate<String> predicate) {
        for (String item : this.tags) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTag(Predicate<String> predicate) {
        for (String item : this.tags) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTags(List<String> tags) {
        if (this.tags != null) {
            this._visitables.get("tags").removeAll(this.tags);
        }
        if (tags != null) {
            this.tags = new ArrayList<String>();
            for (String item : tags) {
                this.addToTags(item);
            }
        } else {
            this.tags = null;
        }
        return (A)this;
    }

    @Override
    public A withTags(String ... tags) {
        if (this.tags != null) {
            this.tags.clear();
        }
        if (tags != null) {
            for (String item : tags) {
                this.addToTags(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTags() {
        return this.tags != null && !this.tags.isEmpty();
    }

    @Override
    public A addNewTag(String arg0) {
        return this.addToTags(new String(arg0));
    }

    @Override
    public A addToTasks(int index, ConsoleQuickStartTask item) {
        if (this.tasks == null) {
            this.tasks = new ArrayList<ConsoleQuickStartTaskBuilder>();
        }
        ConsoleQuickStartTaskBuilder builder = new ConsoleQuickStartTaskBuilder(item);
        this._visitables.get("tasks").add(index >= 0 ? index : this._visitables.get("tasks").size(), builder);
        this.tasks.add(index >= 0 ? index : this.tasks.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTasks(int index, ConsoleQuickStartTask item) {
        if (this.tasks == null) {
            this.tasks = new ArrayList<ConsoleQuickStartTaskBuilder>();
        }
        ConsoleQuickStartTaskBuilder builder = new ConsoleQuickStartTaskBuilder(item);
        if (index < 0 || index >= this._visitables.get("tasks").size()) {
            this._visitables.get("tasks").add(builder);
        } else {
            this._visitables.get("tasks").set(index, builder);
        }
        if (index < 0 || index >= this.tasks.size()) {
            this.tasks.add(builder);
        } else {
            this.tasks.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTasks(ConsoleQuickStartTask ... items) {
        if (this.tasks == null) {
            this.tasks = new ArrayList<ConsoleQuickStartTaskBuilder>();
        }
        for (ConsoleQuickStartTask item : items) {
            ConsoleQuickStartTaskBuilder builder = new ConsoleQuickStartTaskBuilder(item);
            this._visitables.get("tasks").add(builder);
            this.tasks.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTasks(Collection<ConsoleQuickStartTask> items) {
        if (this.tasks == null) {
            this.tasks = new ArrayList<ConsoleQuickStartTaskBuilder>();
        }
        for (ConsoleQuickStartTask item : items) {
            ConsoleQuickStartTaskBuilder builder = new ConsoleQuickStartTaskBuilder(item);
            this._visitables.get("tasks").add(builder);
            this.tasks.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTasks(ConsoleQuickStartTask ... items) {
        for (ConsoleQuickStartTask item : items) {
            ConsoleQuickStartTaskBuilder builder = new ConsoleQuickStartTaskBuilder(item);
            this._visitables.get("tasks").remove(builder);
            if (this.tasks == null) continue;
            this.tasks.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTasks(Collection<ConsoleQuickStartTask> items) {
        for (ConsoleQuickStartTask item : items) {
            ConsoleQuickStartTaskBuilder builder = new ConsoleQuickStartTaskBuilder(item);
            this._visitables.get("tasks").remove(builder);
            if (this.tasks == null) continue;
            this.tasks.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromTasks(Predicate<ConsoleQuickStartTaskBuilder> predicate) {
        if (this.tasks == null) {
            return (A)this;
        }
        Iterator<ConsoleQuickStartTaskBuilder> each = this.tasks.iterator();
        Object visitables = this._visitables.get("tasks");
        while (each.hasNext()) {
            ConsoleQuickStartTaskBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ConsoleQuickStartTask> getTasks() {
        return ConsoleQuickStartSpecFluentImpl.build(this.tasks);
    }

    @Override
    public List<ConsoleQuickStartTask> buildTasks() {
        return ConsoleQuickStartSpecFluentImpl.build(this.tasks);
    }

    @Override
    public ConsoleQuickStartTask buildTask(int index) {
        return this.tasks.get(index).build();
    }

    @Override
    public ConsoleQuickStartTask buildFirstTask() {
        return this.tasks.get(0).build();
    }

    @Override
    public ConsoleQuickStartTask buildLastTask() {
        return this.tasks.get(this.tasks.size() - 1).build();
    }

    @Override
    public ConsoleQuickStartTask buildMatchingTask(Predicate<ConsoleQuickStartTaskBuilder> predicate) {
        for (ConsoleQuickStartTaskBuilder item : this.tasks) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTask(Predicate<ConsoleQuickStartTaskBuilder> predicate) {
        for (ConsoleQuickStartTaskBuilder item : this.tasks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTasks(List<ConsoleQuickStartTask> tasks) {
        if (this.tasks != null) {
            this._visitables.get("tasks").removeAll(this.tasks);
        }
        if (tasks != null) {
            this.tasks = new ArrayList<ConsoleQuickStartTaskBuilder>();
            for (ConsoleQuickStartTask item : tasks) {
                this.addToTasks(item);
            }
        } else {
            this.tasks = null;
        }
        return (A)this;
    }

    @Override
    public A withTasks(ConsoleQuickStartTask ... tasks) {
        if (this.tasks != null) {
            this.tasks.clear();
        }
        if (tasks != null) {
            for (ConsoleQuickStartTask item : tasks) {
                this.addToTasks(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTasks() {
        return this.tasks != null && !this.tasks.isEmpty();
    }

    @Override
    public ConsoleQuickStartSpecFluent.TasksNested<A> addNewTask() {
        return new TasksNestedImpl();
    }

    @Override
    public ConsoleQuickStartSpecFluent.TasksNested<A> addNewTaskLike(ConsoleQuickStartTask item) {
        return new TasksNestedImpl(-1, item);
    }

    @Override
    public ConsoleQuickStartSpecFluent.TasksNested<A> setNewTaskLike(int index, ConsoleQuickStartTask item) {
        return new TasksNestedImpl(index, item);
    }

    @Override
    public ConsoleQuickStartSpecFluent.TasksNested<A> editTask(int index) {
        if (this.tasks.size() <= index) {
            throw new RuntimeException("Can't edit tasks. Index exceeds size.");
        }
        return this.setNewTaskLike(index, this.buildTask(index));
    }

    @Override
    public ConsoleQuickStartSpecFluent.TasksNested<A> editFirstTask() {
        if (this.tasks.size() == 0) {
            throw new RuntimeException("Can't edit first tasks. The list is empty.");
        }
        return this.setNewTaskLike(0, this.buildTask(0));
    }

    @Override
    public ConsoleQuickStartSpecFluent.TasksNested<A> editLastTask() {
        int index = this.tasks.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tasks. The list is empty.");
        }
        return this.setNewTaskLike(index, this.buildTask(index));
    }

    @Override
    public ConsoleQuickStartSpecFluent.TasksNested<A> editMatchingTask(Predicate<ConsoleQuickStartTaskBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tasks.size(); ++i) {
            if (!predicate.test(this.tasks.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tasks. No match found.");
        }
        return this.setNewTaskLike(index, this.buildTask(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsoleQuickStartSpecFluentImpl that = (ConsoleQuickStartSpecFluentImpl)o;
        if (this.accessReviewResources != null ? !this.accessReviewResources.equals(that.accessReviewResources) : that.accessReviewResources != null) {
            return false;
        }
        if (this.conclusion != null ? !this.conclusion.equals(that.conclusion) : that.conclusion != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.displayName != null ? !this.displayName.equals(that.displayName) : that.displayName != null) {
            return false;
        }
        if (this.durationMinutes != null ? !this.durationMinutes.equals(that.durationMinutes) : that.durationMinutes != null) {
            return false;
        }
        if (this.icon != null ? !this.icon.equals(that.icon) : that.icon != null) {
            return false;
        }
        if (this.introduction != null ? !this.introduction.equals(that.introduction) : that.introduction != null) {
            return false;
        }
        if (this.nextQuickStart != null ? !this.nextQuickStart.equals(that.nextQuickStart) : that.nextQuickStart != null) {
            return false;
        }
        if (this.prerequisites != null ? !this.prerequisites.equals(that.prerequisites) : that.prerequisites != null) {
            return false;
        }
        if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) {
            return false;
        }
        return !(this.tasks != null ? !this.tasks.equals(that.tasks) : that.tasks != null);
    }

    public int hashCode() {
        return Objects.hash(this.accessReviewResources, this.conclusion, this.description, this.displayName, this.durationMinutes, this.icon, this.introduction, this.nextQuickStart, this.prerequisites, this.tags, this.tasks, super.hashCode());
    }

    public class TasksNestedImpl<N>
    extends ConsoleQuickStartTaskFluentImpl<ConsoleQuickStartSpecFluent.TasksNested<N>>
    implements ConsoleQuickStartSpecFluent.TasksNested<N>,
    Nested<N> {
        private final ConsoleQuickStartTaskBuilder builder;
        private final int index;

        TasksNestedImpl(int index, ConsoleQuickStartTask item) {
            this.index = index;
            this.builder = new ConsoleQuickStartTaskBuilder(this, item);
        }

        TasksNestedImpl() {
            this.index = -1;
            this.builder = new ConsoleQuickStartTaskBuilder(this);
        }

        @Override
        public N and() {
            return (N)ConsoleQuickStartSpecFluentImpl.this.setToTasks(this.index, this.builder.build());
        }

        @Override
        public N endTask() {
            return this.and();
        }
    }
}

