/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_7.operator.v1;

import io.fabric8.kubernetes.api.builder.v5_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_7.Nested;
import io.fabric8.openshift.api.model.v5_7.operator.v1.IngressControllerHTTPHeaders;
import io.fabric8.openshift.api.model.v5_7.operator.v1.IngressControllerHTTPHeadersFluent;
import io.fabric8.openshift.api.model.v5_7.operator.v1.IngressControllerHTTPUniqueIdHeaderPolicy;
import io.fabric8.openshift.api.model.v5_7.operator.v1.IngressControllerHTTPUniqueIdHeaderPolicyBuilder;
import io.fabric8.openshift.api.model.v5_7.operator.v1.IngressControllerHTTPUniqueIdHeaderPolicyFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class IngressControllerHTTPHeadersFluentImpl<A extends IngressControllerHTTPHeadersFluent<A>>
extends BaseFluent<A>
implements IngressControllerHTTPHeadersFluent<A> {
    private String forwardedHeaderPolicy;
    private List<String> headerNameCaseAdjustments = new ArrayList<String>();
    private IngressControllerHTTPUniqueIdHeaderPolicyBuilder uniqueId;

    public IngressControllerHTTPHeadersFluentImpl() {
    }

    public IngressControllerHTTPHeadersFluentImpl(IngressControllerHTTPHeaders instance) {
        this.withForwardedHeaderPolicy(instance.getForwardedHeaderPolicy());
        this.withHeaderNameCaseAdjustments(instance.getHeaderNameCaseAdjustments());
        this.withUniqueId(instance.getUniqueId());
    }

    @Override
    public String getForwardedHeaderPolicy() {
        return this.forwardedHeaderPolicy;
    }

    @Override
    public A withForwardedHeaderPolicy(String forwardedHeaderPolicy) {
        this.forwardedHeaderPolicy = forwardedHeaderPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasForwardedHeaderPolicy() {
        return this.forwardedHeaderPolicy != null;
    }

    @Override
    @Deprecated
    public A withNewForwardedHeaderPolicy(String arg0) {
        return this.withForwardedHeaderPolicy(new String(arg0));
    }

    @Override
    public A addToHeaderNameCaseAdjustments(int index, String item) {
        if (this.headerNameCaseAdjustments == null) {
            this.headerNameCaseAdjustments = new ArrayList<String>();
        }
        this.headerNameCaseAdjustments.add(index, item);
        return (A)this;
    }

    @Override
    public A setToHeaderNameCaseAdjustments(int index, String item) {
        if (this.headerNameCaseAdjustments == null) {
            this.headerNameCaseAdjustments = new ArrayList<String>();
        }
        this.headerNameCaseAdjustments.set(index, item);
        return (A)this;
    }

    @Override
    public A addToHeaderNameCaseAdjustments(String ... items) {
        if (this.headerNameCaseAdjustments == null) {
            this.headerNameCaseAdjustments = new ArrayList<String>();
        }
        for (String item : items) {
            this.headerNameCaseAdjustments.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToHeaderNameCaseAdjustments(Collection<String> items) {
        if (this.headerNameCaseAdjustments == null) {
            this.headerNameCaseAdjustments = new ArrayList<String>();
        }
        for (String item : items) {
            this.headerNameCaseAdjustments.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromHeaderNameCaseAdjustments(String ... items) {
        for (String item : items) {
            if (this.headerNameCaseAdjustments == null) continue;
            this.headerNameCaseAdjustments.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHeaderNameCaseAdjustments(Collection<String> items) {
        for (String item : items) {
            if (this.headerNameCaseAdjustments == null) continue;
            this.headerNameCaseAdjustments.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getHeaderNameCaseAdjustments() {
        return this.headerNameCaseAdjustments;
    }

    @Override
    public String getHeaderNameCaseAdjustment(int index) {
        return this.headerNameCaseAdjustments.get(index);
    }

    @Override
    public String getFirstHeaderNameCaseAdjustment() {
        return this.headerNameCaseAdjustments.get(0);
    }

    @Override
    public String getLastHeaderNameCaseAdjustment() {
        return this.headerNameCaseAdjustments.get(this.headerNameCaseAdjustments.size() - 1);
    }

    @Override
    public String getMatchingHeaderNameCaseAdjustment(Predicate<String> predicate) {
        for (String item : this.headerNameCaseAdjustments) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingHeaderNameCaseAdjustment(Predicate<String> predicate) {
        for (String item : this.headerNameCaseAdjustments) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withHeaderNameCaseAdjustments(List<String> headerNameCaseAdjustments) {
        if (this.headerNameCaseAdjustments != null) {
            this._visitables.get("headerNameCaseAdjustments").removeAll(this.headerNameCaseAdjustments);
        }
        if (headerNameCaseAdjustments != null) {
            this.headerNameCaseAdjustments = new ArrayList<String>();
            for (String item : headerNameCaseAdjustments) {
                this.addToHeaderNameCaseAdjustments(item);
            }
        } else {
            this.headerNameCaseAdjustments = null;
        }
        return (A)this;
    }

    @Override
    public A withHeaderNameCaseAdjustments(String ... headerNameCaseAdjustments) {
        if (this.headerNameCaseAdjustments != null) {
            this.headerNameCaseAdjustments.clear();
        }
        if (headerNameCaseAdjustments != null) {
            for (String item : headerNameCaseAdjustments) {
                this.addToHeaderNameCaseAdjustments(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHeaderNameCaseAdjustments() {
        return this.headerNameCaseAdjustments != null && !this.headerNameCaseAdjustments.isEmpty();
    }

    @Override
    public A addNewHeaderNameCaseAdjustment(String arg0) {
        return this.addToHeaderNameCaseAdjustments(new String(arg0));
    }

    @Override
    @Deprecated
    public IngressControllerHTTPUniqueIdHeaderPolicy getUniqueId() {
        return this.uniqueId != null ? this.uniqueId.build() : null;
    }

    @Override
    public IngressControllerHTTPUniqueIdHeaderPolicy buildUniqueId() {
        return this.uniqueId != null ? this.uniqueId.build() : null;
    }

    @Override
    public A withUniqueId(IngressControllerHTTPUniqueIdHeaderPolicy uniqueId) {
        this._visitables.get("uniqueId").remove(this.uniqueId);
        if (uniqueId != null) {
            this.uniqueId = new IngressControllerHTTPUniqueIdHeaderPolicyBuilder(uniqueId);
            this._visitables.get("uniqueId").add(this.uniqueId);
        }
        return (A)this;
    }

    @Override
    public Boolean hasUniqueId() {
        return this.uniqueId != null;
    }

    @Override
    public A withNewUniqueId(String format, String name) {
        return this.withUniqueId(new IngressControllerHTTPUniqueIdHeaderPolicy(format, name));
    }

    @Override
    public IngressControllerHTTPHeadersFluent.UniqueIdNested<A> withNewUniqueId() {
        return new UniqueIdNestedImpl();
    }

    @Override
    public IngressControllerHTTPHeadersFluent.UniqueIdNested<A> withNewUniqueIdLike(IngressControllerHTTPUniqueIdHeaderPolicy item) {
        return new UniqueIdNestedImpl(item);
    }

    @Override
    public IngressControllerHTTPHeadersFluent.UniqueIdNested<A> editUniqueId() {
        return this.withNewUniqueIdLike(this.getUniqueId());
    }

    @Override
    public IngressControllerHTTPHeadersFluent.UniqueIdNested<A> editOrNewUniqueId() {
        return this.withNewUniqueIdLike(this.getUniqueId() != null ? this.getUniqueId() : new IngressControllerHTTPUniqueIdHeaderPolicyBuilder().build());
    }

    @Override
    public IngressControllerHTTPHeadersFluent.UniqueIdNested<A> editOrNewUniqueIdLike(IngressControllerHTTPUniqueIdHeaderPolicy item) {
        return this.withNewUniqueIdLike(this.getUniqueId() != null ? this.getUniqueId() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngressControllerHTTPHeadersFluentImpl that = (IngressControllerHTTPHeadersFluentImpl)o;
        if (this.forwardedHeaderPolicy != null ? !this.forwardedHeaderPolicy.equals(that.forwardedHeaderPolicy) : that.forwardedHeaderPolicy != null) {
            return false;
        }
        if (this.headerNameCaseAdjustments != null ? !this.headerNameCaseAdjustments.equals(that.headerNameCaseAdjustments) : that.headerNameCaseAdjustments != null) {
            return false;
        }
        return !(this.uniqueId != null ? !this.uniqueId.equals(that.uniqueId) : that.uniqueId != null);
    }

    public int hashCode() {
        return Objects.hash(this.forwardedHeaderPolicy, this.headerNameCaseAdjustments, this.uniqueId, super.hashCode());
    }

    public class UniqueIdNestedImpl<N>
    extends IngressControllerHTTPUniqueIdHeaderPolicyFluentImpl<IngressControllerHTTPHeadersFluent.UniqueIdNested<N>>
    implements IngressControllerHTTPHeadersFluent.UniqueIdNested<N>,
    Nested<N> {
        private final IngressControllerHTTPUniqueIdHeaderPolicyBuilder builder;

        UniqueIdNestedImpl(IngressControllerHTTPUniqueIdHeaderPolicy item) {
            this.builder = new IngressControllerHTTPUniqueIdHeaderPolicyBuilder(this, item);
        }

        UniqueIdNestedImpl() {
            this.builder = new IngressControllerHTTPUniqueIdHeaderPolicyBuilder(this);
        }

        @Override
        public N and() {
            return (N)IngressControllerHTTPHeadersFluentImpl.this.withUniqueId(this.builder.build());
        }

        @Override
        public N endUniqueId() {
            return this.and();
        }
    }
}

