/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_7.operator.v1;

import io.fabric8.kubernetes.api.builder.v5_7.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_7.operator.v1.CloudCredentialSpec;
import io.fabric8.openshift.api.model.v5_7.operator.v1.CloudCredentialSpecFluent;
import io.fabric8.openshift.api.model.v5_7.operator.v1.CloudCredentialSpecFluentImpl;
import java.util.Objects;

public class CloudCredentialSpecBuilder
extends CloudCredentialSpecFluentImpl<CloudCredentialSpecBuilder>
implements VisitableBuilder<CloudCredentialSpec, CloudCredentialSpecBuilder> {
    CloudCredentialSpecFluent<?> fluent;
    Boolean validationEnabled;

    public CloudCredentialSpecBuilder() {
        this(true);
    }

    public CloudCredentialSpecBuilder(Boolean validationEnabled) {
        this(new CloudCredentialSpec(), validationEnabled);
    }

    public CloudCredentialSpecBuilder(CloudCredentialSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public CloudCredentialSpecBuilder(CloudCredentialSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new CloudCredentialSpec(), validationEnabled);
    }

    public CloudCredentialSpecBuilder(CloudCredentialSpecFluent<?> fluent, CloudCredentialSpec instance) {
        this(fluent, instance, true);
    }

    public CloudCredentialSpecBuilder(CloudCredentialSpecFluent<?> fluent, CloudCredentialSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCredentialsMode(instance.getCredentialsMode());
        fluent.withLogLevel(instance.getLogLevel());
        fluent.withManagementState(instance.getManagementState());
        fluent.withObservedConfig(instance.getObservedConfig());
        fluent.withOperatorLogLevel(instance.getOperatorLogLevel());
        fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
        this.validationEnabled = validationEnabled;
    }

    public CloudCredentialSpecBuilder(CloudCredentialSpec instance) {
        this(instance, (Boolean)true);
    }

    public CloudCredentialSpecBuilder(CloudCredentialSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCredentialsMode(instance.getCredentialsMode());
        this.withLogLevel(instance.getLogLevel());
        this.withManagementState(instance.getManagementState());
        this.withObservedConfig(instance.getObservedConfig());
        this.withOperatorLogLevel(instance.getOperatorLogLevel());
        this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public CloudCredentialSpec build() {
        CloudCredentialSpec buildable = new CloudCredentialSpec(this.fluent.getCredentialsMode(), this.fluent.getLogLevel(), this.fluent.getManagementState(), this.fluent.getObservedConfig(), this.fluent.getOperatorLogLevel(), this.fluent.getUnsupportedConfigOverrides());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CloudCredentialSpecBuilder that = (CloudCredentialSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

