/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_7.operator.controlplane.v1alpha1;

import io.fabric8.kubernetes.api.builder.v5_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_7.Nested;
import io.fabric8.openshift.api.model.v5_7.SecretNameReference;
import io.fabric8.openshift.api.model.v5_7.SecretNameReferenceBuilder;
import io.fabric8.openshift.api.model.v5_7.SecretNameReferenceFluentImpl;
import io.fabric8.openshift.api.model.v5_7.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckSpec;
import io.fabric8.openshift.api.model.v5_7.operator.controlplane.v1alpha1.PodNetworkConnectivityCheckSpecFluent;
import java.util.Objects;

public class PodNetworkConnectivityCheckSpecFluentImpl<A extends PodNetworkConnectivityCheckSpecFluent<A>>
extends BaseFluent<A>
implements PodNetworkConnectivityCheckSpecFluent<A> {
    private String sourcePod;
    private String targetEndpoint;
    private SecretNameReferenceBuilder tlsClientCert;

    public PodNetworkConnectivityCheckSpecFluentImpl() {
    }

    public PodNetworkConnectivityCheckSpecFluentImpl(PodNetworkConnectivityCheckSpec instance) {
        this.withSourcePod(instance.getSourcePod());
        this.withTargetEndpoint(instance.getTargetEndpoint());
        this.withTlsClientCert(instance.getTlsClientCert());
    }

    @Override
    public String getSourcePod() {
        return this.sourcePod;
    }

    @Override
    public A withSourcePod(String sourcePod) {
        this.sourcePod = sourcePod;
        return (A)this;
    }

    @Override
    public Boolean hasSourcePod() {
        return this.sourcePod != null;
    }

    @Override
    @Deprecated
    public A withNewSourcePod(String arg0) {
        return this.withSourcePod(new String(arg0));
    }

    @Override
    public String getTargetEndpoint() {
        return this.targetEndpoint;
    }

    @Override
    public A withTargetEndpoint(String targetEndpoint) {
        this.targetEndpoint = targetEndpoint;
        return (A)this;
    }

    @Override
    public Boolean hasTargetEndpoint() {
        return this.targetEndpoint != null;
    }

    @Override
    @Deprecated
    public A withNewTargetEndpoint(String arg0) {
        return this.withTargetEndpoint(new String(arg0));
    }

    @Override
    @Deprecated
    public SecretNameReference getTlsClientCert() {
        return this.tlsClientCert != null ? this.tlsClientCert.build() : null;
    }

    @Override
    public SecretNameReference buildTlsClientCert() {
        return this.tlsClientCert != null ? this.tlsClientCert.build() : null;
    }

    @Override
    public A withTlsClientCert(SecretNameReference tlsClientCert) {
        this._visitables.get("tlsClientCert").remove(this.tlsClientCert);
        if (tlsClientCert != null) {
            this.tlsClientCert = new SecretNameReferenceBuilder(tlsClientCert);
            this._visitables.get("tlsClientCert").add(this.tlsClientCert);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTlsClientCert() {
        return this.tlsClientCert != null;
    }

    @Override
    public A withNewTlsClientCert(String name) {
        return this.withTlsClientCert(new SecretNameReference(name));
    }

    @Override
    public PodNetworkConnectivityCheckSpecFluent.TlsClientCertNested<A> withNewTlsClientCert() {
        return new TlsClientCertNestedImpl();
    }

    @Override
    public PodNetworkConnectivityCheckSpecFluent.TlsClientCertNested<A> withNewTlsClientCertLike(SecretNameReference item) {
        return new TlsClientCertNestedImpl(item);
    }

    @Override
    public PodNetworkConnectivityCheckSpecFluent.TlsClientCertNested<A> editTlsClientCert() {
        return this.withNewTlsClientCertLike(this.getTlsClientCert());
    }

    @Override
    public PodNetworkConnectivityCheckSpecFluent.TlsClientCertNested<A> editOrNewTlsClientCert() {
        return this.withNewTlsClientCertLike(this.getTlsClientCert() != null ? this.getTlsClientCert() : new SecretNameReferenceBuilder().build());
    }

    @Override
    public PodNetworkConnectivityCheckSpecFluent.TlsClientCertNested<A> editOrNewTlsClientCertLike(SecretNameReference item) {
        return this.withNewTlsClientCertLike(this.getTlsClientCert() != null ? this.getTlsClientCert() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodNetworkConnectivityCheckSpecFluentImpl that = (PodNetworkConnectivityCheckSpecFluentImpl)o;
        if (this.sourcePod != null ? !this.sourcePod.equals(that.sourcePod) : that.sourcePod != null) {
            return false;
        }
        if (this.targetEndpoint != null ? !this.targetEndpoint.equals(that.targetEndpoint) : that.targetEndpoint != null) {
            return false;
        }
        return !(this.tlsClientCert != null ? !this.tlsClientCert.equals(that.tlsClientCert) : that.tlsClientCert != null);
    }

    public int hashCode() {
        return Objects.hash(this.sourcePod, this.targetEndpoint, this.tlsClientCert, super.hashCode());
    }

    public class TlsClientCertNestedImpl<N>
    extends SecretNameReferenceFluentImpl<PodNetworkConnectivityCheckSpecFluent.TlsClientCertNested<N>>
    implements PodNetworkConnectivityCheckSpecFluent.TlsClientCertNested<N>,
    Nested<N> {
        private final SecretNameReferenceBuilder builder;

        TlsClientCertNestedImpl(SecretNameReference item) {
            this.builder = new SecretNameReferenceBuilder(this, item);
        }

        TlsClientCertNestedImpl() {
            this.builder = new SecretNameReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodNetworkConnectivityCheckSpecFluentImpl.this.withTlsClientCert(this.builder.build());
        }

        @Override
        public N endTlsClientCert() {
            return this.and();
        }
    }
}

