/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_7.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.v5_7.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_7.miscellaneous.metal3.v1alpha1.Image;
import io.fabric8.openshift.api.model.v5_7.miscellaneous.metal3.v1alpha1.ImageFluent;
import io.fabric8.openshift.api.model.v5_7.miscellaneous.metal3.v1alpha1.ImageFluentImpl;
import java.util.Objects;

public class ImageBuilder
extends ImageFluentImpl<ImageBuilder>
implements VisitableBuilder<Image, ImageBuilder> {
    ImageFluent<?> fluent;
    Boolean validationEnabled;

    public ImageBuilder() {
        this(true);
    }

    public ImageBuilder(Boolean validationEnabled) {
        this(new Image(), validationEnabled);
    }

    public ImageBuilder(ImageFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ImageBuilder(ImageFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Image(), validationEnabled);
    }

    public ImageBuilder(ImageFluent<?> fluent, Image instance) {
        this(fluent, instance, true);
    }

    public ImageBuilder(ImageFluent<?> fluent, Image instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withChecksum(instance.getChecksum());
        fluent.withChecksumType(instance.getChecksumType());
        fluent.withFormat(instance.getFormat());
        fluent.withUrl(instance.getUrl());
        this.validationEnabled = validationEnabled;
    }

    public ImageBuilder(Image instance) {
        this(instance, (Boolean)true);
    }

    public ImageBuilder(Image instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withChecksum(instance.getChecksum());
        this.withChecksumType(instance.getChecksumType());
        this.withFormat(instance.getFormat());
        this.withUrl(instance.getUrl());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Image build() {
        Image buildable = new Image(this.fluent.getChecksum(), this.fluent.getChecksumType(), this.fluent.getFormat(), this.fluent.getUrl());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageBuilder that = (ImageBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

