/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_7;

import io.fabric8.kubernetes.api.builder.v5_7.BaseFluent;
import io.fabric8.openshift.api.model.v5_7.OpenIDClaims;
import io.fabric8.openshift.api.model.v5_7.OpenIDClaimsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class OpenIDClaimsFluentImpl<A extends OpenIDClaimsFluent<A>>
extends BaseFluent<A>
implements OpenIDClaimsFluent<A> {
    private List<String> email = new ArrayList<String>();
    private List<String> name = new ArrayList<String>();
    private List<String> preferredUsername = new ArrayList<String>();

    public OpenIDClaimsFluentImpl() {
    }

    public OpenIDClaimsFluentImpl(OpenIDClaims instance) {
        this.withEmail(instance.getEmail());
        this.withName(instance.getName());
        this.withPreferredUsername(instance.getPreferredUsername());
    }

    @Override
    public A addToEmail(int index, String item) {
        if (this.email == null) {
            this.email = new ArrayList<String>();
        }
        this.email.add(index, item);
        return (A)this;
    }

    @Override
    public A setToEmail(int index, String item) {
        if (this.email == null) {
            this.email = new ArrayList<String>();
        }
        this.email.set(index, item);
        return (A)this;
    }

    @Override
    public A addToEmail(String ... items) {
        if (this.email == null) {
            this.email = new ArrayList<String>();
        }
        for (String item : items) {
            this.email.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToEmail(Collection<String> items) {
        if (this.email == null) {
            this.email = new ArrayList<String>();
        }
        for (String item : items) {
            this.email.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromEmail(String ... items) {
        for (String item : items) {
            if (this.email == null) continue;
            this.email.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEmail(Collection<String> items) {
        for (String item : items) {
            if (this.email == null) continue;
            this.email.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getEmail() {
        return this.email;
    }

    @Override
    public String getEmail(int index) {
        return this.email.get(index);
    }

    @Override
    public String getFirstEmail() {
        return this.email.get(0);
    }

    @Override
    public String getLastEmail() {
        return this.email.get(this.email.size() - 1);
    }

    @Override
    public String getMatchingEmail(Predicate<String> predicate) {
        for (String item : this.email) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEmail(Predicate<String> predicate) {
        for (String item : this.email) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEmail(List<String> email) {
        if (this.email != null) {
            this._visitables.get("email").removeAll(this.email);
        }
        if (email != null) {
            this.email = new ArrayList<String>();
            for (String item : email) {
                this.addToEmail(item);
            }
        } else {
            this.email = null;
        }
        return (A)this;
    }

    @Override
    public A withEmail(String ... email) {
        if (this.email != null) {
            this.email.clear();
        }
        if (email != null) {
            for (String item : email) {
                this.addToEmail(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEmail() {
        return this.email != null && !this.email.isEmpty();
    }

    @Override
    public A addNewEmail(String arg0) {
        return this.addToEmail(new String(arg0));
    }

    @Override
    public A addToName(int index, String item) {
        if (this.name == null) {
            this.name = new ArrayList<String>();
        }
        this.name.add(index, item);
        return (A)this;
    }

    @Override
    public A setToName(int index, String item) {
        if (this.name == null) {
            this.name = new ArrayList<String>();
        }
        this.name.set(index, item);
        return (A)this;
    }

    @Override
    public A addToName(String ... items) {
        if (this.name == null) {
            this.name = new ArrayList<String>();
        }
        for (String item : items) {
            this.name.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToName(Collection<String> items) {
        if (this.name == null) {
            this.name = new ArrayList<String>();
        }
        for (String item : items) {
            this.name.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromName(String ... items) {
        for (String item : items) {
            if (this.name == null) continue;
            this.name.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromName(Collection<String> items) {
        for (String item : items) {
            if (this.name == null) continue;
            this.name.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getName() {
        return this.name;
    }

    @Override
    public String getName(int index) {
        return this.name.get(index);
    }

    @Override
    public String getFirstName() {
        return this.name.get(0);
    }

    @Override
    public String getLastName() {
        return this.name.get(this.name.size() - 1);
    }

    @Override
    public String getMatchingName(Predicate<String> predicate) {
        for (String item : this.name) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingName(Predicate<String> predicate) {
        for (String item : this.name) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withName(List<String> name) {
        if (this.name != null) {
            this._visitables.get("name").removeAll(this.name);
        }
        if (name != null) {
            this.name = new ArrayList<String>();
            for (String item : name) {
                this.addToName(item);
            }
        } else {
            this.name = null;
        }
        return (A)this;
    }

    @Override
    public A withName(String ... name) {
        if (this.name != null) {
            this.name.clear();
        }
        if (name != null) {
            for (String item : name) {
                this.addToName(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public A addNewName(String arg0) {
        return this.addToName(new String(arg0));
    }

    @Override
    public A addToPreferredUsername(int index, String item) {
        if (this.preferredUsername == null) {
            this.preferredUsername = new ArrayList<String>();
        }
        this.preferredUsername.add(index, item);
        return (A)this;
    }

    @Override
    public A setToPreferredUsername(int index, String item) {
        if (this.preferredUsername == null) {
            this.preferredUsername = new ArrayList<String>();
        }
        this.preferredUsername.set(index, item);
        return (A)this;
    }

    @Override
    public A addToPreferredUsername(String ... items) {
        if (this.preferredUsername == null) {
            this.preferredUsername = new ArrayList<String>();
        }
        for (String item : items) {
            this.preferredUsername.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToPreferredUsername(Collection<String> items) {
        if (this.preferredUsername == null) {
            this.preferredUsername = new ArrayList<String>();
        }
        for (String item : items) {
            this.preferredUsername.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromPreferredUsername(String ... items) {
        for (String item : items) {
            if (this.preferredUsername == null) continue;
            this.preferredUsername.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPreferredUsername(Collection<String> items) {
        for (String item : items) {
            if (this.preferredUsername == null) continue;
            this.preferredUsername.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getPreferredUsername() {
        return this.preferredUsername;
    }

    @Override
    public String getPreferredUsername(int index) {
        return this.preferredUsername.get(index);
    }

    @Override
    public String getFirstPreferredUsername() {
        return this.preferredUsername.get(0);
    }

    @Override
    public String getLastPreferredUsername() {
        return this.preferredUsername.get(this.preferredUsername.size() - 1);
    }

    @Override
    public String getMatchingPreferredUsername(Predicate<String> predicate) {
        for (String item : this.preferredUsername) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPreferredUsername(Predicate<String> predicate) {
        for (String item : this.preferredUsername) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPreferredUsername(List<String> preferredUsername) {
        if (this.preferredUsername != null) {
            this._visitables.get("preferredUsername").removeAll(this.preferredUsername);
        }
        if (preferredUsername != null) {
            this.preferredUsername = new ArrayList<String>();
            for (String item : preferredUsername) {
                this.addToPreferredUsername(item);
            }
        } else {
            this.preferredUsername = null;
        }
        return (A)this;
    }

    @Override
    public A withPreferredUsername(String ... preferredUsername) {
        if (this.preferredUsername != null) {
            this.preferredUsername.clear();
        }
        if (preferredUsername != null) {
            for (String item : preferredUsername) {
                this.addToPreferredUsername(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPreferredUsername() {
        return this.preferredUsername != null && !this.preferredUsername.isEmpty();
    }

    @Override
    public A addNewPreferredUsername(String arg0) {
        return this.addToPreferredUsername(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenIDClaimsFluentImpl that = (OpenIDClaimsFluentImpl)o;
        if (this.email != null ? !this.email.equals(that.email) : that.email != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.preferredUsername != null ? !this.preferredUsername.equals(that.preferredUsername) : that.preferredUsername != null);
    }

    public int hashCode() {
        return Objects.hash(this.email, this.name, this.preferredUsername, super.hashCode());
    }
}

