/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_7.apps;

import io.fabric8.kubernetes.api.builder.v5_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_7.Nested;
import io.fabric8.kubernetes.api.model.v5_7.LabelSelector;
import io.fabric8.kubernetes.api.model.v5_7.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.v5_7.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.v5_7.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.v5_7.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.v5_7.PodTemplateSpecFluentImpl;
import io.fabric8.kubernetes.api.model.v5_7.apps.ReplicaSetSpec;
import io.fabric8.kubernetes.api.model.v5_7.apps.ReplicaSetSpecFluent;
import java.util.Objects;

public class ReplicaSetSpecFluentImpl<A extends ReplicaSetSpecFluent<A>>
extends BaseFluent<A>
implements ReplicaSetSpecFluent<A> {
    private Integer minReadySeconds;
    private Integer replicas;
    private LabelSelectorBuilder selector;
    private PodTemplateSpecBuilder template;

    public ReplicaSetSpecFluentImpl() {
    }

    public ReplicaSetSpecFluentImpl(ReplicaSetSpec instance) {
        this.withMinReadySeconds(instance.getMinReadySeconds());
        this.withReplicas(instance.getReplicas());
        this.withSelector(instance.getSelector());
        this.withTemplate(instance.getTemplate());
    }

    @Override
    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    @Override
    public A withMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return (A)this;
    }

    @Override
    public Boolean hasMinReadySeconds() {
        return this.minReadySeconds != null;
    }

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    @Override
    @Deprecated
    public LabelSelector getSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public A withSelector(LabelSelector selector) {
        this._visitables.get("selector").remove(this.selector);
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get("selector").add(this.selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public ReplicaSetSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public ReplicaSetSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public ReplicaSetSpecFluent.SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public ReplicaSetSpecFluent.SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public ReplicaSetSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : item);
    }

    @Override
    @Deprecated
    public PodTemplateSpec getTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public PodTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public A withTemplate(PodTemplateSpec template) {
        this._visitables.get("template").remove(this.template);
        if (template != null) {
            this.template = new PodTemplateSpecBuilder(template);
            this._visitables.get("template").add(this.template);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTemplate() {
        return this.template != null;
    }

    @Override
    public ReplicaSetSpecFluent.TemplateNested<A> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    @Override
    public ReplicaSetSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
        return new TemplateNestedImpl(item);
    }

    @Override
    public ReplicaSetSpecFluent.TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(this.getTemplate());
    }

    @Override
    public ReplicaSetSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : new PodTemplateSpecBuilder().build());
    }

    @Override
    public ReplicaSetSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicaSetSpecFluentImpl that = (ReplicaSetSpecFluentImpl)o;
        if (this.minReadySeconds != null ? !this.minReadySeconds.equals(that.minReadySeconds) : that.minReadySeconds != null) {
            return false;
        }
        if (this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        return !(this.template != null ? !this.template.equals(that.template) : that.template != null);
    }

    public int hashCode() {
        return Objects.hash(this.minReadySeconds, this.replicas, this.selector, this.template, super.hashCode());
    }

    public class TemplateNestedImpl<N>
    extends PodTemplateSpecFluentImpl<ReplicaSetSpecFluent.TemplateNested<N>>
    implements ReplicaSetSpecFluent.TemplateNested<N>,
    Nested<N> {
        private final PodTemplateSpecBuilder builder;

        TemplateNestedImpl(PodTemplateSpec item) {
            this.builder = new PodTemplateSpecBuilder(this, item);
        }

        TemplateNestedImpl() {
            this.builder = new PodTemplateSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)ReplicaSetSpecFluentImpl.this.withTemplate(this.builder.build());
        }

        @Override
        public N endTemplate() {
            return this.and();
        }
    }

    public class SelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<ReplicaSetSpecFluent.SelectorNested<N>>
    implements ReplicaSetSpecFluent.SelectorNested<N>,
    Nested<N> {
        private final LabelSelectorBuilder builder;

        SelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        SelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)ReplicaSetSpecFluentImpl.this.withSelector(this.builder.build());
        }

        @Override
        public N endSelector() {
            return this.and();
        }
    }
}

