/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_7;

import io.fabric8.kubernetes.api.builder.v5_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_7.Nested;
import io.fabric8.kubernetes.api.model.v5_7.ObjectMeta;
import io.fabric8.kubernetes.api.model.v5_7.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v5_7.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.v5_7.Pod;
import io.fabric8.kubernetes.api.model.v5_7.PodFluent;
import io.fabric8.kubernetes.api.model.v5_7.PodSpec;
import io.fabric8.kubernetes.api.model.v5_7.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.v5_7.PodSpecFluentImpl;
import io.fabric8.kubernetes.api.model.v5_7.PodStatus;
import io.fabric8.kubernetes.api.model.v5_7.PodStatusBuilder;
import io.fabric8.kubernetes.api.model.v5_7.PodStatusFluentImpl;
import java.util.Objects;

public class PodFluentImpl<A extends PodFluent<A>>
extends BaseFluent<A>
implements PodFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private PodSpecBuilder spec;
    private PodStatusBuilder status;

    public PodFluentImpl() {
    }

    public PodFluentImpl(Pod instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public PodFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public PodFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public PodFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public PodFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public PodFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public PodSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public PodSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(PodSpec spec) {
        this._visitables.get("spec").remove(this.spec);
        if (spec != null) {
            this.spec = new PodSpecBuilder(spec);
            this._visitables.get("spec").add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public PodFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public PodFluent.SpecNested<A> withNewSpecLike(PodSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public PodFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public PodFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new PodSpecBuilder().build());
    }

    @Override
    public PodFluent.SpecNested<A> editOrNewSpecLike(PodSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public PodStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public PodStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(PodStatus status) {
        this._visitables.get("status").remove(this.status);
        if (status != null) {
            this.status = new PodStatusBuilder(status);
            this._visitables.get("status").add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public PodFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public PodFluent.StatusNested<A> withNewStatusLike(PodStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public PodFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public PodFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new PodStatusBuilder().build());
    }

    @Override
    public PodFluent.StatusNested<A> editOrNewStatusLike(PodStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodFluentImpl that = (PodFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, super.hashCode());
    }

    public class StatusNestedImpl<N>
    extends PodStatusFluentImpl<PodFluent.StatusNested<N>>
    implements PodFluent.StatusNested<N>,
    Nested<N> {
        private final PodStatusBuilder builder;

        StatusNestedImpl(PodStatus item) {
            this.builder = new PodStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new PodStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends PodSpecFluentImpl<PodFluent.SpecNested<N>>
    implements PodFluent.SpecNested<N>,
    Nested<N> {
        private final PodSpecBuilder builder;

        SpecNestedImpl(PodSpec item) {
            this.builder = new PodSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new PodSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<PodFluent.MetadataNested<N>>
    implements PodFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

