/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_7;

import io.fabric8.kubernetes.api.builder.v5_7.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_7.NodeAddress;
import io.fabric8.kubernetes.api.model.v5_7.NodeAddressFluent;
import io.fabric8.kubernetes.api.model.v5_7.NodeAddressFluentImpl;
import java.util.Objects;

public class NodeAddressBuilder
extends NodeAddressFluentImpl<NodeAddressBuilder>
implements VisitableBuilder<NodeAddress, NodeAddressBuilder> {
    NodeAddressFluent<?> fluent;
    Boolean validationEnabled;

    public NodeAddressBuilder() {
        this(true);
    }

    public NodeAddressBuilder(Boolean validationEnabled) {
        this(new NodeAddress(), validationEnabled);
    }

    public NodeAddressBuilder(NodeAddressFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NodeAddressBuilder(NodeAddressFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NodeAddress(), validationEnabled);
    }

    public NodeAddressBuilder(NodeAddressFluent<?> fluent, NodeAddress instance) {
        this(fluent, instance, true);
    }

    public NodeAddressBuilder(NodeAddressFluent<?> fluent, NodeAddress instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAddress(instance.getAddress());
        fluent.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public NodeAddressBuilder(NodeAddress instance) {
        this(instance, (Boolean)true);
    }

    public NodeAddressBuilder(NodeAddress instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAddress(instance.getAddress());
        this.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public NodeAddress build() {
        NodeAddress buildable = new NodeAddress(this.fluent.getAddress(), this.fluent.getType());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeAddressBuilder that = (NodeAddressBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

