/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v5_7;

import io.fabric8.kubernetes.clnt.v5_7.BaseClient;
import io.fabric8.kubernetes.clnt.v5_7.Config;
import io.fabric8.kubernetes.clnt.v5_7.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v5_7.dsl.Resource;
import io.fabric8.openshift.api.model.v5_7.APIServer;
import io.fabric8.openshift.api.model.v5_7.APIServerList;
import io.fabric8.openshift.api.model.v5_7.Authentication;
import io.fabric8.openshift.api.model.v5_7.AuthenticationList;
import io.fabric8.openshift.api.model.v5_7.ClusterOperator;
import io.fabric8.openshift.api.model.v5_7.ClusterOperatorList;
import io.fabric8.openshift.api.model.v5_7.ClusterVersion;
import io.fabric8.openshift.api.model.v5_7.ClusterVersionList;
import io.fabric8.openshift.api.model.v5_7.Console;
import io.fabric8.openshift.api.model.v5_7.ConsoleList;
import io.fabric8.openshift.api.model.v5_7.DNS;
import io.fabric8.openshift.api.model.v5_7.DNSList;
import io.fabric8.openshift.api.model.v5_7.FeatureGate;
import io.fabric8.openshift.api.model.v5_7.FeatureGateList;
import io.fabric8.openshift.api.model.v5_7.Infrastructure;
import io.fabric8.openshift.api.model.v5_7.InfrastructureList;
import io.fabric8.openshift.api.model.v5_7.Ingress;
import io.fabric8.openshift.api.model.v5_7.IngressList;
import io.fabric8.openshift.api.model.v5_7.Network;
import io.fabric8.openshift.api.model.v5_7.NetworkList;
import io.fabric8.openshift.api.model.v5_7.OAuth;
import io.fabric8.openshift.api.model.v5_7.OAuthList;
import io.fabric8.openshift.api.model.v5_7.OperatorHub;
import io.fabric8.openshift.api.model.v5_7.OperatorHubList;
import io.fabric8.openshift.api.model.v5_7.Proxy;
import io.fabric8.openshift.api.model.v5_7.ProxyList;
import io.fabric8.openshift.api.model.v5_7.Scheduler;
import io.fabric8.openshift.api.model.v5_7.SchedulerList;
import io.fabric8.openshift.clnt.v5_7.OpenShiftConfig;
import io.fabric8.openshift.clnt.v5_7.OpenShiftHandlers;
import io.fabric8.openshift.clnt.v5_7.dsl.OpenShiftConfigAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_7.dsl.internal.config.DNSOperationsImpl;
import okhttp3.OkHttpClient;

public class OpenShiftConfigAPIGroupClient
extends BaseClient
implements OpenShiftConfigAPIGroupDSL {
    public OpenShiftConfigAPIGroupClient() {
    }

    public OpenShiftConfigAPIGroupClient(OkHttpClient httpClient, Config config) {
        super(httpClient, config);
    }

    @Override
    public NonNamespaceOperation<APIServer, APIServerList, Resource<APIServer>> apiServers() {
        return OpenShiftHandlers.getOperation(APIServer.class, APIServerList.class, this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<Authentication, AuthenticationList, Resource<Authentication>> authentications() {
        return OpenShiftHandlers.getOperation(Authentication.class, AuthenticationList.class, this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<ClusterOperator, ClusterOperatorList, Resource<ClusterOperator>> clusterOperators() {
        return OpenShiftHandlers.getOperation(ClusterOperator.class, ClusterOperatorList.class, this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<Console, ConsoleList, Resource<Console>> consoles() {
        return OpenShiftHandlers.getOperation(Console.class, ConsoleList.class, this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<ClusterVersion, ClusterVersionList, Resource<ClusterVersion>> clusterVersions() {
        return OpenShiftHandlers.getOperation(ClusterVersion.class, ClusterVersionList.class, this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<DNS, DNSList, Resource<DNS>> dnses() {
        return new DNSOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<FeatureGate, FeatureGateList, Resource<FeatureGate>> featureGates() {
        return OpenShiftHandlers.getOperation(FeatureGate.class, FeatureGateList.class, this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<Infrastructure, InfrastructureList, Resource<Infrastructure>> infrastructures() {
        return OpenShiftHandlers.getOperation(Infrastructure.class, InfrastructureList.class, this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<Ingress, IngressList, Resource<Ingress>> ingresses() {
        return OpenShiftHandlers.getOperation(Ingress.class, IngressList.class, this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<Network, NetworkList, Resource<Network>> networks() {
        return OpenShiftHandlers.getOperation(Network.class, NetworkList.class, this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<OAuth, OAuthList, Resource<OAuth>> oAuths() {
        return OpenShiftHandlers.getOperation(OAuth.class, OAuthList.class, this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<OperatorHub, OperatorHubList, Resource<OperatorHub>> operatorHubs() {
        return OpenShiftHandlers.getOperation(OperatorHub.class, OperatorHubList.class, this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<Proxy, ProxyList, Resource<Proxy>> proxies() {
        return OpenShiftHandlers.getOperation(Proxy.class, ProxyList.class, this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<Scheduler, SchedulerList, Resource<Scheduler>> schedulers() {
        return OpenShiftHandlers.getOperation(Scheduler.class, SchedulerList.class, this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }
}

