/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_7.operatorhub.v1;

import com.fasterxml.jackson.databind.JsonNode;
import io.fabric8.kubernetes.api.builder.v5_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_7.Nested;
import io.fabric8.kubernetes.api.model.v5_7.LabelSelector;
import io.fabric8.kubernetes.api.model.v5_7.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.v5_7.LabelSelectorFluentImpl;
import io.fabric8.openshift.api.model.v5_7.operatorhub.v1.Components;
import io.fabric8.openshift.api.model.v5_7.operatorhub.v1.ComponentsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ComponentsFluentImpl<A extends ComponentsFluent<A>>
extends BaseFluent<A>
implements ComponentsFluent<A> {
    private LabelSelectorBuilder labelSelector;
    private List<JsonNode> refs = new ArrayList<JsonNode>();

    public ComponentsFluentImpl() {
    }

    public ComponentsFluentImpl(Components instance) {
        this.withLabelSelector(instance.getLabelSelector());
        this.withRefs(instance.getRefs());
    }

    @Override
    @Deprecated
    public LabelSelector getLabelSelector() {
        return this.labelSelector != null ? this.labelSelector.build() : null;
    }

    @Override
    public LabelSelector buildLabelSelector() {
        return this.labelSelector != null ? this.labelSelector.build() : null;
    }

    @Override
    public A withLabelSelector(LabelSelector labelSelector) {
        this._visitables.get("labelSelector").remove(this.labelSelector);
        if (labelSelector != null) {
            this.labelSelector = new LabelSelectorBuilder(labelSelector);
            this._visitables.get("labelSelector").add(this.labelSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLabelSelector() {
        return this.labelSelector != null;
    }

    @Override
    public ComponentsFluent.LabelSelectorNested<A> withNewLabelSelector() {
        return new LabelSelectorNestedImpl();
    }

    @Override
    public ComponentsFluent.LabelSelectorNested<A> withNewLabelSelectorLike(LabelSelector item) {
        return new LabelSelectorNestedImpl(item);
    }

    @Override
    public ComponentsFluent.LabelSelectorNested<A> editLabelSelector() {
        return this.withNewLabelSelectorLike(this.getLabelSelector());
    }

    @Override
    public ComponentsFluent.LabelSelectorNested<A> editOrNewLabelSelector() {
        return this.withNewLabelSelectorLike(this.getLabelSelector() != null ? this.getLabelSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public ComponentsFluent.LabelSelectorNested<A> editOrNewLabelSelectorLike(LabelSelector item) {
        return this.withNewLabelSelectorLike(this.getLabelSelector() != null ? this.getLabelSelector() : item);
    }

    @Override
    public A addToRefs(int index, JsonNode item) {
        if (this.refs == null) {
            this.refs = new ArrayList<JsonNode>();
        }
        this.refs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToRefs(int index, JsonNode item) {
        if (this.refs == null) {
            this.refs = new ArrayList<JsonNode>();
        }
        this.refs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToRefs(JsonNode ... items) {
        if (this.refs == null) {
            this.refs = new ArrayList<JsonNode>();
        }
        for (JsonNode item : items) {
            this.refs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToRefs(Collection<JsonNode> items) {
        if (this.refs == null) {
            this.refs = new ArrayList<JsonNode>();
        }
        for (JsonNode item : items) {
            this.refs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromRefs(JsonNode ... items) {
        for (JsonNode item : items) {
            if (this.refs == null) continue;
            this.refs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRefs(Collection<JsonNode> items) {
        for (JsonNode item : items) {
            if (this.refs == null) continue;
            this.refs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<JsonNode> getRefs() {
        return this.refs;
    }

    @Override
    public JsonNode getRef(int index) {
        return this.refs.get(index);
    }

    @Override
    public JsonNode getFirstRef() {
        return this.refs.get(0);
    }

    @Override
    public JsonNode getLastRef() {
        return this.refs.get(this.refs.size() - 1);
    }

    @Override
    public JsonNode getMatchingRef(Predicate<JsonNode> predicate) {
        for (JsonNode item : this.refs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRef(Predicate<JsonNode> predicate) {
        for (JsonNode item : this.refs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRefs(List<JsonNode> refs) {
        if (this.refs != null) {
            this._visitables.get("refs").removeAll(this.refs);
        }
        if (refs != null) {
            this.refs = new ArrayList<JsonNode>();
            for (JsonNode item : refs) {
                this.addToRefs(item);
            }
        } else {
            this.refs = null;
        }
        return (A)this;
    }

    @Override
    public A withRefs(JsonNode ... refs) {
        if (this.refs != null) {
            this.refs.clear();
        }
        if (refs != null) {
            for (JsonNode item : refs) {
                this.addToRefs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRefs() {
        return this.refs != null && !this.refs.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentsFluentImpl that = (ComponentsFluentImpl)o;
        if (this.labelSelector != null ? !this.labelSelector.equals(that.labelSelector) : that.labelSelector != null) {
            return false;
        }
        return !(this.refs != null ? !this.refs.equals(that.refs) : that.refs != null);
    }

    public int hashCode() {
        return Objects.hash(this.labelSelector, this.refs, super.hashCode());
    }

    public class LabelSelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<ComponentsFluent.LabelSelectorNested<N>>
    implements ComponentsFluent.LabelSelectorNested<N>,
    Nested<N> {
        private final LabelSelectorBuilder builder;

        LabelSelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        LabelSelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)ComponentsFluentImpl.this.withLabelSelector(this.builder.build());
        }

        @Override
        public N endLabelSelector() {
            return this.and();
        }
    }
}

