/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_7.monitoring.v1;

import io.fabric8.kubernetes.api.builder.v5_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_7.Nested;
import io.fabric8.kubernetes.api.model.v5_7.EmptyDirVolumeSource;
import io.fabric8.openshift.api.model.v5_7.monitoring.v1.EmbeddedPersistentVolumeClaim;
import io.fabric8.openshift.api.model.v5_7.monitoring.v1.EmbeddedPersistentVolumeClaimBuilder;
import io.fabric8.openshift.api.model.v5_7.monitoring.v1.EmbeddedPersistentVolumeClaimFluentImpl;
import io.fabric8.openshift.api.model.v5_7.monitoring.v1.StorageSpec;
import io.fabric8.openshift.api.model.v5_7.monitoring.v1.StorageSpecFluent;
import java.util.Objects;

public class StorageSpecFluentImpl<A extends StorageSpecFluent<A>>
extends BaseFluent<A>
implements StorageSpecFluent<A> {
    private Boolean disableMountSubPath;
    private EmptyDirVolumeSource emptyDir;
    private EmbeddedPersistentVolumeClaimBuilder volumeClaimTemplate;

    public StorageSpecFluentImpl() {
    }

    public StorageSpecFluentImpl(StorageSpec instance) {
        this.withDisableMountSubPath(instance.getDisableMountSubPath());
        this.withEmptyDir(instance.getEmptyDir());
        this.withVolumeClaimTemplate(instance.getVolumeClaimTemplate());
    }

    @Override
    public Boolean getDisableMountSubPath() {
        return this.disableMountSubPath;
    }

    @Override
    public A withDisableMountSubPath(Boolean disableMountSubPath) {
        this.disableMountSubPath = disableMountSubPath;
        return (A)this;
    }

    @Override
    public Boolean hasDisableMountSubPath() {
        return this.disableMountSubPath != null;
    }

    @Override
    public EmptyDirVolumeSource getEmptyDir() {
        return this.emptyDir;
    }

    @Override
    public A withEmptyDir(EmptyDirVolumeSource emptyDir) {
        this.emptyDir = emptyDir;
        return (A)this;
    }

    @Override
    public Boolean hasEmptyDir() {
        return this.emptyDir != null;
    }

    @Override
    @Deprecated
    public EmbeddedPersistentVolumeClaim getVolumeClaimTemplate() {
        return this.volumeClaimTemplate != null ? this.volumeClaimTemplate.build() : null;
    }

    @Override
    public EmbeddedPersistentVolumeClaim buildVolumeClaimTemplate() {
        return this.volumeClaimTemplate != null ? this.volumeClaimTemplate.build() : null;
    }

    @Override
    public A withVolumeClaimTemplate(EmbeddedPersistentVolumeClaim volumeClaimTemplate) {
        this._visitables.get("volumeClaimTemplate").remove(this.volumeClaimTemplate);
        if (volumeClaimTemplate != null) {
            this.volumeClaimTemplate = new EmbeddedPersistentVolumeClaimBuilder(volumeClaimTemplate);
            this._visitables.get("volumeClaimTemplate").add(this.volumeClaimTemplate);
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumeClaimTemplate() {
        return this.volumeClaimTemplate != null;
    }

    @Override
    public StorageSpecFluent.VolumeClaimTemplateNested<A> withNewVolumeClaimTemplate() {
        return new VolumeClaimTemplateNestedImpl();
    }

    @Override
    public StorageSpecFluent.VolumeClaimTemplateNested<A> withNewVolumeClaimTemplateLike(EmbeddedPersistentVolumeClaim item) {
        return new VolumeClaimTemplateNestedImpl(item);
    }

    @Override
    public StorageSpecFluent.VolumeClaimTemplateNested<A> editVolumeClaimTemplate() {
        return this.withNewVolumeClaimTemplateLike(this.getVolumeClaimTemplate());
    }

    @Override
    public StorageSpecFluent.VolumeClaimTemplateNested<A> editOrNewVolumeClaimTemplate() {
        return this.withNewVolumeClaimTemplateLike(this.getVolumeClaimTemplate() != null ? this.getVolumeClaimTemplate() : new EmbeddedPersistentVolumeClaimBuilder().build());
    }

    @Override
    public StorageSpecFluent.VolumeClaimTemplateNested<A> editOrNewVolumeClaimTemplateLike(EmbeddedPersistentVolumeClaim item) {
        return this.withNewVolumeClaimTemplateLike(this.getVolumeClaimTemplate() != null ? this.getVolumeClaimTemplate() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageSpecFluentImpl that = (StorageSpecFluentImpl)o;
        if (this.disableMountSubPath != null ? !this.disableMountSubPath.equals(that.disableMountSubPath) : that.disableMountSubPath != null) {
            return false;
        }
        if (this.emptyDir != null ? !this.emptyDir.equals(that.emptyDir) : that.emptyDir != null) {
            return false;
        }
        return !(this.volumeClaimTemplate != null ? !this.volumeClaimTemplate.equals(that.volumeClaimTemplate) : that.volumeClaimTemplate != null);
    }

    public int hashCode() {
        return Objects.hash(this.disableMountSubPath, this.emptyDir, this.volumeClaimTemplate, super.hashCode());
    }

    public class VolumeClaimTemplateNestedImpl<N>
    extends EmbeddedPersistentVolumeClaimFluentImpl<StorageSpecFluent.VolumeClaimTemplateNested<N>>
    implements StorageSpecFluent.VolumeClaimTemplateNested<N>,
    Nested<N> {
        private final EmbeddedPersistentVolumeClaimBuilder builder;

        VolumeClaimTemplateNestedImpl(EmbeddedPersistentVolumeClaim item) {
            this.builder = new EmbeddedPersistentVolumeClaimBuilder(this, item);
        }

        VolumeClaimTemplateNestedImpl() {
            this.builder = new EmbeddedPersistentVolumeClaimBuilder(this);
        }

        @Override
        public N and() {
            return (N)StorageSpecFluentImpl.this.withVolumeClaimTemplate(this.builder.build());
        }

        @Override
        public N endVolumeClaimTemplate() {
            return this.and();
        }
    }
}

