/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_7;

import io.fabric8.kubernetes.api.builder.v5_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_7.Nested;
import io.fabric8.kubernetes.api.model.v5_7.ObjectMeta;
import io.fabric8.kubernetes.api.model.v5_7.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v5_7.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.v5_7.Project;
import io.fabric8.openshift.api.model.v5_7.ProjectFluent;
import io.fabric8.openshift.api.model.v5_7.ProjectSpec;
import io.fabric8.openshift.api.model.v5_7.ProjectSpecBuilder;
import io.fabric8.openshift.api.model.v5_7.ProjectSpecFluentImpl;
import io.fabric8.openshift.api.model.v5_7.ProjectStatus;
import io.fabric8.openshift.api.model.v5_7.ProjectStatusBuilder;
import io.fabric8.openshift.api.model.v5_7.ProjectStatusFluentImpl;
import java.util.Objects;

public class ProjectFluentImpl<A extends ProjectFluent<A>>
extends BaseFluent<A>
implements ProjectFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private ProjectSpecBuilder spec;
    private ProjectStatusBuilder status;

    public ProjectFluentImpl() {
    }

    public ProjectFluentImpl(Project instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ProjectFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ProjectFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ProjectFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ProjectFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ProjectFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public ProjectSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public ProjectSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(ProjectSpec spec) {
        this._visitables.get("spec").remove(this.spec);
        if (spec != null) {
            this.spec = new ProjectSpecBuilder(spec);
            this._visitables.get("spec").add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public ProjectFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public ProjectFluent.SpecNested<A> withNewSpecLike(ProjectSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public ProjectFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public ProjectFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new ProjectSpecBuilder().build());
    }

    @Override
    public ProjectFluent.SpecNested<A> editOrNewSpecLike(ProjectSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public ProjectStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public ProjectStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(ProjectStatus status) {
        this._visitables.get("status").remove(this.status);
        if (status != null) {
            this.status = new ProjectStatusBuilder(status);
            this._visitables.get("status").add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public ProjectFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public ProjectFluent.StatusNested<A> withNewStatusLike(ProjectStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public ProjectFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public ProjectFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new ProjectStatusBuilder().build());
    }

    @Override
    public ProjectFluent.StatusNested<A> editOrNewStatusLike(ProjectStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectFluentImpl that = (ProjectFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, super.hashCode());
    }

    public class StatusNestedImpl<N>
    extends ProjectStatusFluentImpl<ProjectFluent.StatusNested<N>>
    implements ProjectFluent.StatusNested<N>,
    Nested<N> {
        private final ProjectStatusBuilder builder;

        StatusNestedImpl(ProjectStatus item) {
            this.builder = new ProjectStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new ProjectStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)ProjectFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends ProjectSpecFluentImpl<ProjectFluent.SpecNested<N>>
    implements ProjectFluent.SpecNested<N>,
    Nested<N> {
        private final ProjectSpecBuilder builder;

        SpecNestedImpl(ProjectSpec item) {
            this.builder = new ProjectSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new ProjectSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)ProjectFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ProjectFluent.MetadataNested<N>>
    implements ProjectFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ProjectFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

