/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_7;

import io.fabric8.kubernetes.api.builder.v5_7.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_7.Infrastructure;
import io.fabric8.openshift.api.model.v5_7.InfrastructureFluent;
import io.fabric8.openshift.api.model.v5_7.InfrastructureFluentImpl;
import java.util.Objects;

public class InfrastructureBuilder
extends InfrastructureFluentImpl<InfrastructureBuilder>
implements VisitableBuilder<Infrastructure, InfrastructureBuilder> {
    InfrastructureFluent<?> fluent;
    Boolean validationEnabled;

    public InfrastructureBuilder() {
        this(true);
    }

    public InfrastructureBuilder(Boolean validationEnabled) {
        this(new Infrastructure(), validationEnabled);
    }

    public InfrastructureBuilder(InfrastructureFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public InfrastructureBuilder(InfrastructureFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Infrastructure(), validationEnabled);
    }

    public InfrastructureBuilder(InfrastructureFluent<?> fluent, Infrastructure instance) {
        this(fluent, instance, true);
    }

    public InfrastructureBuilder(InfrastructureFluent<?> fluent, Infrastructure instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public InfrastructureBuilder(Infrastructure instance) {
        this(instance, (Boolean)true);
    }

    public InfrastructureBuilder(Infrastructure instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Infrastructure build() {
        Infrastructure buildable = new Infrastructure(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InfrastructureBuilder that = (InfrastructureBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

