/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_7;

import io.fabric8.kubernetes.api.builder.v5_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_7.Nested;
import io.fabric8.openshift.api.model.v5_7.GoogleIdentityProvider;
import io.fabric8.openshift.api.model.v5_7.GoogleIdentityProviderFluent;
import io.fabric8.openshift.api.model.v5_7.SecretNameReference;
import io.fabric8.openshift.api.model.v5_7.SecretNameReferenceBuilder;
import io.fabric8.openshift.api.model.v5_7.SecretNameReferenceFluentImpl;
import java.util.Objects;

public class GoogleIdentityProviderFluentImpl<A extends GoogleIdentityProviderFluent<A>>
extends BaseFluent<A>
implements GoogleIdentityProviderFluent<A> {
    private String clientID;
    private SecretNameReferenceBuilder clientSecret;
    private String hostedDomain;

    public GoogleIdentityProviderFluentImpl() {
    }

    public GoogleIdentityProviderFluentImpl(GoogleIdentityProvider instance) {
        this.withClientID(instance.getClientID());
        this.withClientSecret(instance.getClientSecret());
        this.withHostedDomain(instance.getHostedDomain());
    }

    @Override
    public String getClientID() {
        return this.clientID;
    }

    @Override
    public A withClientID(String clientID) {
        this.clientID = clientID;
        return (A)this;
    }

    @Override
    public Boolean hasClientID() {
        return this.clientID != null;
    }

    @Override
    @Deprecated
    public A withNewClientID(String arg0) {
        return this.withClientID(new String(arg0));
    }

    @Override
    @Deprecated
    public SecretNameReference getClientSecret() {
        return this.clientSecret != null ? this.clientSecret.build() : null;
    }

    @Override
    public SecretNameReference buildClientSecret() {
        return this.clientSecret != null ? this.clientSecret.build() : null;
    }

    @Override
    public A withClientSecret(SecretNameReference clientSecret) {
        this._visitables.get("clientSecret").remove(this.clientSecret);
        if (clientSecret != null) {
            this.clientSecret = new SecretNameReferenceBuilder(clientSecret);
            this._visitables.get("clientSecret").add(this.clientSecret);
        }
        return (A)this;
    }

    @Override
    public Boolean hasClientSecret() {
        return this.clientSecret != null;
    }

    @Override
    public A withNewClientSecret(String name) {
        return this.withClientSecret(new SecretNameReference(name));
    }

    @Override
    public GoogleIdentityProviderFluent.ClientSecretNested<A> withNewClientSecret() {
        return new ClientSecretNestedImpl();
    }

    @Override
    public GoogleIdentityProviderFluent.ClientSecretNested<A> withNewClientSecretLike(SecretNameReference item) {
        return new ClientSecretNestedImpl(item);
    }

    @Override
    public GoogleIdentityProviderFluent.ClientSecretNested<A> editClientSecret() {
        return this.withNewClientSecretLike(this.getClientSecret());
    }

    @Override
    public GoogleIdentityProviderFluent.ClientSecretNested<A> editOrNewClientSecret() {
        return this.withNewClientSecretLike(this.getClientSecret() != null ? this.getClientSecret() : new SecretNameReferenceBuilder().build());
    }

    @Override
    public GoogleIdentityProviderFluent.ClientSecretNested<A> editOrNewClientSecretLike(SecretNameReference item) {
        return this.withNewClientSecretLike(this.getClientSecret() != null ? this.getClientSecret() : item);
    }

    @Override
    public String getHostedDomain() {
        return this.hostedDomain;
    }

    @Override
    public A withHostedDomain(String hostedDomain) {
        this.hostedDomain = hostedDomain;
        return (A)this;
    }

    @Override
    public Boolean hasHostedDomain() {
        return this.hostedDomain != null;
    }

    @Override
    @Deprecated
    public A withNewHostedDomain(String arg0) {
        return this.withHostedDomain(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GoogleIdentityProviderFluentImpl that = (GoogleIdentityProviderFluentImpl)o;
        if (this.clientID != null ? !this.clientID.equals(that.clientID) : that.clientID != null) {
            return false;
        }
        if (this.clientSecret != null ? !this.clientSecret.equals(that.clientSecret) : that.clientSecret != null) {
            return false;
        }
        return !(this.hostedDomain != null ? !this.hostedDomain.equals(that.hostedDomain) : that.hostedDomain != null);
    }

    public int hashCode() {
        return Objects.hash(this.clientID, this.clientSecret, this.hostedDomain, super.hashCode());
    }

    public class ClientSecretNestedImpl<N>
    extends SecretNameReferenceFluentImpl<GoogleIdentityProviderFluent.ClientSecretNested<N>>
    implements GoogleIdentityProviderFluent.ClientSecretNested<N>,
    Nested<N> {
        private final SecretNameReferenceBuilder builder;

        ClientSecretNestedImpl(SecretNameReference item) {
            this.builder = new SecretNameReferenceBuilder(this, item);
        }

        ClientSecretNestedImpl() {
            this.builder = new SecretNameReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)GoogleIdentityProviderFluentImpl.this.withClientSecret(this.builder.build());
        }

        @Override
        public N endClientSecret() {
            return this.and();
        }
    }
}

