/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_7;

import io.fabric8.kubernetes.api.builder.v5_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_7.Nested;
import io.fabric8.openshift.api.model.v5_7.DeploymentCause;
import io.fabric8.openshift.api.model.v5_7.DeploymentCauseBuilder;
import io.fabric8.openshift.api.model.v5_7.DeploymentCauseFluentImpl;
import io.fabric8.openshift.api.model.v5_7.DeploymentDetails;
import io.fabric8.openshift.api.model.v5_7.DeploymentDetailsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class DeploymentDetailsFluentImpl<A extends DeploymentDetailsFluent<A>>
extends BaseFluent<A>
implements DeploymentDetailsFluent<A> {
    private List<DeploymentCauseBuilder> causes = new ArrayList<DeploymentCauseBuilder>();
    private String message;

    public DeploymentDetailsFluentImpl() {
    }

    public DeploymentDetailsFluentImpl(DeploymentDetails instance) {
        this.withCauses(instance.getCauses());
        this.withMessage(instance.getMessage());
    }

    @Override
    public A addToCauses(int index, DeploymentCause item) {
        if (this.causes == null) {
            this.causes = new ArrayList<DeploymentCauseBuilder>();
        }
        DeploymentCauseBuilder builder = new DeploymentCauseBuilder(item);
        this._visitables.get("causes").add(index >= 0 ? index : this._visitables.get("causes").size(), builder);
        this.causes.add(index >= 0 ? index : this.causes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToCauses(int index, DeploymentCause item) {
        if (this.causes == null) {
            this.causes = new ArrayList<DeploymentCauseBuilder>();
        }
        DeploymentCauseBuilder builder = new DeploymentCauseBuilder(item);
        if (index < 0 || index >= this._visitables.get("causes").size()) {
            this._visitables.get("causes").add(builder);
        } else {
            this._visitables.get("causes").set(index, builder);
        }
        if (index < 0 || index >= this.causes.size()) {
            this.causes.add(builder);
        } else {
            this.causes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToCauses(DeploymentCause ... items) {
        if (this.causes == null) {
            this.causes = new ArrayList<DeploymentCauseBuilder>();
        }
        for (DeploymentCause item : items) {
            DeploymentCauseBuilder builder = new DeploymentCauseBuilder(item);
            this._visitables.get("causes").add(builder);
            this.causes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToCauses(Collection<DeploymentCause> items) {
        if (this.causes == null) {
            this.causes = new ArrayList<DeploymentCauseBuilder>();
        }
        for (DeploymentCause item : items) {
            DeploymentCauseBuilder builder = new DeploymentCauseBuilder(item);
            this._visitables.get("causes").add(builder);
            this.causes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromCauses(DeploymentCause ... items) {
        for (DeploymentCause item : items) {
            DeploymentCauseBuilder builder = new DeploymentCauseBuilder(item);
            this._visitables.get("causes").remove(builder);
            if (this.causes == null) continue;
            this.causes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCauses(Collection<DeploymentCause> items) {
        for (DeploymentCause item : items) {
            DeploymentCauseBuilder builder = new DeploymentCauseBuilder(item);
            this._visitables.get("causes").remove(builder);
            if (this.causes == null) continue;
            this.causes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromCauses(Predicate<DeploymentCauseBuilder> predicate) {
        if (this.causes == null) {
            return (A)this;
        }
        Iterator<DeploymentCauseBuilder> each = this.causes.iterator();
        Object visitables = this._visitables.get("causes");
        while (each.hasNext()) {
            DeploymentCauseBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<DeploymentCause> getCauses() {
        return DeploymentDetailsFluentImpl.build(this.causes);
    }

    @Override
    public List<DeploymentCause> buildCauses() {
        return DeploymentDetailsFluentImpl.build(this.causes);
    }

    @Override
    public DeploymentCause buildCause(int index) {
        return this.causes.get(index).build();
    }

    @Override
    public DeploymentCause buildFirstCause() {
        return this.causes.get(0).build();
    }

    @Override
    public DeploymentCause buildLastCause() {
        return this.causes.get(this.causes.size() - 1).build();
    }

    @Override
    public DeploymentCause buildMatchingCause(Predicate<DeploymentCauseBuilder> predicate) {
        for (DeploymentCauseBuilder item : this.causes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCause(Predicate<DeploymentCauseBuilder> predicate) {
        for (DeploymentCauseBuilder item : this.causes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withCauses(List<DeploymentCause> causes) {
        if (this.causes != null) {
            this._visitables.get("causes").removeAll(this.causes);
        }
        if (causes != null) {
            this.causes = new ArrayList<DeploymentCauseBuilder>();
            for (DeploymentCause item : causes) {
                this.addToCauses(item);
            }
        } else {
            this.causes = null;
        }
        return (A)this;
    }

    @Override
    public A withCauses(DeploymentCause ... causes) {
        if (this.causes != null) {
            this.causes.clear();
        }
        if (causes != null) {
            for (DeploymentCause item : causes) {
                this.addToCauses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCauses() {
        return this.causes != null && !this.causes.isEmpty();
    }

    @Override
    public DeploymentDetailsFluent.CausesNested<A> addNewCause() {
        return new CausesNestedImpl();
    }

    @Override
    public DeploymentDetailsFluent.CausesNested<A> addNewCauseLike(DeploymentCause item) {
        return new CausesNestedImpl(-1, item);
    }

    @Override
    public DeploymentDetailsFluent.CausesNested<A> setNewCauseLike(int index, DeploymentCause item) {
        return new CausesNestedImpl(index, item);
    }

    @Override
    public DeploymentDetailsFluent.CausesNested<A> editCause(int index) {
        if (this.causes.size() <= index) {
            throw new RuntimeException("Can't edit causes. Index exceeds size.");
        }
        return this.setNewCauseLike(index, this.buildCause(index));
    }

    @Override
    public DeploymentDetailsFluent.CausesNested<A> editFirstCause() {
        if (this.causes.size() == 0) {
            throw new RuntimeException("Can't edit first causes. The list is empty.");
        }
        return this.setNewCauseLike(0, this.buildCause(0));
    }

    @Override
    public DeploymentDetailsFluent.CausesNested<A> editLastCause() {
        int index = this.causes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last causes. The list is empty.");
        }
        return this.setNewCauseLike(index, this.buildCause(index));
    }

    @Override
    public DeploymentDetailsFluent.CausesNested<A> editMatchingCause(Predicate<DeploymentCauseBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.causes.size(); ++i) {
            if (!predicate.test(this.causes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching causes. No match found.");
        }
        return this.setNewCauseLike(index, this.buildCause(index));
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public A withMessage(String message) {
        this.message = message;
        return (A)this;
    }

    @Override
    public Boolean hasMessage() {
        return this.message != null;
    }

    @Override
    @Deprecated
    public A withNewMessage(String arg0) {
        return this.withMessage(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentDetailsFluentImpl that = (DeploymentDetailsFluentImpl)o;
        if (this.causes != null ? !this.causes.equals(that.causes) : that.causes != null) {
            return false;
        }
        return !(this.message != null ? !this.message.equals(that.message) : that.message != null);
    }

    public int hashCode() {
        return Objects.hash(this.causes, this.message, super.hashCode());
    }

    public class CausesNestedImpl<N>
    extends DeploymentCauseFluentImpl<DeploymentDetailsFluent.CausesNested<N>>
    implements DeploymentDetailsFluent.CausesNested<N>,
    Nested<N> {
        private final DeploymentCauseBuilder builder;
        private final int index;

        CausesNestedImpl(int index, DeploymentCause item) {
            this.index = index;
            this.builder = new DeploymentCauseBuilder(this, item);
        }

        CausesNestedImpl() {
            this.index = -1;
            this.builder = new DeploymentCauseBuilder(this);
        }

        @Override
        public N and() {
            return (N)DeploymentDetailsFluentImpl.this.setToCauses(this.index, this.builder.build());
        }

        @Override
        public N endCause() {
            return this.and();
        }
    }
}

