/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_7;

import io.fabric8.kubernetes.api.builder.v5_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_7.Nested;
import io.fabric8.openshift.api.model.v5_7.DNSSpec;
import io.fabric8.openshift.api.model.v5_7.DNSSpecFluent;
import io.fabric8.openshift.api.model.v5_7.DNSZone;
import io.fabric8.openshift.api.model.v5_7.DNSZoneBuilder;
import io.fabric8.openshift.api.model.v5_7.DNSZoneFluentImpl;
import java.util.Objects;

public class DNSSpecFluentImpl<A extends DNSSpecFluent<A>>
extends BaseFluent<A>
implements DNSSpecFluent<A> {
    private String baseDomain;
    private DNSZoneBuilder privateZone;
    private DNSZoneBuilder publicZone;

    public DNSSpecFluentImpl() {
    }

    public DNSSpecFluentImpl(DNSSpec instance) {
        this.withBaseDomain(instance.getBaseDomain());
        this.withPrivateZone(instance.getPrivateZone());
        this.withPublicZone(instance.getPublicZone());
    }

    @Override
    public String getBaseDomain() {
        return this.baseDomain;
    }

    @Override
    public A withBaseDomain(String baseDomain) {
        this.baseDomain = baseDomain;
        return (A)this;
    }

    @Override
    public Boolean hasBaseDomain() {
        return this.baseDomain != null;
    }

    @Override
    @Deprecated
    public A withNewBaseDomain(String arg0) {
        return this.withBaseDomain(new String(arg0));
    }

    @Override
    @Deprecated
    public DNSZone getPrivateZone() {
        return this.privateZone != null ? this.privateZone.build() : null;
    }

    @Override
    public DNSZone buildPrivateZone() {
        return this.privateZone != null ? this.privateZone.build() : null;
    }

    @Override
    public A withPrivateZone(DNSZone privateZone) {
        this._visitables.get("privateZone").remove(this.privateZone);
        if (privateZone != null) {
            this.privateZone = new DNSZoneBuilder(privateZone);
            this._visitables.get("privateZone").add(this.privateZone);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPrivateZone() {
        return this.privateZone != null;
    }

    @Override
    public DNSSpecFluent.PrivateZoneNested<A> withNewPrivateZone() {
        return new PrivateZoneNestedImpl();
    }

    @Override
    public DNSSpecFluent.PrivateZoneNested<A> withNewPrivateZoneLike(DNSZone item) {
        return new PrivateZoneNestedImpl(item);
    }

    @Override
    public DNSSpecFluent.PrivateZoneNested<A> editPrivateZone() {
        return this.withNewPrivateZoneLike(this.getPrivateZone());
    }

    @Override
    public DNSSpecFluent.PrivateZoneNested<A> editOrNewPrivateZone() {
        return this.withNewPrivateZoneLike(this.getPrivateZone() != null ? this.getPrivateZone() : new DNSZoneBuilder().build());
    }

    @Override
    public DNSSpecFluent.PrivateZoneNested<A> editOrNewPrivateZoneLike(DNSZone item) {
        return this.withNewPrivateZoneLike(this.getPrivateZone() != null ? this.getPrivateZone() : item);
    }

    @Override
    @Deprecated
    public DNSZone getPublicZone() {
        return this.publicZone != null ? this.publicZone.build() : null;
    }

    @Override
    public DNSZone buildPublicZone() {
        return this.publicZone != null ? this.publicZone.build() : null;
    }

    @Override
    public A withPublicZone(DNSZone publicZone) {
        this._visitables.get("publicZone").remove(this.publicZone);
        if (publicZone != null) {
            this.publicZone = new DNSZoneBuilder(publicZone);
            this._visitables.get("publicZone").add(this.publicZone);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPublicZone() {
        return this.publicZone != null;
    }

    @Override
    public DNSSpecFluent.PublicZoneNested<A> withNewPublicZone() {
        return new PublicZoneNestedImpl();
    }

    @Override
    public DNSSpecFluent.PublicZoneNested<A> withNewPublicZoneLike(DNSZone item) {
        return new PublicZoneNestedImpl(item);
    }

    @Override
    public DNSSpecFluent.PublicZoneNested<A> editPublicZone() {
        return this.withNewPublicZoneLike(this.getPublicZone());
    }

    @Override
    public DNSSpecFluent.PublicZoneNested<A> editOrNewPublicZone() {
        return this.withNewPublicZoneLike(this.getPublicZone() != null ? this.getPublicZone() : new DNSZoneBuilder().build());
    }

    @Override
    public DNSSpecFluent.PublicZoneNested<A> editOrNewPublicZoneLike(DNSZone item) {
        return this.withNewPublicZoneLike(this.getPublicZone() != null ? this.getPublicZone() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DNSSpecFluentImpl that = (DNSSpecFluentImpl)o;
        if (this.baseDomain != null ? !this.baseDomain.equals(that.baseDomain) : that.baseDomain != null) {
            return false;
        }
        if (this.privateZone != null ? !this.privateZone.equals(that.privateZone) : that.privateZone != null) {
            return false;
        }
        return !(this.publicZone != null ? !this.publicZone.equals(that.publicZone) : that.publicZone != null);
    }

    public int hashCode() {
        return Objects.hash(this.baseDomain, this.privateZone, this.publicZone, super.hashCode());
    }

    public class PublicZoneNestedImpl<N>
    extends DNSZoneFluentImpl<DNSSpecFluent.PublicZoneNested<N>>
    implements DNSSpecFluent.PublicZoneNested<N>,
    Nested<N> {
        private final DNSZoneBuilder builder;

        PublicZoneNestedImpl(DNSZone item) {
            this.builder = new DNSZoneBuilder(this, item);
        }

        PublicZoneNestedImpl() {
            this.builder = new DNSZoneBuilder(this);
        }

        @Override
        public N and() {
            return (N)DNSSpecFluentImpl.this.withPublicZone(this.builder.build());
        }

        @Override
        public N endPublicZone() {
            return this.and();
        }
    }

    public class PrivateZoneNestedImpl<N>
    extends DNSZoneFluentImpl<DNSSpecFluent.PrivateZoneNested<N>>
    implements DNSSpecFluent.PrivateZoneNested<N>,
    Nested<N> {
        private final DNSZoneBuilder builder;

        PrivateZoneNestedImpl(DNSZone item) {
            this.builder = new DNSZoneBuilder(this, item);
        }

        PrivateZoneNestedImpl() {
            this.builder = new DNSZoneBuilder(this);
        }

        @Override
        public N and() {
            return (N)DNSSpecFluentImpl.this.withPrivateZone(this.builder.build());
        }

        @Override
        public N endPrivateZone() {
            return this.and();
        }
    }
}

