/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_7;

import io.fabric8.kubernetes.api.builder.v5_7.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_7.ConsoleStatus;
import io.fabric8.openshift.api.model.v5_7.ConsoleStatusFluent;
import io.fabric8.openshift.api.model.v5_7.ConsoleStatusFluentImpl;
import java.util.Objects;

public class ConsoleStatusBuilder
extends ConsoleStatusFluentImpl<ConsoleStatusBuilder>
implements VisitableBuilder<ConsoleStatus, ConsoleStatusBuilder> {
    ConsoleStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ConsoleStatusBuilder() {
        this(true);
    }

    public ConsoleStatusBuilder(Boolean validationEnabled) {
        this(new ConsoleStatus(), validationEnabled);
    }

    public ConsoleStatusBuilder(ConsoleStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ConsoleStatusBuilder(ConsoleStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ConsoleStatus(), validationEnabled);
    }

    public ConsoleStatusBuilder(ConsoleStatusFluent<?> fluent, ConsoleStatus instance) {
        this(fluent, instance, true);
    }

    public ConsoleStatusBuilder(ConsoleStatusFluent<?> fluent, ConsoleStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withConsoleURL(instance.getConsoleURL());
        this.validationEnabled = validationEnabled;
    }

    public ConsoleStatusBuilder(ConsoleStatus instance) {
        this(instance, (Boolean)true);
    }

    public ConsoleStatusBuilder(ConsoleStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withConsoleURL(instance.getConsoleURL());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ConsoleStatus build() {
        ConsoleStatus buildable = new ConsoleStatus(this.fluent.getConsoleURL());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConsoleStatusBuilder that = (ConsoleStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

