/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_7;

import io.fabric8.kubernetes.api.builder.v5_7.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_7.AWSPlatformSpec;
import io.fabric8.openshift.api.model.v5_7.AWSPlatformSpecFluent;
import io.fabric8.openshift.api.model.v5_7.AWSPlatformSpecFluentImpl;
import java.util.Objects;

public class AWSPlatformSpecBuilder
extends AWSPlatformSpecFluentImpl<AWSPlatformSpecBuilder>
implements VisitableBuilder<AWSPlatformSpec, AWSPlatformSpecBuilder> {
    AWSPlatformSpecFluent<?> fluent;
    Boolean validationEnabled;

    public AWSPlatformSpecBuilder() {
        this(true);
    }

    public AWSPlatformSpecBuilder(Boolean validationEnabled) {
        this(new AWSPlatformSpec(), validationEnabled);
    }

    public AWSPlatformSpecBuilder(AWSPlatformSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public AWSPlatformSpecBuilder(AWSPlatformSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new AWSPlatformSpec(), validationEnabled);
    }

    public AWSPlatformSpecBuilder(AWSPlatformSpecFluent<?> fluent, AWSPlatformSpec instance) {
        this(fluent, instance, true);
    }

    public AWSPlatformSpecBuilder(AWSPlatformSpecFluent<?> fluent, AWSPlatformSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withServiceEndpoints(instance.getServiceEndpoints());
        this.validationEnabled = validationEnabled;
    }

    public AWSPlatformSpecBuilder(AWSPlatformSpec instance) {
        this(instance, (Boolean)true);
    }

    public AWSPlatformSpecBuilder(AWSPlatformSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withServiceEndpoints(instance.getServiceEndpoints());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public AWSPlatformSpec build() {
        AWSPlatformSpec buildable = new AWSPlatformSpec(this.fluent.getServiceEndpoints());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AWSPlatformSpecBuilder that = (AWSPlatformSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

