/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_7.dsl.internal;

import io.fabric8.kubernetes.clnt.v5_7.dsl.internal.PodControllerOperationContext;
import java.util.concurrent.TimeUnit;

public class RollingOperationContext
extends PodControllerOperationContext {
    private boolean rolling;
    private long rollingTimeout;
    private TimeUnit rollingTimeUnit;

    public RollingOperationContext() {
    }

    public RollingOperationContext(String containerId, boolean rolling, long rollingTimeout, TimeUnit rollingTimeUnit, Integer logWaitTimeout) {
        super(containerId, logWaitTimeout);
        this.rolling = rolling;
        this.rollingTimeout = rollingTimeout;
        this.rollingTimeUnit = rollingTimeUnit != null ? rollingTimeUnit : TimeUnit.MILLISECONDS;
    }

    public Boolean getRolling() {
        return this.rolling;
    }

    public long getRollingTimeout() {
        return this.rollingTimeout;
    }

    public TimeUnit getRollingTimeUnit() {
        return this.rollingTimeUnit;
    }

    public RollingOperationContext withRolling(boolean rolling) {
        return new RollingOperationContext(this.containerId, rolling, this.rollingTimeout, this.rollingTimeUnit, this.logWaitTimeout);
    }

    public RollingOperationContext withRollingTimeout(long rollingTimeout) {
        return new RollingOperationContext(this.containerId, this.rolling, rollingTimeout, this.rollingTimeUnit, this.logWaitTimeout);
    }

    public RollingOperationContext withRollingTimeUnit(TimeUnit rollingTimeUnit) {
        return new RollingOperationContext(this.containerId, this.rolling, this.rollingTimeout, rollingTimeUnit, this.logWaitTimeout);
    }

    @Override
    public RollingOperationContext withContainerId(String containerId) {
        return new RollingOperationContext(containerId, this.rolling, this.rollingTimeout, this.rollingTimeUnit, this.logWaitTimeout);
    }

    @Override
    public RollingOperationContext withLogWaitTimout(Integer logWaitTimeout) {
        return new RollingOperationContext(this.containerId, this.rolling, this.rollingTimeout, this.rollingTimeUnit, logWaitTimeout);
    }
}

