/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_7;

import io.fabric8.kubernetes.api.model.v5_7.APIService;
import io.fabric8.kubernetes.api.model.v5_7.APIServiceList;
import io.fabric8.kubernetes.api.model.v5_7.Binding;
import io.fabric8.kubernetes.api.model.v5_7.ComponentStatus;
import io.fabric8.kubernetes.api.model.v5_7.ComponentStatusList;
import io.fabric8.kubernetes.api.model.v5_7.ConfigMap;
import io.fabric8.kubernetes.api.model.v5_7.ConfigMapList;
import io.fabric8.kubernetes.api.model.v5_7.Endpoints;
import io.fabric8.kubernetes.api.model.v5_7.EndpointsList;
import io.fabric8.kubernetes.api.model.v5_7.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_7.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.v5_7.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v5_7.LimitRange;
import io.fabric8.kubernetes.api.model.v5_7.LimitRangeList;
import io.fabric8.kubernetes.api.model.v5_7.Namespace;
import io.fabric8.kubernetes.api.model.v5_7.NamespaceList;
import io.fabric8.kubernetes.api.model.v5_7.Node;
import io.fabric8.kubernetes.api.model.v5_7.NodeList;
import io.fabric8.kubernetes.api.model.v5_7.PersistentVolume;
import io.fabric8.kubernetes.api.model.v5_7.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.v5_7.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.v5_7.PersistentVolumeList;
import io.fabric8.kubernetes.api.model.v5_7.Pod;
import io.fabric8.kubernetes.api.model.v5_7.PodList;
import io.fabric8.kubernetes.api.model.v5_7.ReplicationController;
import io.fabric8.kubernetes.api.model.v5_7.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.v5_7.ResourceQuota;
import io.fabric8.kubernetes.api.model.v5_7.ResourceQuotaList;
import io.fabric8.kubernetes.api.model.v5_7.Secret;
import io.fabric8.kubernetes.api.model.v5_7.SecretList;
import io.fabric8.kubernetes.api.model.v5_7.Service;
import io.fabric8.kubernetes.api.model.v5_7.ServiceAccount;
import io.fabric8.kubernetes.api.model.v5_7.ServiceAccountList;
import io.fabric8.kubernetes.api.model.v5_7.ServiceList;
import io.fabric8.kubernetes.api.model.v5_7.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.v5_7.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.v5_7.authentication.TokenReview;
import io.fabric8.kubernetes.api.model.v5_7.batch.v1.Job;
import io.fabric8.kubernetes.api.model.v5_7.batch.v1beta1.CronJob;
import io.fabric8.kubernetes.api.model.v5_7.certificates.v1beta1.CertificateSigningRequest;
import io.fabric8.kubernetes.api.model.v5_7.certificates.v1beta1.CertificateSigningRequestList;
import io.fabric8.kubernetes.api.model.v5_7.coordination.v1.Lease;
import io.fabric8.kubernetes.api.model.v5_7.coordination.v1.LeaseList;
import io.fabric8.kubernetes.api.model.v5_7.extensions.Deployment;
import io.fabric8.kubernetes.api.model.v5_7.node.v1beta1.RuntimeClass;
import io.fabric8.kubernetes.api.model.v5_7.node.v1beta1.RuntimeClassList;
import io.fabric8.kubernetes.clnt.v5_7.Adapters;
import io.fabric8.kubernetes.clnt.v5_7.AdmissionRegistrationAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_7.AdmissionRegistrationAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_7.ApiextensionsAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_7.AppsAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_7.AuthorizationAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_7.AutoscalingAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_7.BaseClient;
import io.fabric8.kubernetes.clnt.v5_7.BatchAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_7.CertificatesAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_7.Client;
import io.fabric8.kubernetes.clnt.v5_7.Config;
import io.fabric8.kubernetes.clnt.v5_7.CustomResource;
import io.fabric8.kubernetes.clnt.v5_7.DiscoveryAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_7.EventingAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_7.ExtensionsAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_7.FlowControlAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_7.GenericKubernetesClient;
import io.fabric8.kubernetes.clnt.v5_7.Handlers;
import io.fabric8.kubernetes.clnt.v5_7.MetricAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_7.NetworkAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_7.PolicyAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_7.RbacAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_7.SchedulingAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_7.StorageAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_7.V1APIGroupClient;
import io.fabric8.kubernetes.clnt.v5_7.VersionInfo;
import io.fabric8.kubernetes.clnt.v5_7.dsl.ApiextensionsAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_7.dsl.AppsAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_7.dsl.AuthorizationAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_7.dsl.AutoscalingAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_7.dsl.BatchAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_7.dsl.CertificatesAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_7.dsl.DiscoveryAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_7.dsl.EventingAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_7.dsl.ExtensionsAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_7.dsl.FlowControlAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_7.dsl.InOutCreateable;
import io.fabric8.kubernetes.clnt.v5_7.dsl.KubernetesListMixedOperation;
import io.fabric8.kubernetes.clnt.v5_7.dsl.MetricAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_7.dsl.MixedOperation;
import io.fabric8.kubernetes.clnt.v5_7.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v5_7.dsl.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v5_7.dsl.NetworkAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_7.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v5_7.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v5_7.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v5_7.dsl.PolicyAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_7.dsl.RbacAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_7.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_7.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v5_7.dsl.SchedulingAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_7.dsl.ServiceResource;
import io.fabric8.kubernetes.clnt.v5_7.dsl.StorageAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_7.dsl.V1APIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_7.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.clnt.v5_7.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v5_7.dsl.base.ResourceDefinitionContext;
import io.fabric8.kubernetes.clnt.v5_7.dsl.internal.ClusterOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_7.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_7.dsl.internal.KubernetesListOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_7.dsl.internal.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl;
import io.fabric8.kubernetes.clnt.v5_7.dsl.internal.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl;
import io.fabric8.kubernetes.clnt.v5_7.dsl.internal.RawCustomResourceOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_7.dsl.internal.apps.v1.DeploymentOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_7.dsl.internal.apps.v1.ReplicaSetOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_7.dsl.internal.apps.v1.StatefulSetOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_7.dsl.internal.batch.v1.JobOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_7.dsl.internal.batch.v1beta1.CronJobOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_7.dsl.internal.core.v1.BindingOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_7.dsl.internal.core.v1.ComponentStatusOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_7.dsl.internal.core.v1.PodOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_7.dsl.internal.core.v1.ReplicationControllerOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_7.dsl.internal.core.v1.ServiceOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_7.extended.run.RunConfigBuilder;
import io.fabric8.kubernetes.clnt.v5_7.extended.run.RunOperations;
import io.fabric8.kubernetes.clnt.v5_7.informers.SharedInformerFactory;
import io.fabric8.kubernetes.clnt.v5_7.utils.Serialization;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import okhttp3.OkHttpClient;

public abstract class BaseKubernetesClient<C extends Client>
extends BaseClient
implements GenericKubernetesClient<C> {
    protected BaseKubernetesClient() {
    }

    protected BaseKubernetesClient(String masterUrl) {
        super(masterUrl);
    }

    protected BaseKubernetesClient(Config config) {
        super(config);
    }

    protected BaseKubernetesClient(OkHttpClient httpClient, Config config) {
        super(httpClient, config);
    }

    @Override
    public NonNamespaceOperation<ComponentStatus, ComponentStatusList, Resource<ComponentStatus>> componentstatuses() {
        return new ComponentStatusOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> load(InputStream is) {
        return this.resourceListFor(is);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(KubernetesResourceList item) {
        return this.resourceListFor(item);
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl resourceListFor(Object item) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.httpClient, this.getConfiguration(), item);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(HasMetadata ... items) {
        return this.resourceList(((KubernetesListBuilder)new KubernetesListBuilder().withItems(items)).build());
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(Collection<HasMetadata> items) {
        return this.resourceList(((KubernetesListBuilder)new KubernetesListBuilder().withItems(new ArrayList<HasMetadata>(items))).build());
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(String s) {
        return this.resourceListFor(s);
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata> resource(HasMetadata item) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.httpClient, this.getConfiguration(), item);
    }

    @Override
    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata> resource(String s) {
        return this.resource((HasMetadata)Serialization.unmarshal(s));
    }

    @Override
    public MixedOperation<Binding, KubernetesResourceList<Binding>, Resource<Binding>> bindings() {
        return new BindingOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<Endpoints, EndpointsList, Resource<Endpoints>> endpoints() {
        return Handlers.getOperation(Endpoints.class, EndpointsList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<Namespace, NamespaceList, Resource<Namespace>> namespaces() {
        return Handlers.getOperation(Namespace.class, NamespaceList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<Node, NodeList, Resource<Node>> nodes() {
        return Handlers.getOperation(Node.class, NodeList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<PersistentVolume, PersistentVolumeList, Resource<PersistentVolume>> persistentVolumes() {
        return Handlers.getOperation(PersistentVolume.class, PersistentVolumeList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, Resource<PersistentVolumeClaim>> persistentVolumeClaims() {
        return Handlers.getOperation(PersistentVolumeClaim.class, PersistentVolumeClaimList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<Pod, PodList, PodResource<Pod>> pods() {
        return new PodOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<ReplicationController, ReplicationControllerList, RollableScalableResource<ReplicationController>> replicationControllers() {
        return new ReplicationControllerOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<ResourceQuota, ResourceQuotaList, Resource<ResourceQuota>> resourceQuotas() {
        return Handlers.getOperation(ResourceQuota.class, ResourceQuotaList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public SchedulingAPIGroupDSL scheduling() {
        return this.adapt(SchedulingAPIGroupClient.class);
    }

    @Override
    public MixedOperation<Secret, SecretList, Resource<Secret>> secrets() {
        return Handlers.getOperation(Secret.class, SecretList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<Service, ServiceList, ServiceResource<Service>> services() {
        return new ServiceOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<ServiceAccount, ServiceAccountList, Resource<ServiceAccount>> serviceAccounts() {
        return Handlers.getOperation(ServiceAccount.class, ServiceAccountList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<APIService, APIServiceList, Resource<APIService>> apiServices() {
        return Handlers.getOperation(APIService.class, APIServiceList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public KubernetesListMixedOperation lists() {
        return new KubernetesListOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<ConfigMap, ConfigMapList, Resource<ConfigMap>> configMaps() {
        return Handlers.getOperation(ConfigMap.class, ConfigMapList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<LimitRange, LimitRangeList, Resource<LimitRange>> limitRanges() {
        return Handlers.getOperation(LimitRange.class, LimitRangeList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public ApiextensionsAPIGroupDSL apiextensions() {
        return this.adapt(ApiextensionsAPIGroupClient.class);
    }

    @Override
    public NonNamespaceOperation<CertificateSigningRequest, CertificateSigningRequestList, Resource<CertificateSigningRequest>> certificateSigningRequests() {
        return Handlers.getOperation(CertificateSigningRequest.class, CertificateSigningRequestList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public CertificatesAPIGroupDSL certificates() {
        return this.adapt(CertificatesAPIGroupClient.class);
    }

    @Override
    public AuthorizationAPIGroupDSL authorization() {
        return this.adapt(AuthorizationAPIGroupClient.class);
    }

    @Override
    public InOutCreateable<TokenReview, TokenReview> tokenReviews() {
        return Handlers.getNonListingOperation(TokenReview.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public <T extends CustomResource> MixedOperation<T, KubernetesResourceList<T>, Resource<T>> customResources(Class<T> resourceType) {
        return this.customResources(resourceType, null);
    }

    @Override
    public <T extends CustomResource, L extends KubernetesResourceList<T>> MixedOperation<T, L, Resource<T>> customResources(Class<T> resourceType, Class<L> listClass) {
        return this.customResources((ResourceDefinitionContext)CustomResourceDefinitionContext.fromCustomResourceType(resourceType), (Class)resourceType, (Class)listClass);
    }

    public <T extends HasMetadata, L extends KubernetesResourceList<T>> HasMetadataOperation<T, L, Resource<T>> resources(Class<T> resourceType, Class<L> listClass) {
        try {
            return Handlers.getOperation(resourceType, listClass, this.httpClient, this.getConfiguration());
        }
        catch (Exception e) {
            return this.customResources(ResourceDefinitionContext.fromResourceType(resourceType), (Class)resourceType, (Class)listClass);
        }
    }

    public <T extends HasMetadata, L extends KubernetesResourceList<T>> HasMetadataOperationsImpl<T, L> customResources(ResourceDefinitionContext rdContext, Class<T> resourceType, Class<L> listClass) {
        return new HasMetadataOperationsImpl<T, L>(this.httpClient, this.getConfiguration(), rdContext, resourceType, listClass);
    }

    @Override
    public RawCustomResourceOperationsImpl customResource(CustomResourceDefinitionContext customResourceDefinition) {
        return new RawCustomResourceOperationsImpl(this.httpClient, this.getConfiguration(), customResourceDefinition);
    }

    @Override
    public DiscoveryAPIGroupDSL discovery() {
        return this.adapt(DiscoveryAPIGroupClient.class);
    }

    @Override
    public EventingAPIGroupDSL events() {
        return this.adapt(EventingAPIGroupClient.class);
    }

    @Override
    public C inAnyNamespace() {
        return (C)((Client)this.inNamespace(null));
    }

    @Override
    public ExtensionsAPIGroupDSL extensions() {
        return this.adapt(ExtensionsAPIGroupClient.class);
    }

    @Override
    public FlowControlAPIGroupDSL flowControl() {
        return this.adapt(FlowControlAPIGroupClient.class);
    }

    @Override
    public VersionInfo getVersion() {
        return BaseKubernetesClient.getVersion(this);
    }

    public static VersionInfo getVersion(BaseClient client) {
        return new ClusterOperationsImpl(client.httpClient, client.getConfiguration(), "version").fetchVersion();
    }

    @Override
    public V1APIGroupDSL v1() {
        return this.adapt(V1APIGroupClient.class);
    }

    @Override
    public AdmissionRegistrationAPIGroupDSL admissionRegistration() {
        return this.adapt(AdmissionRegistrationAPIGroupClient.class);
    }

    @Override
    public AppsAPIGroupDSL apps() {
        return this.adapt(AppsAPIGroupClient.class);
    }

    @Override
    public AutoscalingAPIGroupDSL autoscaling() {
        return this.adapt(AutoscalingAPIGroupClient.class);
    }

    @Override
    public NetworkAPIGroupDSL network() {
        return this.adapt(NetworkAPIGroupClient.class);
    }

    @Override
    public StorageAPIGroupDSL storage() {
        return this.adapt(StorageAPIGroupClient.class);
    }

    @Override
    public BatchAPIGroupDSL batch() {
        return this.adapt(BatchAPIGroupClient.class);
    }

    @Override
    public MetricAPIGroupDSL top() {
        return this.adapt(MetricAPIGroupClient.class);
    }

    @Override
    public PolicyAPIGroupDSL policy() {
        return this.adapt(PolicyAPIGroupClient.class);
    }

    @Override
    public RbacAPIGroupDSL rbac() {
        return this.adapt(RbacAPIGroupClient.class);
    }

    @Override
    public SharedInformerFactory informers() {
        return new SharedInformerFactory(this);
    }

    @Override
    public SharedInformerFactory informers(ExecutorService executorService) {
        return new SharedInformerFactory(this, executorService);
    }

    @Override
    public MixedOperation<Lease, LeaseList, Resource<Lease>> leases() {
        return Handlers.getOperation(Lease.class, LeaseList.class, this.httpClient, this.getConfiguration());
    }

    @Override
    public RunOperations run() {
        return new RunOperations(this.httpClient, this.getConfiguration(), this.getNamespace(), new RunConfigBuilder());
    }

    @Override
    public NonNamespaceOperation<RuntimeClass, RuntimeClassList, Resource<RuntimeClass>> runtimeClasses() {
        return Handlers.getOperation(RuntimeClass.class, RuntimeClassList.class, this.httpClient, this.getConfiguration());
    }

    static {
        Handlers.register(Pod.class, PodOperationsImpl::new);
        Handlers.register(Job.class, JobOperationsImpl::new);
        Handlers.register(CronJob.class, CronJobOperationsImpl::new);
        Handlers.register(Binding.class, BindingOperationsImpl::new);
        Handlers.register(ComponentStatus.class, ComponentStatusOperationsImpl::new);
        Handlers.register(Service.class, ServiceOperationsImpl::new);
        Handlers.register(io.fabric8.kubernetes.api.model.v5_7.apps.Deployment.class, DeploymentOperationsImpl::new);
        Handlers.register(Deployment.class, io.fabric8.kubernetes.clnt.v5_7.dsl.internal.extensions.v1beta1.DeploymentOperationsImpl::new);
        Handlers.register(ReplicaSet.class, ReplicaSetOperationsImpl::new);
        Handlers.register(io.fabric8.kubernetes.api.model.v5_7.extensions.ReplicaSet.class, io.fabric8.kubernetes.clnt.v5_7.dsl.internal.extensions.v1beta1.ReplicaSetOperationsImpl::new);
        Handlers.register(ReplicationController.class, ReplicationControllerOperationsImpl::new);
        Handlers.register(StatefulSet.class, StatefulSetOperationsImpl::new);
        Adapters.list(Client.class);
    }
}

