/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_7.networking.v1;

import io.fabric8.kubernetes.api.builder.v5_7.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_7.networking.v1.IngressClass;
import io.fabric8.kubernetes.api.model.v5_7.networking.v1.IngressClassFluent;
import io.fabric8.kubernetes.api.model.v5_7.networking.v1.IngressClassFluentImpl;
import java.util.Objects;

public class IngressClassBuilder
extends IngressClassFluentImpl<IngressClassBuilder>
implements VisitableBuilder<IngressClass, IngressClassBuilder> {
    IngressClassFluent<?> fluent;
    Boolean validationEnabled;

    public IngressClassBuilder() {
        this(true);
    }

    public IngressClassBuilder(Boolean validationEnabled) {
        this(new IngressClass(), validationEnabled);
    }

    public IngressClassBuilder(IngressClassFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public IngressClassBuilder(IngressClassFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new IngressClass(), validationEnabled);
    }

    public IngressClassBuilder(IngressClassFluent<?> fluent, IngressClass instance) {
        this(fluent, instance, true);
    }

    public IngressClassBuilder(IngressClassFluent<?> fluent, IngressClass instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        this.validationEnabled = validationEnabled;
    }

    public IngressClassBuilder(IngressClass instance) {
        this(instance, (Boolean)true);
    }

    public IngressClassBuilder(IngressClass instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public IngressClass build() {
        IngressClass buildable = new IngressClass(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressClassBuilder that = (IngressClassBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

